/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.logging;

import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class AsyncHandler
extends Handler {
    private int bufferSize = 3000;
    private int loggingInterval = 5000;
    private Handler handler;
    private Thread thread = null;
    protected volatile boolean closed = false;
    private ArrayList<LogEntry> inList = new ArrayList();
    private ArrayList<LogEntry> outList = new ArrayList();
    int bufferSkipCount = 0;
    private static boolean debugMode = false;

    public AsyncHandler(Handler handler) {
        this.handler = handler;
        this.startAsyncService();
    }

    public AsyncHandler(Handler handler, int milliSec, int bufferSize) {
        this.handler = handler;
        this.loggingInterval = milliSec;
        this.bufferSize = bufferSize;
        this.startAsyncService();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean debugMode) {
        AsyncHandler.debugMode = debugMode;
    }

    public void close() throws SecurityException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.handler.close();
    }

    public void flush() {
        this.handler.flush();
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        LogEntry entry = new LogEntry(record, this);
        if (!this.thread.isAlive()) {
            this.startAsyncService();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" - [");
        sb.append(Thread.currentThread().getName());
        sb.append("] - ");
        sb.append(record.getMessage());
        record.setMessage(sb.toString());
        if (this.inList.size() >= this.bufferSize) {
            ++this.bufferSkipCount;
            this.handler.publish(record);
        } else {
            record.getSourceMethodName();
            this.inList.add(entry);
        }
    }

    public void startAsyncService() {
        this.thread = new Thread("AsyncHandler"){

            public void run() {
                long timeSpent = 0L;
                long timetosleep = 0L;
                while (true) {
                    timetosleep = (long)AsyncHandler.this.loggingInterval - timeSpent;
                    try {
                        if (timetosleep > 0L) {
                            1.sleep(timetosleep);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    long stime = System.currentTimeMillis();
                    AsyncHandler.this.initiateLogDispatch();
                    timeSpent = System.currentTimeMillis() - stime;
                }
            }
        };
        this.thread.start();
    }

    private void initiateLogDispatch() {
        try {
            this.swapList();
            int logEntrySize = this.outList.size();
            if (logEntrySize > 0) {
                for (int i = 0; i < logEntrySize; ++i) {
                    LogEntry le = this.outList.get(i);
                    if (le == null) continue;
                    le.flush();
                }
            }
            if (debugMode) {
                System.out.println("Logged " + logEntrySize + " log entries. Skipped Async count " + this.bufferSkipCount);
            }
            this.bufferSkipCount = 0;
            this.outList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void swapList() {
        ArrayList<LogEntry> temp1 = this.inList;
        ArrayList<LogEntry> temp2 = this.outList;
        this.outList = temp1;
        this.inList = temp2;
    }

    protected static class LogEntry {
        private LogRecord record;
        private AsyncHandler aHandler;

        public LogEntry(LogRecord record, AsyncHandler aHandler) {
            this.record = record;
            this.aHandler = aHandler;
        }

        public boolean flush() {
            if (this.aHandler.closed) {
                return false;
            }
            this.aHandler.handler.publish(this.record);
            return true;
        }
    }
}

