/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.io;

import java.awt.Robot;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import org.quickserver.util.io.MaskingThread;

public class PasswordField {
    private static Logger logger = Logger.getLogger(PasswordField.class.getName());

    public static final char[] getPassword(String prompt) throws IOException {
        return PasswordField.getPassword(System.in, prompt);
    }

    public static final char[] getPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block6: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block6;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block6;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block6;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        System.out.print("\b");
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().startsWith("windows")) {
            try {
                Robot robot = new Robot();
                robot.keyPress(18);
                robot.keyPress(118);
                robot.keyRelease(118);
                robot.keyRelease(18);
            }
            catch (Exception ignore) {
                logger.warning("Could not clears command history: " + ignore);
            }
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }
}

