/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class JvmUtil {
    private static final Logger logger = Logger.getLogger(JvmUtil.class.getName());
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;

    public static String getUptime(Date lst) {
        if (lst == null) {
            return "N/A";
        }
        return JvmUtil.getUptime(System.currentTimeMillis() - lst.getTime());
    }

    public static String getUptime(long ms) {
        StringBuilder sb = new StringBuilder();
        if (ms > 86400000L) {
            sb.append(ms / 86400000L).append("d ");
            ms %= 86400000L;
        }
        if (ms > 3600000L) {
            sb.append(ms / 3600000L).append("h ");
            ms %= 3600000L;
        }
        if (ms > 60000L) {
            sb.append(ms / 60000L).append("m ");
            ms %= 60000L;
        }
        if (ms > 1000L) {
            sb.append(ms / 1000L).append("s");
            ms %= 1000L;
        }
        return sb.toString();
    }

    public static boolean dumpHeap(String fileName, boolean live) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            logger.fine("Taking heap dump..");
            HotSpotDiagnosticMXBean hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            hotspotMBean.dumpHeap(fileName, live);
            logger.fine("Heap dump done");
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error: " + e, e);
            return false;
        }
    }

    public static boolean dumpJmapHisto(String fileName) {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int pi = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, pi);
        String command = "jmap -histo " + pid;
        Process p = null;
        try {
            logger.log(Level.INFO, "Command executing : {0}", command);
            p = Runtime.getRuntime().exec(command);
            JvmUtil.dumpProcessOutputToFile(p, fileName);
            logger.log(Level.INFO, "Command executed : {0}", command);
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error: " + ex, ex);
            return false;
        }
    }

    public static boolean dumpJmapHistoToLog() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int pi = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, pi);
        String command = "jmap -histo " + pid;
        Process p = null;
        try {
            logger.log(Level.INFO, "Command executing : {0}", command);
            p = Runtime.getRuntime().exec(command);
            JvmUtil.dumpProcessOutputToLog(p);
            logger.log(Level.INFO, "Command executed : {0}", command);
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error: " + ex, ex);
            return false;
        }
    }

    public static boolean threadDump(String fileName) {
        ThreadInfo[] threadsInfo = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        JvmUtil.dumpToFile(threadsInfo, fileName);
        return true;
    }

    public static boolean threadDumpToLog() {
        ThreadInfo[] threadsInfo = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        JvmUtil.dumpToLog(threadsInfo);
        return true;
    }

    public static boolean dumpJStack(String fileName) {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int pi = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, pi);
        String command = "jstack -l " + pid;
        Process p = null;
        try {
            logger.log(Level.INFO, "Command executing : {0}", command);
            p = Runtime.getRuntime().exec(command);
            JvmUtil.dumpProcessOutputToFile(p, fileName);
            logger.log(Level.INFO, "Command executed : {0}", command);
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error: " + ex, ex);
            return false;
        }
    }

    public static boolean dumpJStackToLog() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int pi = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, pi);
        String command = "jstack -l " + pid;
        Process p = null;
        try {
            logger.log(Level.INFO, "Command executing : {0}", command);
            p = Runtime.getRuntime().exec(command);
            JvmUtil.dumpProcessOutputToLog(p);
            logger.log(Level.INFO, "Command executed : {0}", command);
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error: " + ex, ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dumpProcessOutputToFile(Process p, String fileName) {
        block26: {
            BufferedWriter writer = null;
            BufferedReader reader = null;
            logger.log(Level.INFO, "Start of ProcessOutput to file {0}", fileName);
            String line = null;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            writer = new BufferedWriter(new FileWriter(fileName));
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\r\n");
            }
            writer.flush();
            logger.log(Level.INFO, "End of ProcessOutput to file {0}", fileName);
            Object var6_6 = null;
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Exception: " + e2, e2);
            }
            try {
                if (null != writer) {
                    writer.close();
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Exception: " + e2, e2);
            }
            if (p != null) {
                p.destroy();
            }
            break block26;
            {
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception: " + e, e);
                    Object var6_7 = null;
                    try {
                        if (null != reader) {
                            reader.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, "Exception: " + e2, e2);
                    }
                    try {
                        if (null != writer) {
                            writer.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, "Exception: " + e2, e2);
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (null != reader) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.WARNING, "Exception: " + e2, e2);
                }
                try {
                    if (null != writer) {
                        writer.close();
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.WARNING, "Exception: " + e2, e2);
                }
                if (p != null) {
                    p.destroy();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dumpProcessOutputToLog(Process p) {
        block17: {
            BufferedReader reader = null;
            logger.log(Level.INFO, "Start of ProcessOutput to log ");
            String line = null;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.info(line);
            }
            logger.log(Level.INFO, "End of ProcessOutput to log");
            Object var4_4 = null;
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Exception: " + e2, e2);
            }
            if (p != null) {
                p.destroy();
            }
            break block17;
            {
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception: " + e, e);
                    Object var4_5 = null;
                    try {
                        if (null != reader) {
                            reader.close();
                        }
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, "Exception: " + e2, e2);
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (null != reader) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.WARNING, "Exception: " + e2, e2);
                }
                if (p != null) {
                    p.destroy();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dumpToFile(ThreadInfo[] threadsInfo, String fileName) {
        block12: {
            File file = null;
            BufferedWriter writer = null;
            logger.log(Level.INFO, "Start of Thread dump to file {0}", fileName);
            file = new File(fileName);
            writer = new BufferedWriter(new FileWriter(file));
            for (ThreadInfo t : threadsInfo) {
                writer.write(t.toString());
            }
            writer.flush();
            logger.log(Level.INFO, "End of Thread dump to file {0}", fileName);
            Object var9_9 = null;
            try {
                if (null != writer) {
                    writer.close();
                }
                break block12;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception: " + e, e);
            }
            break block12;
            {
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "IOException: " + ioe, ioe);
                    Object var9_10 = null;
                    try {
                        if (null != writer) {
                            writer.close();
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Exception: " + e, e);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (null != writer) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception: " + e, e);
                }
                throw throwable;
            }
        }
    }

    public static void dumpToLog(ThreadInfo[] threadsInfo) {
        logger.info("Start of Thread dump to log");
        for (ThreadInfo t : threadsInfo) {
            logger.info(t.toString());
        }
        logger.info("End of Thread dump to log");
    }
}

