/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quickserver.util.FileChangeListener;

public class FileChangeMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger(FileChangeMonitor.class.getName());
    private static int sleepInterval = 15000;
    private static Map map = new ConcurrentHashMap();
    private static Map lastModified = new ConcurrentHashMap();
    private static volatile boolean flag;
    private static volatile Thread thread;
    private static FileChangeMonitor fcm;

    public static synchronized boolean addListener(String file, FileChangeListener fcl) {
        if (file == null) {
            return false;
        }
        File myFile = new File(file);
        if (!myFile.canRead()) {
            return false;
        }
        ArrayList<FileChangeListener> list = (ArrayList<FileChangeListener>)map.get(file);
        if (list == null) {
            list = new ArrayList<FileChangeListener>();
            map.put(file, list);
        }
        return list.add(fcl);
    }

    public static synchronized boolean removeListener(String file, FileChangeListener fcl) {
        if (file == null) {
            return false;
        }
        File myFile = new File(file);
        if (!myFile.canRead()) {
            return false;
        }
        ArrayList list = (ArrayList)map.get(file);
        if (list == null) {
            list = new ArrayList();
            map.put(file, list);
        }
        return list.remove(fcl);
    }

    public static void startMonitoring() {
        if (flag) {
            return;
        }
        flag = true;
        if (thread != null) {
            thread.interrupt();
            thread = null;
        }
        thread = new Thread(fcm);
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    public static void stopMonitoring() {
        if (!flag) {
            return;
        }
        flag = false;
        if (thread != null) {
            thread.interrupt();
        }
        thread = null;
    }

    public void run() {
        logger.info("Starting..");
        Iterator iterator = null;
        String key = null;
        File file = null;
        String lastModifiedTimeOld = null;
        String lastModifiedTimeNew = null;
        FileChangeListener fcl = null;
        List fclList = null;
        block4: while (flag) {
            Set set = map.keySet();
            iterator = set.iterator();
            while (flag && iterator.hasNext()) {
                try {
                    key = (String)iterator.next();
                    file = new File(key);
                    lastModifiedTimeNew = "" + file.lastModified();
                    lastModifiedTimeOld = (String)lastModified.get(key);
                    if (lastModifiedTimeOld == null) {
                        lastModified.put(key, lastModifiedTimeNew);
                        continue;
                    }
                    if (!lastModifiedTimeOld.equals(lastModifiedTimeNew)) {
                        lastModified.put(key, lastModifiedTimeNew);
                        fclList = (List)map.get(key);
                        for (int i = 0; i < fclList.size(); ++i) {
                            fcl = (FileChangeListener)fclList.get(i);
                            fcl.changed();
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ERROR: " + e, e);
                }
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ERROR: " + e, e);
                    continue block4;
                }
            }
        }
        logger.info("Stopped.");
    }

    public static void main(String[] args) throws Exception {
        FileChangeListener fcl = new FileChangeListener(){

            public void changed() {
                System.out.println("File changed: " + new Date());
            }
        };
        FileChangeMonitor.addListener("test.txt", fcl);
        FileChangeMonitor.startMonitoring();
    }

    static {
        thread = null;
        fcm = new FileChangeMonitor();
        FileChangeMonitor.startMonitoring();
    }
}

