/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.quickserver.util.io.JarFileList;

public class ClassUtil {
    private static Logger logger = Logger.getLogger(ClassUtil.class.getName());

    public static Map loadClass(ClassLoader classLoader, String[] classNames) throws Exception {
        Class<?> classloded = null;
        HashMap classHash = new HashMap();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                classloded = classLoader.loadClass(classNames[i]);
                classHash.put(classNames[i], classloded);
                continue;
            }
            catch (Exception e) {
                logger.warning("Could not load classes : " + e);
            }
        }
        return classHash;
    }

    public static ClassLoader getClassLoaderFromJars(String jarDir) throws Exception {
        logger.fine("Getting ClassLoader for jars in " + jarDir);
        File file = new File(jarDir);
        ArrayList<URL> list = new ArrayList<URL>();
        File[] jars = file.listFiles(new JarFileList());
        for (int j = 0; j < jars.length; ++j) {
            list.add(jars[j].toURL());
        }
        Object[] array = list.toArray();
        URL[] jarurl = new URL[array.length];
        for (int i = 0; i < array.length; ++i) {
            jarurl[i] = (URL)array[i];
        }
        URLClassLoader classLoader = URLClassLoader.newInstance(jarurl);
        return classLoader;
    }

    public static ClassLoader getClassLoaderFromJar(String jarPath) throws Exception {
        File file = new File(jarPath);
        logger.fine("Getting ClassLoader for " + file.getCanonicalPath());
        URL[] jarurl = new URL[]{file.toURL()};
        URLClassLoader classLoader = URLClassLoader.newInstance(jarurl);
        return classLoader;
    }

    public static ClassLoader getClassLoader(String path) throws Exception {
        File file = new File(path);
        if (!file.canRead()) {
            logger.warning("Could not read path: " + path);
            return null;
        }
        if (file.isDirectory()) {
            return ClassUtil.getClassLoaderFromJars(path);
        }
        return ClassUtil.getClassLoaderFromJar(path);
    }
}

