/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.quickserver.util.io.PasswordField;

public class SensitiveInput
extends JFrame {
    private static Logger logger = Logger.getLogger(SensitiveInput.class.getName());
    private JLabel inputLabel;
    private JPanel jPanel1;
    private JPasswordField passwordField;
    private JButton submitButton;
    private boolean gotInput = false;
    private char[] input = null;
    private ImageIcon logo = new ImageIcon(this.getClass().getResource("/icons/logo.gif"));

    public SensitiveInput() {
        this("Input sensitive property value..");
    }

    public SensitiveInput(String title) {
        logger.finest("Loading swing gui..");
        try {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initComponents(title);
    }

    private void initComponents(String title) {
        this.setIconImage(this.logo.getImage());
        this.inputLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.submitButton = new JButton();
        this.passwordField = new JPasswordField();
        this.getContentPane().setLayout(new BorderLayout(1, 1));
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setName("InputFrm");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                SensitiveInput.this.formWindowClosed(evt);
            }
        });
        this.inputLabel.setText("  Param Name");
        this.inputLabel.setName("inputLabel");
        this.inputLabel.setPreferredSize(new Dimension(250, 11));
        JPanel lp = new JPanel();
        lp.add(this.inputLabel);
        this.getContentPane().add((Component)lp, "North");
        this.jPanel1.setLayout(new BorderLayout(5, 2));
        this.jPanel1.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SensitiveInput.this.submitButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.submitButton, "East");
        this.passwordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SensitiveInput.this.passwordFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.passwordField, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 260) / 2, (screenSize.height - 70) / 2, 260, 70);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formWindowClosed(WindowEvent evt) {
        this.input = null;
        this.gotInput = true;
        this.passwordField.setText("");
        SensitiveInput sensitiveInput = this;
        synchronized (sensitiveInput) {
            this.notify();
        }
    }

    private void passwordFieldActionPerformed(ActionEvent evt) {
        this.loadPassword();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        this.loadPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPassword() {
        this.input = this.passwordField.getPassword();
        this.gotInput = true;
        this.passwordField.setText("");
        SensitiveInput sensitiveInput = this;
        synchronized (sensitiveInput) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getInput(String inputName) throws IOException {
        try {
            this.gotInput = false;
            this.input = null;
            this.inputLabel.setText("<html><font style=\"font-size:10pt;color:#535353\"><b>" + inputName + "</b></font>");
            this.inputLabel.setToolTipText("Value for " + inputName);
            if (inputName.length() >= 30) {
                this.passwordField.setToolTipText("Value for " + inputName);
            }
            System.out.println("Opening gui to input sensitive property value: " + inputName);
            this.setVisible(true);
            try {
                if (!this.gotInput) {
                    SensitiveInput sensitiveInput = this;
                    synchronized (sensitiveInput) {
                        this.wait();
                    }
                }
                this.setVisible(false);
            }
            catch (Exception e) {
                logger.warning("Error: " + e);
                throw e;
            }
            return this.input;
        }
        catch (Exception e) {
            logger.warning("Error opening GUI to input sensitive property value : " + e);
            return PasswordField.getPassword("Input property value for " + inputName + " : ");
        }
    }

    public static void main(String[] args) throws Exception {
        SensitiveInput si = new SensitiveInput();
        char[] pass = si.getInput("Some Password");
        if (pass != null) {
            logger.info("Some Password : " + new String(pass));
        } else {
            logger.info("Some Password : " + pass);
        }
        pass = si.getInput("Other Password");
        if (pass != null) {
            logger.info("Other Password : " + new String(pass));
        } else {
            logger.info("Other Password : " + pass);
        }
    }
}

