/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.swing;

import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JFrameUtilities {
    public static String title(Object o) {
        String t = o.getClass().toString();
        if (t.indexOf("class") != -1) {
            t = t.substring(6);
        }
        if (t.lastIndexOf(".") != -1) {
            t = t.substring(t.lastIndexOf(".") + 1);
        }
        return t;
    }

    public static void run(JFrame frame, int width, int height) {
        frame.setDefaultCloseOperation(3);
        frame.setSize(width, height);
        frame.setVisible(true);
    }

    public static void run(JApplet applet, int width, int height) {
        JFrame frame = new JFrame(JFrameUtilities.title(applet));
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(applet);
        frame.setSize(width, height);
        applet.init();
        applet.start();
        frame.setVisible(true);
    }

    public static void run(JPanel panel, int width, int height) {
        JFrame frame = new JFrame(JFrameUtilities.title(panel));
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(panel);
        frame.setSize(width, height);
        frame.setVisible(true);
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
    }

    public static void setJavaLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting Java LAF: " + e);
        }
    }

    public static void setMotifLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e) {
            System.out.println("Error setting Motif LAF: " + e);
        }
    }

    public static void centerWindow(Window window) {
        Dimension dim = window.getToolkit().getScreenSize();
        window.setLocation(dim.width / 2 - window.getWidth() / 2, dim.height / 2 - window.getHeight() / 2);
    }
}

