/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.quickserver.net.AppException;
import org.quickserver.net.ConnectionLostException;
import org.quickserver.net.server.AuthStatus;
import org.quickserver.net.server.ClientEvent;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.ClientWriteHandler;
import org.quickserver.net.server.DataMode;
import org.quickserver.net.server.DataType;
import org.quickserver.net.server.TheClient;
import org.quickserver.net.server.impl.BasicClientHandler;
import org.quickserver.util.Assertion;
import org.quickserver.util.MyString;
import org.quickserver.util.io.ByteBufferInputStream;
import org.quickserver.util.io.ByteBufferOutputStream;

public class NonBlockingClientHandler
extends BasicClientHandler {
    private static final Logger logger = Logger.getLogger(NonBlockingClientHandler.class.getName());
    protected ClientWriteHandler clientWriteHandler;
    private SocketChannel socketChannel;
    protected ArrayList readByteBuffer = new ArrayList();
    protected ArrayList writeByteBuffer = new ArrayList();
    protected SelectionKey selectionKey;
    protected volatile int threadAccessCount = 0;
    protected volatile boolean willReturn;
    protected volatile boolean waitingForFinalWrite;
    private static int maxThreadAccessCount = 5;
    private static boolean wakeupSelectorAfterRegisterWrite = true;
    private static boolean wakeupSelectorAfterRegisterRead = true;
    private boolean initialHandshakeStatus = false;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private SSLEngineResult.Status status = null;
    private ByteBuffer dummyByteBuffer = ByteBuffer.allocate(0);
    private ByteBuffer peerNetData = null;
    private boolean sslShutdown = false;
    private ByteBufferOutputStream byteBufferOutputStream;

    public static void setWakeupSelectorAfterRegisterWrite(boolean flag) {
        wakeupSelectorAfterRegisterWrite = flag;
    }

    public static boolean getWakeupSelectorAfterRegisterWrite() {
        return wakeupSelectorAfterRegisterWrite;
    }

    public static void setWakeupSelectorAfterRegisterRead(boolean flag) {
        wakeupSelectorAfterRegisterRead = flag;
    }

    public static boolean getWakeupSelectorAfterRegisterRead() {
        return wakeupSelectorAfterRegisterRead;
    }

    public static void setMaxThreadAccessCount(int count) {
        if (count < 3 && count != -1) {
            throw new IllegalArgumentException("Value should be >=3 or -1");
        }
        maxThreadAccessCount = count;
    }

    public static int getMaxThreadAccessCount() {
        return maxThreadAccessCount;
    }

    public NonBlockingClientHandler(int instanceCount) {
        super(instanceCount);
    }

    public NonBlockingClientHandler() {
    }

    public void clean() {
        logger.log(Level.FINEST, "Starting clean - {0}", this.getName());
        if (this.threadAccessCount != 0) {
            logger.log(Level.WARNING, "Thread Access Count was not 0!: {0}", this.threadAccessCount);
            if (Assertion.isEnabled()) {
                this.assertionSystemExit();
            }
            this.threadAccessCount = 0;
        }
        while (!this.readByteBuffer.isEmpty()) {
            try {
                this.getServer().getByteBufferPool().returnObject(this.readByteBuffer.remove(0));
            }
            catch (Exception er) {
                logger.log(Level.WARNING, "Error in returning read ByteBuffer to pool: " + er, er);
                break;
            }
        }
        while (!this.writeByteBuffer.isEmpty()) {
            try {
                this.getServer().getByteBufferPool().returnObject(this.writeByteBuffer.remove(0));
            }
            catch (Exception er) {
                this.appLogger.log(Level.WARNING, "Error in returning write ByteBuffer to pool: " + er, er);
                break;
            }
        }
        if (this.peerNetData != null) {
            try {
                this.getServer().getByteBufferPool().returnObject((Object)this.peerNetData);
            }
            catch (Exception er) {
                this.appLogger.log(Level.WARNING, "Error in returning peerNetData to pool: " + er, er);
            }
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
            this.selectionKey.selector().wakeup();
            this.selectionKey = null;
        }
        this.willReturn = false;
        this.waitingForFinalWrite = false;
        this.socketChannel = null;
        if (this.byteBufferOutputStream != null) {
            this.byteBufferOutputStream.close();
        }
        super.clean();
        this.clientWriteHandler = null;
        this.byteBufferOutputStream = null;
        this.sslShutdown = false;
        logger.log(Level.FINEST, "Finished clean - {0}", this.getName());
    }

    public void handleClient(TheClient theClient) throws Exception {
        super.handleClient(theClient);
        this.setClientWriteHandler(theClient.getClientWriteHandler());
        this.setSocketChannel(theClient.getSocketChannel());
    }

    protected void setInputStream(InputStream in) throws IOException {
        this.in = in;
        if (this.getDataMode(DataType.IN) == DataMode.STRING) {
            this.b_in = null;
            this.o_in = null;
            this.bufferedReader = null;
        } else if (this.getDataMode(DataType.IN) == DataMode.OBJECT) {
            this.b_in = null;
            this.bufferedReader = null;
            this.o_in = new ObjectInputStream(in);
        } else if (this.getDataMode(DataType.IN) == DataMode.BYTE || this.getDataMode(DataType.IN) == DataMode.BINARY) {
            this.o_in = null;
            this.bufferedReader = null;
            this.b_in = null;
        }
    }

    public BufferedReader getBufferedReader() {
        throw new IllegalStateException("Access to BufferedReader in not allowed in Non-Blocking mode!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        block19: {
            logger.finest("inside");
            NonBlockingClientHandler nonBlockingClientHandler = this;
            synchronized (nonBlockingClientHandler) {
                if (!this.connection) {
                    return;
                }
                if (this.waitingForFinalWrite) {
                    return;
                }
                if (this.getSelectionKey() != null && this.getSelectionKey().isValid() && !this.lost) {
                    this.waitingForFinalWrite = true;
                } else {
                    this.connection = false;
                }
            }
            try {
                block20: {
                    if (this.getSocketChannel() == null || this.socket == null) break block19;
                    if (this.waitingForFinalWrite) {
                        try {
                            this.waitTillFullyWritten();
                        }
                        catch (Exception error) {
                            logger.warning("Error in waitingForFinalWrite : " + error);
                            if (!logger.isLoggable(Level.FINE)) break block20;
                            logger.fine("StackTrace:\n" + MyString.getStackTrace(error));
                        }
                    }
                }
                if (this.isSecure()) {
                    this.sslShutdown = true;
                    if (!this.lost && !this.sslEngine.isOutboundDone()) {
                        logger.finest("SSL isOutboundDone is false");
                        if (!this.byteBufferOutputStream.doShutdown()) {
                            return;
                        }
                    } else if (this.sslEngine.isOutboundDone()) {
                        logger.finest("SSL Outbound is done.");
                    }
                }
                this.doPostCloseActivity();
            }
            catch (IOException e) {
                logger.warning("Error in closeConnection : " + e);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("StackTrace:\n" + MyString.getStackTrace(e));
                }
            }
            catch (NullPointerException npe) {
                logger.fine("NullPointerException: " + npe);
                if (!logger.isLoggable(Level.FINE)) break block19;
                logger.fine("StackTrace:\n" + MyString.getStackTrace(npe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostCloseActivity() throws IOException {
        this.connection = false;
        this.byteBufferOutputStream.forceNotify();
        this.getSelectionKey().cancel();
        if (this.getServer() != null) {
            this.getServer().getSelector().wakeup();
        }
        NonBlockingClientHandler nonBlockingClientHandler = this;
        synchronized (nonBlockingClientHandler) {
            if (!this.hasEvent(ClientEvent.MAX_CON)) {
                this.notifyCloseOrLost();
            }
            if (this.getSocketChannel().isOpen()) {
                logger.finest("Closing SocketChannel");
                this.getSocketChannel().close();
            }
        }
    }

    public boolean closeIfSSLOutboundDone() {
        if (!this.isSecure()) {
            throw new IllegalStateException("Client is not in secure mode!");
        }
        if (this.sslEngine.isOutboundDone()) {
            logger.finest("SSL Outbound is done.");
            try {
                if (this.getSocketChannel().isOpen()) {
                    logger.finest("Closing SocketChannel");
                    this.getSocketChannel().close();
                }
            }
            catch (IOException e) {
                logger.fine("IGNORE: Error in Closing SocketChannel: " + e);
            }
            return true;
        }
        logger.finest("SSL Outbound is not done.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillFullyWritten() {
        Object waitLock = new Object();
        if (this.byteBufferOutputStream.isDataAvailableForWrite(waitLock)) {
            if (ByteBufferOutputStream.isLoggable(Level.FINEST)) {
                logger.finest("Waiting " + this.getName());
            }
            try {
                Object object = waitLock;
                synchronized (object) {
                    waitLock.wait(120000L);
                }
            }
            catch (InterruptedException ie) {
                logger.warning("Error: " + ie);
            }
            if (ByteBufferOutputStream.isLoggable(Level.FINEST)) {
                logger.finest("Done. " + this.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        block70: {
            if (this.unprocessedClientEvents.isEmpty()) {
                logger.finest("No unprocessed ClientEvents!");
                return;
            }
            NonBlockingClientHandler nonBlockingClientHandler = this;
            synchronized (nonBlockingClientHandler) {
                if (this.willReturn) {
                    return;
                }
                ++this.threadAccessCount;
            }
            ClientEvent currentEvent = (ClientEvent)this.unprocessedClientEvents.poll();
            if (currentEvent == null) {
                threadEvent.set(null);
                logger.finest("No unprocessed ClientEvents! pool was null");
                return;
            }
            if (logger.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Running ").append(this.getName());
                sb.append(" using ");
                sb.append(Thread.currentThread().getName());
                sb.append(" for ");
                object = this.clientEvents;
                synchronized (object) {
                    if (this.clientEvents.size() > 1) {
                        sb.append(currentEvent + ", Current Events - " + this.clientEvents);
                    } else {
                        sb.append(currentEvent);
                    }
                }
                logger.finest(sb.toString());
            }
            logger.finest("threadAccessCount: " + this.threadAccessCount);
            threadEvent.set(currentEvent);
            try {
                if (maxThreadAccessCount != -1 && this.threadAccessCount > maxThreadAccessCount) {
                    logger.warning("ThreadAccessCount can't go beyond " + maxThreadAccessCount + ": " + this.threadAccessCount);
                    if (Assertion.isEnabled()) {
                        throw new AssertionError((Object)("ThreadAccessCount can't go beyond " + maxThreadAccessCount + ": " + this.threadAccessCount));
                    }
                    return;
                }
                if (this.socket == null) {
                    throw new SocketException("Socket was null!");
                }
                if (this.getThreadEvent() == ClientEvent.ACCEPT || this.getThreadEvent() == ClientEvent.MAX_CON) {
                    this.prepareForRun();
                    Assertion.affirm(!this.willReturn, "WillReturn has to be false!: " + this.willReturn);
                }
                if (this.getThreadEvent() == ClientEvent.MAX_CON) {
                    this.processMaxConnection(currentEvent);
                }
                try {
                    if (this.getThreadEvent() == ClientEvent.ACCEPT) {
                        this.registerForRead();
                        this.clientEventHandler.gotConnected(this);
                        if (!this.authorised) {
                            if (this.clientAuthenticationHandler == null && this.authenticator == null) {
                                this.authorised = true;
                                logger.finest("No Authenticator " + this.getName() + " so return thread.");
                            } else {
                                if (this.clientAuthenticationHandler != null) {
                                    AuthStatus authStatus = null;
                                    while ((authStatus = this.processAuthorisation()) == AuthStatus.FAILURE) {
                                    }
                                    if (authStatus == AuthStatus.SUCCESS) {
                                        this.authorised = true;
                                    }
                                } else {
                                    this.processAuthorisation();
                                }
                                if (this.authorised) {
                                    logger.finest("Authentication done " + this.getName() + ", so return thread.");
                                } else {
                                    logger.finest("askAuthentication() done " + this.getName() + ", so return thread.");
                                }
                            }
                        }
                        this.returnThread();
                        return;
                    }
                    if (this.connection && this.getThreadEvent() == ClientEvent.READ && this.processRead()) {
                        return;
                    }
                    if (this.connection && this.getThreadEvent() == ClientEvent.WRITE && this.processWrite()) {
                        return;
                    }
                }
                catch (SocketException e) {
                    this.appLogger.finest("SocketException - Client [" + this.getHostAddress() + "]: " + e.getMessage());
                    this.lost = true;
                }
                catch (AppException e) {
                    this.appLogger.finest("AppException " + Thread.currentThread().getName() + ": " + e.getMessage());
                }
                catch (SSLException e) {
                    this.lost = true;
                    if (Assertion.isEnabled()) {
                        this.appLogger.info("SSLException - Client [" + this.getHostAddress() + "] " + Thread.currentThread().getName() + ": " + e);
                    } else {
                        this.appLogger.warning("SSLException - Client [" + this.getHostAddress() + "]: " + e);
                    }
                }
                catch (ConnectionLostException e) {
                    this.lost = true;
                    if (e.getMessage() != null) {
                        this.appLogger.finest("Connection lost " + Thread.currentThread().getName() + ": " + e.getMessage());
                    } else {
                        this.appLogger.finest("Connection lost " + Thread.currentThread().getName());
                    }
                }
                catch (ClosedChannelException e) {
                    this.lost = true;
                    this.appLogger.finest("Channel closed " + Thread.currentThread().getName() + ": " + e);
                }
                catch (IOException e) {
                    this.lost = true;
                    this.appLogger.fine("IOError " + Thread.currentThread().getName() + ": " + e);
                }
                catch (AssertionError er) {
                    logger.warning("[AssertionError] " + this.getName() + " " + er);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("StackTrace " + Thread.currentThread().getName() + ": " + MyString.getStackTrace((Throwable)((Object)er)));
                    }
                    this.assertionSystemExit();
                }
                catch (RuntimeException re) {
                    logger.warning("[RuntimeException] " + MyString.getStackTrace(re));
                    if (Assertion.isEnabled()) {
                        this.assertionSystemExit();
                    }
                    this.lost = true;
                }
                catch (Throwable er) {
                    logger.warning("[Error] " + er);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("StackTrace " + Thread.currentThread().getName() + ": " + MyString.getStackTrace(er));
                    }
                    if (Assertion.isEnabled()) {
                        this.assertionSystemExit();
                    }
                    this.lost = true;
                }
                if (this.getThreadEvent() != ClientEvent.MAX_CON) {
                    this.notifyCloseOrLost();
                }
                if (this.connection) {
                    logger.finest(Thread.currentThread().getName() + " calling closeConnection()");
                    this.closeConnection();
                }
                if (this.connection && this.lost && this.waitingForFinalWrite) {
                    this.byteBufferOutputStream.forceNotify();
                }
            }
            catch (SSLException se) {
                logger.warning("SSLException " + Thread.currentThread().getName() + " - " + se);
            }
            catch (IOException ie) {
                logger.warning("IOError " + Thread.currentThread().getName() + " - Closing Client : " + ie);
            }
            catch (RuntimeException re) {
                logger.warning("[RuntimeException] " + this.getName() + " " + Thread.currentThread().getName() + " - " + MyString.getStackTrace(re));
                if (Assertion.isEnabled()) {
                    this.assertionSystemExit();
                }
            }
            catch (Exception e) {
                logger.warning("Error " + Thread.currentThread().getName() + " - Event:" + this.getThreadEvent() + " - Socket:" + this.socket + " : " + e);
                logger.fine("StackTrace: " + this.getName() + "\n" + MyString.getStackTrace(e));
                if (Assertion.isEnabled()) {
                    this.assertionSystemExit();
                }
            }
            catch (Throwable e) {
                logger.warning("Error " + Thread.currentThread().getName() + " - Event:" + this.getThreadEvent() + " - Socket:" + this.socket + " : " + e);
                logger.fine("StackTrace: " + this.getName() + "\n" + MyString.getStackTrace(e));
                if (!Assertion.isEnabled()) break block70;
                this.assertionSystemExit();
            }
        }
        NonBlockingClientHandler e = this;
        synchronized (e) {
            try {
                if (this.getSelectionKey() != null && this.getSelectionKey().isValid()) {
                    logger.finest("Canceling SelectionKey");
                    this.getSelectionKey().cancel();
                }
                if (this.socket != null && !this.socket.isClosed()) {
                    logger.finest("Closing Socket");
                    this.socket.close();
                }
                if (this.getSocketChannel() != null && this.getSocketChannel().isOpen()) {
                    logger.finest("Closing SocketChannel");
                    this.socketChannel.close();
                }
            }
            catch (Exception re) {
                logger.warning("Error closing Socket/Channel: " + re);
            }
        }
        this.willClean = true;
        this.returnClientData();
        boolean returnClientHandler = false;
        object = this.lockObj;
        synchronized (object) {
            this.returnThread();
            returnClientHandler = this.checkReturnClientHandler();
        }
        if (returnClientHandler) {
            this.returnClientHandler();
        }
    }

    protected boolean checkReturnClientHandler() {
        if (!this.willReturn) {
            this.willReturn = true;
            return true;
        }
        return false;
    }

    private boolean processRead() throws Exception {
        if (this.doRead()) {
            this.returnThread();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRead() throws Exception {
        InputStream inputStream;
        int count = 0;
        int fullCount = 0;
        do {
            try {
                if (this.peerNetData == null) {
                    this.peerNetData = (ByteBuffer)this.getServer().getByteBufferPool().borrowObject();
                }
                if ((count = this.getSocketChannel().read(this.peerNetData)) < 0) {
                    this.getServer().getByteBufferPool().returnObject((Object)this.peerNetData);
                    this.peerNetData = null;
                    break;
                }
                fullCount += count;
                this.peerNetData.flip();
                ByteBuffer peerAppData = null;
                if (this.sslEngine != null) {
                    SSLEngineResult res;
                    peerAppData = (ByteBuffer)this.getServer().getByteBufferPool().borrowObject();
                    do {
                        res = this.sslEngine.unwrap(this.peerNetData, peerAppData);
                        logger.info("Unwrapping:\n" + res);
                    } while (res.getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0);
                    if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                        logger.info("HandshakeStatus.FINISHED!");
                        this.finishInitialHandshake();
                    }
                    if (peerAppData.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
                        logger.info("peerNetData hasRemaining and pos=0!");
                        res = this.sslEngine.unwrap(this.peerNetData, peerAppData);
                        logger.info("Unwrapping:\n" + res);
                    }
                    this.status = res.getStatus();
                    this.handshakeStatus = res.getHandshakeStatus();
                    if (this.status != SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        logger.warning("Buffer overflow: " + res.toString());
                    } else if (this.status == SSLEngineResult.Status.CLOSED) {
                        logger.fine("Connection is being closed by peer.");
                        this.lost = true;
                        System.out.println("NEdd to code for shutdow of SSL");
                        break;
                    }
                    this.peerNetData.compact();
                    peerAppData.flip();
                    if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                        this.doHandshake();
                    }
                    logger.fine("peerAppData.remaining(): " + peerAppData.remaining());
                } else {
                    peerAppData = this.peerNetData;
                    this.peerNetData = null;
                }
                this.readByteBuffer.add(peerAppData);
                peerAppData = null;
            }
            catch (Exception error) {
                logger.finest("Error in data read: " + error);
                if (this.sslEngine != null) {
                    this.sslEngine.closeInbound();
                }
                this.lost = true;
                InputStream inputStream2 = this.getInputStream();
                synchronized (inputStream2) {
                    this.getInputStream().notifyAll();
                }
                throw error;
            }
        } while (count != 0);
        if (count < 0) {
            logger.finest("SocketChannel read was " + count + "!");
            if (this.sslEngine != null) {
                this.sslEngine.closeInbound();
            }
            this.lost = true;
            inputStream = this.getInputStream();
            synchronized (inputStream) {
                this.getInputStream().notifyAll();
            }
        }
        logger.finest(fullCount + " bytes read");
        if (fullCount != 0) {
            this.updateLastCommunicationTime();
            inputStream = this.getInputStream();
            synchronized (inputStream) {
                this.getInputStream().notify();
            }
            if (!this.hasEvent(ClientEvent.ACCEPT)) {
                this.processGotDataInBuffers();
            }
        }
        while (this.getInputStream().available() > 0) {
            logger.finest("Sending again for processing...");
            if (!this.hasEvent(ClientEvent.ACCEPT)) {
                this.processGotDataInBuffers();
                break;
            }
            inputStream = this.getInputStream();
            synchronized (inputStream) {
                this.getInputStream().notifyAll();
            }
            Thread.sleep(100L);
        }
        if (this.connection) {
            this.registerForRead();
            return true;
        }
        logger.finest("We don't have connection, lets return all resources.");
        return false;
    }

    private boolean processWrite() throws IOException {
        if (this.doWrite()) {
            this.returnThread();
            return true;
        }
        return false;
    }

    private boolean doWrite() throws IOException {
        if (this.sslShutdown) {
            if (!this.byteBufferOutputStream.doShutdown()) {
                return true;
            }
            this.doPostCloseActivity();
            logger.finest("We don't have connection, lets return all resources.");
            return false;
        }
        this.updateLastCommunicationTime();
        boolean flag = this.byteBufferOutputStream.writeAllByteBuffer();
        if (!flag) {
            this.registerWrite();
        } else if (this.clientWriteHandler != null) {
            this.clientWriteHandler.handleWrite(this);
        }
        if (this.connection) {
            return true;
        }
        logger.finest("We don't have connection, lets return all resources.");
        return false;
    }

    protected void returnThread() {
        --this.threadAccessCount;
        Assertion.affirm(this.threadAccessCount >= 0, "ThreadAccessCount went less the 0! Value: " + this.threadAccessCount);
        this.removeEvent((ClientEvent)threadEvent.get());
    }

    protected void returnClientHandler() {
        logger.finest(this.getName());
        try {
            int i = 0;
            while (this.threadAccessCount != 0) {
                if (i == 100) {
                    logger.warning("ClientHandler must have got into a loop waiting for thread to free up! ThreadAccessCount=" + this.threadAccessCount);
                    this.threadAccessCount = 0;
                    if (!Assertion.isEnabled()) break;
                    this.assertionSystemExit();
                }
                if (this.threadAccessCount > 0) {
                    logger.finest("Waiting for other thread of " + this.getName() + " to finish");
                    Thread.sleep(60L);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ie) {
            this.appLogger.warning("InterruptedException: " + ie);
        }
        super.returnClientHandler();
    }

    public void setDataMode(DataMode dataMode, DataType dataType) throws IOException {
        if (this.getDataMode(dataType) == dataMode) {
            return;
        }
        this.appLogger.fine("Setting Type:" + dataType + ", Mode:" + dataMode);
        super.checkDataModeSet(dataMode, dataType);
        this.setDataModeNonBlocking(dataMode, dataType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDataModeNonBlocking(DataMode dataMode, DataType dataType) throws IOException {
        logger.finest("ENTER");
        if (dataMode == DataMode.STRING) {
            if (dataType == DataType.OUT) {
                if (this.dataModeOUT == DataMode.BYTE || this.dataModeOUT == DataMode.BINARY) {
                    this.dataModeOUT = dataMode;
                } else if (this.dataModeOUT == DataMode.OBJECT) {
                    this.dataModeOUT = dataMode;
                    this.o_out.flush();
                    this.o_out = null;
                    this.b_out = new BufferedOutputStream(this.out);
                } else {
                    Assertion.affirm(false, "Unknown DataType.OUT DataMode - " + this.dataModeOUT);
                }
                Assertion.affirm(this.b_out != null, "BufferedOutputStream is still null!");
                Assertion.affirm(this.o_out == null, "ObjectOutputStream is still not null!");
                return;
            } else {
                if (dataType != DataType.IN) return;
                this.dataModeIN = dataMode;
                if (this.o_in != null) {
                    if (this.o_in.available() != 0) {
                        logger.warning("Data looks to be present in ObjectInputStream");
                    }
                    this.o_in = null;
                }
                this.b_in = null;
                this.bufferedReader = null;
                Assertion.affirm(this.in != null, "InputStream is still null!");
                Assertion.affirm(this.b_in == null, "BufferedInputStream is still not null!");
                Assertion.affirm(this.bufferedReader == null, "BufferedReader is still not null!");
            }
            return;
        } else if (dataMode == DataMode.OBJECT) {
            if (dataType == DataType.IN) {
                throw new IllegalArgumentException("Can't set DataType.IN mode to OBJECT when blocking mode is set as false!");
            }
            if (dataType == DataType.OUT) {
                this.dataModeOUT = dataMode;
                this.b_out = null;
                this.o_out = new ObjectOutputStream(this.out);
                Assertion.affirm(this.o_out != null, "ObjectOutputStream is still null!");
                this.o_out.flush();
                return;
            } else {
                if (dataType != DataType.IN) return;
                this.dataModeIN = dataMode;
                this.b_in = null;
                this.bufferedReader = null;
                this.registerForRead();
                this.o_in = new ObjectInputStream(this.in);
                Assertion.affirm(this.o_in != null, "ObjectInputStream is still null!");
            }
            return;
        } else {
            if (dataMode != DataMode.BYTE && dataMode != DataMode.BINARY) throw new IllegalArgumentException("Unknown DataMode : " + dataMode);
            if (dataType == DataType.OUT) {
                if (this.dataModeOUT == DataMode.STRING || this.dataModeOUT == DataMode.BYTE || this.dataModeOUT == DataMode.BINARY) {
                    this.dataModeOUT = dataMode;
                } else if (this.dataModeOUT == DataMode.OBJECT) {
                    this.dataModeOUT = dataMode;
                    this.o_out = null;
                    this.b_out = new BufferedOutputStream(this.out);
                } else {
                    Assertion.affirm(false, "Unknown DataType.OUT - DataMode: " + this.dataModeOUT);
                }
                Assertion.affirm(this.b_out != null, "BufferedOutputStream is still null!");
                return;
            } else {
                if (dataType != DataType.IN) throw new IllegalArgumentException("Unknown DataType : " + dataType);
                this.dataModeIN = dataMode;
                this.o_in = null;
                this.bufferedReader = null;
                this.b_in = null;
                Assertion.affirm(this.in != null, "InputStream is still null!");
            }
        }
    }

    protected byte[] readInputStream() throws IOException {
        return NonBlockingClientHandler.readInputStream(this.getInputStream());
    }

    public void updateInputOutputStreams() throws IOException {
        this.byteBufferOutputStream = new ByteBufferOutputStream(this.writeByteBuffer, this);
        this.setInputStream(new ByteBufferInputStream(this.readByteBuffer, this, this.getCharset()));
        this.setOutputStream(this.byteBufferOutputStream);
        if (this.sslEngine != null) {
            this.sslEngine.setUseClientMode(false);
            this.sslEngine.beginHandshake();
            this.handshakeStatus = this.sslEngine.getHandshakeStatus();
            this.initialHandshakeStatus = true;
        }
    }

    public boolean getBlockingMode() {
        return false;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public SelectionKey getSelectionKey() {
        if (this.selectionKey == null) {
            this.selectionKey = this.getSocketChannel().keyFor(this.getServer().getSelector());
        }
        return this.selectionKey;
    }

    private void processGotDataInBuffers() throws AppException, ConnectionLostException, ClassNotFoundException, IOException {
        if (this.getInputStream().available() == 0) {
            return;
        }
        logger.finest("Trying to process got data.. DataMode.IN=" + this.dataModeIN);
        AuthStatus authStatus = null;
        ((ByteBufferInputStream)this.getInputStream()).dumpContent();
        Object temp = null;
        String rec = null;
        Object recObject = null;
        byte[] recByte = null;
        boolean timeToCheckForNewLineMiss = false;
        do {
            if (this.dataModeIN == DataMode.STRING) {
                ByteBufferInputStream bbin = (ByteBufferInputStream)this.getInputStream();
                timeToCheckForNewLineMiss = true;
                while (bbin.isLineReady()) {
                    rec = bbin.readLine();
                    if (rec == null) {
                        this.lost = true;
                        return;
                    }
                    if (this.getCommunicationLogging() && this.authorised) {
                        this.appLogger.log(Level.FINE, "Got STRING [{0}] : {1}", new Object[]{this.getHostAddress(), rec});
                    }
                    this.totalReadBytes += rec.length();
                    if (!this.authorised) {
                        authStatus = this.clientAuthenticationHandler.handleAuthentication((ClientHandler)this, rec);
                    } else {
                        this.clientCommandHandler.handleCommand(this, rec);
                    }
                    if (this.isClosed()) {
                        return;
                    }
                    while (authStatus == AuthStatus.FAILURE) {
                        authStatus = this.processAuthorisation();
                    }
                    if (authStatus == AuthStatus.SUCCESS) {
                        this.authorised = true;
                    }
                    if (this.dataModeIN != DataMode.STRING) break;
                    timeToCheckForNewLineMiss = false;
                }
                if (timeToCheckForNewLineMiss && bbin.availableOnlyInByteBuffer() == 0) {
                    return;
                }
                timeToCheckForNewLineMiss = false;
            }
            while (this.dataModeIN == DataMode.OBJECT && this.o_in != null) {
                recObject = this.o_in.readObject();
                if (recObject == null) {
                    this.lost = true;
                    return;
                }
                if (this.getCommunicationLogging() && this.authorised) {
                    this.appLogger.log(Level.FINE, "Got OBJECT [{0}] : {1}", new Object[]{this.getHostAddress(), recObject.toString()});
                }
                ++this.totalReadBytes;
                if (!this.authorised) {
                    authStatus = this.clientAuthenticationHandler.handleAuthentication((ClientHandler)this, recObject);
                } else {
                    this.clientObjectHandler.handleObject(this, recObject);
                }
                if (this.isClosed()) {
                    return;
                }
                while (authStatus == AuthStatus.FAILURE) {
                    authStatus = this.processAuthorisation();
                }
                if (authStatus != AuthStatus.SUCCESS) continue;
                this.authorised = true;
            }
            while (this.dataModeIN == DataMode.BYTE && this.getInputStream().available() != 0) {
                rec = this.readBytes();
                if (rec == null) {
                    this.lost = true;
                    return;
                }
                if (this.getCommunicationLogging() && this.authorised) {
                    this.appLogger.log(Level.FINE, "Got BYTE [{0}] : {1}", new Object[]{this.getHostAddress(), rec});
                }
                this.totalReadBytes += rec.length();
                if (!this.authorised) {
                    authStatus = this.clientAuthenticationHandler.handleAuthentication((ClientHandler)this, rec);
                } else {
                    this.clientCommandHandler.handleCommand(this, rec);
                }
                if (this.isClosed()) {
                    return;
                }
                while (authStatus == AuthStatus.FAILURE) {
                    authStatus = this.processAuthorisation();
                }
                if (authStatus != AuthStatus.SUCCESS) continue;
                this.authorised = true;
            }
            while (this.dataModeIN == DataMode.BINARY && this.getInputStream().available() != 0) {
                recByte = this.readBinary();
                if (recByte == null) {
                    this.lost = true;
                    return;
                }
                if (this.getCommunicationLogging() && this.authorised) {
                    if (this.getServer().isRawCommunicationLogging()) {
                        if (this.getServer().getRawCommunicationMaxLength() > 0 && recByte.length > this.getServer().getRawCommunicationMaxLength()) {
                            this.appLogger.log(Level.FINE, "Got BINARY [{0}] : {1}; RAW: {2}{3}", new Object[]{this.getHostAddress(), MyString.getMemInfo(recByte.length), new String(recByte, 0, this.getServer().getRawCommunicationMaxLength(), this.charset), "..."});
                        } else {
                            this.appLogger.log(Level.FINE, "Got BINARY [{0}] : {1}; RAW: {2}", new Object[]{this.getHostAddress(), MyString.getMemInfo(recByte.length), new String(recByte, this.charset)});
                        }
                    } else {
                        this.appLogger.log(Level.FINE, "Got BINARY [{0}] : {1}", new Object[]{this.getHostAddress(), MyString.getMemInfo(recByte.length)});
                    }
                } else if (this.getCommunicationLogging()) {
                    this.appLogger.log(Level.FINE, "Got BINARY [{0}] : {1}", new Object[]{this.getHostAddress(), MyString.getMemInfo(recByte.length)});
                }
                this.totalReadBytes += recByte.length;
                if (!this.authorised) {
                    authStatus = this.clientAuthenticationHandler.handleAuthentication((ClientHandler)this, recByte);
                } else {
                    this.clientBinaryHandler.handleBinary(this, recByte);
                }
                if (this.isClosed()) {
                    return;
                }
                while (authStatus == AuthStatus.FAILURE) {
                    authStatus = this.processAuthorisation();
                }
                if (authStatus != AuthStatus.SUCCESS) continue;
                this.authorised = true;
            }
            if (this.dataModeIN == DataMode.STRING || this.dataModeIN == DataMode.OBJECT || this.dataModeIN == DataMode.BYTE || this.dataModeIN == DataMode.BINARY) continue;
            throw new IllegalStateException("Incoming DataMode is not supported : " + this.dataModeIN);
        } while (this.getInputStream().available() != 0);
    }

    public void registerForRead() throws IOException, ClosedChannelException {
        block11: {
            try {
                if (this.getSelectionKey() == null) {
                    boolean flag = this.getServer().registerChannel(this.getSocketChannel(), 1, this);
                    if (flag) {
                        logger.finest("Adding OP_READ as interest Ops for " + this.getName());
                    } else if (ByteBufferOutputStream.isLoggable(Level.FINEST)) {
                        logger.finest("OP_READ is already present in interest Ops for " + this.getName());
                    }
                    break block11;
                }
                if (this.getSelectionKey().isValid()) {
                    if ((this.getSelectionKey().interestOps() & 1) == 0) {
                        logger.finest("Adding OP_READ to interest Ops for " + this.getName());
                        this.removeEvent(ClientEvent.READ);
                        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() | 1);
                        if (wakeupSelectorAfterRegisterRead) {
                            this.getServer().getSelector().wakeup();
                        }
                    } else if (ByteBufferOutputStream.isLoggable(Level.FINEST)) {
                        logger.finest("OP_READ is already present in interest Ops for " + this.getName());
                    }
                    break block11;
                }
                throw new IOException("SelectionKey is invalid!");
            }
            catch (CancelledKeyException e) {
                throw new IOException("SelectionKey is cancelled!");
            }
        }
    }

    public void registerForWrite() throws IOException, ClosedChannelException {
        if (this.hasEvent(ClientEvent.RUN_BLOCKING) || this.hasEvent(ClientEvent.MAX_CON_BLOCKING)) {
            throw new IllegalStateException("This method is only allowed under Non-Blocking mode.");
        }
        if (this.clientWriteHandler == null) {
            throw new IllegalStateException("ClientWriteHandler has not been set!");
        }
        this.registerWrite();
    }

    public void registerWrite() throws IOException {
        block11: {
            try {
                if (this.getSelectionKey() == null) {
                    boolean flag = this.getServer().registerChannel(this.getSocketChannel(), 4, this);
                    if (flag) {
                        logger.finest("Adding OP_WRITE as interest Ops for " + this.getName());
                    } else if (ByteBufferOutputStream.isLoggable(Level.FINEST)) {
                        logger.finest("OP_WRITE is already present in interest Ops for " + this.getName());
                    }
                    break block11;
                }
                if (this.getSelectionKey().isValid()) {
                    if ((this.getSelectionKey().interestOps() & 4) == 0) {
                        logger.finest("Adding OP_WRITE to interest Ops for " + this.getName());
                        this.removeEvent(ClientEvent.WRITE);
                        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() | 4);
                        if (wakeupSelectorAfterRegisterWrite) {
                            this.getServer().getSelector().wakeup();
                        }
                    } else if (ByteBufferOutputStream.isLoggable(Level.FINEST)) {
                        logger.finest("OP_WRITE is already present in interest Ops for " + this.getName());
                    }
                    break block11;
                }
                throw new IOException("SelectionKey is invalid!");
            }
            catch (CancelledKeyException e) {
                throw new IOException("SelectionKey is cancelled!");
            }
        }
    }

    protected void setClientWriteHandler(ClientWriteHandler handler) {
        this.clientWriteHandler = handler;
    }

    public int getThreadAccessCount() {
        return this.threadAccessCount;
    }

    private void doHandshake() throws Exception {
        while (true) {
            logger.fine("handshakeStatus: " + (Object)((Object)this.handshakeStatus));
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.initialHandshakeStatus) {
                    this.finishInitialHandshake();
                }
                return;
            }
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.doTasks();
                continue;
            }
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                return;
            }
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                ByteBuffer netData = (ByteBuffer)this.getServer().getByteBufferPool().borrowObject();
                SSLEngineResult res = this.sslEngine.wrap(this.dummyByteBuffer, netData);
                logger.info("Wrapping:\n" + res);
                assert (res.bytesProduced() != 0) : "No net data produced during handshake wrap.";
                assert (res.bytesConsumed() == 0) : "App data consumed during handshake wrap.";
                this.handshakeStatus = res.getHandshakeStatus();
                this.byteBufferOutputStream.addEncryptedByteBuffer(netData);
                if (this.doWrite()) continue;
                return;
            }
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
        }
        assert (false) : "doHandshake() should never reach the NOT_HANDSHAKING state";
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            logger.fine("Running the task.. START ");
            task.run();
            logger.fine("Running the task.. END");
        }
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        logger.fine("handshakeStatus: " + (Object)((Object)this.handshakeStatus));
    }

    private void finishInitialHandshake() throws IOException {
        this.initialHandshakeStatus = false;
    }

    public boolean getInitialHandshakeStatus() {
        return this.initialHandshakeStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer encrypt(ByteBuffer src) throws IOException {
        ByteBuffer byteBuffer;
        if (this.initialHandshakeStatus) {
            logger.fine("Writing not possible during handshake!");
            return null;
        }
        ByteBuffer dest = null;
        boolean isException = false;
        try {
            try {
                src.flip();
                dest = (ByteBuffer)this.getServer().getByteBufferPool().borrowObject();
                SSLEngineResult res = this.sslEngine.wrap(src, dest);
                logger.info("Wrapping:\n" + res);
                byteBuffer = dest;
                Object var7_8 = null;
                if (!isException) return byteBuffer;
                if (dest == null) return byteBuffer;
            }
            catch (IOException e) {
                logger.warning("IOException:" + e);
                isException = true;
                throw e;
            }
            catch (Exception e) {
                logger.warning("Exception:" + e);
                isException = true;
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!isException) throw throwable;
            if (dest == null) throw throwable;
            try {
                this.getServer().getByteBufferPool().returnObject((Object)dest);
                throw throwable;
            }
            catch (Exception er) {
                logger.warning("Error in returning ByteBuffer to pool: " + er);
                throw throwable;
            }
        }
        try {}
        catch (Exception er) {
            logger.warning("Error in returning ByteBuffer to pool: " + er);
            return byteBuffer;
        }
        this.getServer().getByteBufferPool().returnObject((Object)dest);
        return byteBuffer;
    }
}

