/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.logging.Logger;
import org.quickserver.net.server.ClientCommandHandler;
import org.quickserver.net.server.ClientEventHandler;
import org.quickserver.net.server.ClientHandler;

public class DefaultClientEventHandler
implements ClientEventHandler {
    private static Logger logger = Logger.getLogger(DefaultClientEventHandler.class.getName());
    private ClientCommandHandler clientCommandHandler = null;
    private Method gotConnectedMethod = null;
    private Method lostConnectionMethod = null;
    private Method closingConnectionMethod = null;

    public void setClientCommandHandler(ClientCommandHandler handler) {
        this.clientCommandHandler = handler;
        if (this.clientCommandHandler != null) {
            this.loadMethods();
        }
    }

    public void gotConnected(ClientHandler handler) throws SocketTimeoutException, IOException {
        if (this.gotConnectedMethod == null) {
            handler.sendSystemMsg("Connection opened: " + handler.getHostAddress());
        } else {
            this.invoke(this.gotConnectedMethod, handler);
        }
    }

    public void lostConnection(ClientHandler handler) throws IOException {
        if (this.lostConnectionMethod == null) {
            handler.sendSystemMsg("Connection lost: " + handler.getHostAddress());
        } else {
            this.invoke(this.lostConnectionMethod, handler);
        }
    }

    public void closingConnection(ClientHandler handler) throws IOException {
        if (this.closingConnectionMethod == null) {
            handler.sendSystemMsg("Connection closing: " + handler.getHostAddress());
        } else {
            this.invoke(this.closingConnectionMethod, handler);
        }
    }

    private void loadMethods() {
        Class<?> cls = this.clientCommandHandler.getClass();
        try {
            this.gotConnectedMethod = cls.getMethod("gotConnected", ClientHandler.class);
        }
        catch (NoSuchMethodException ex) {
            logger.fine("Error finding gotConnected : " + ex);
        }
        try {
            this.lostConnectionMethod = cls.getMethod("lostConnection", ClientHandler.class);
        }
        catch (NoSuchMethodException ex) {
            logger.fine("Error finding lostConnection : " + ex);
        }
        try {
            this.closingConnectionMethod = cls.getMethod("closingConnection", ClientHandler.class);
        }
        catch (NoSuchMethodException ex) {
            logger.fine("Error finding lostConnection : " + ex);
        }
    }

    private void invoke(Method method, ClientHandler handler) throws SocketTimeoutException, IOException {
        try {
            method.invoke((Object)this.clientCommandHandler, handler);
        }
        catch (IllegalAccessException e) {
            logger.warning("Error invoking " + method + " : " + e);
        }
        catch (InvocationTargetException e) {
            Exception cause = (Exception)e.getCause();
            if (cause != null) {
                if (SocketTimeoutException.class.isInstance(cause)) {
                    throw (SocketTimeoutException)cause;
                }
                if (IOException.class.isInstance(cause)) {
                    throw (IOException)cause;
                }
            }
            logger.warning("Error invoking " + method + " : " + e + "\n Cause: " + cause);
            IOException ioe = new IOException();
            ioe.initCause(cause);
            throw ioe;
        }
    }
}

