/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.quickserver.net.server.PoolManager;
import org.quickserver.util.xmlreader.PoolConfig;

public class BasicPoolManager
implements PoolManager {
    private static final Logger logger = Logger.getLogger(BasicPoolManager.class.getName());

    protected GenericObjectPool.Config configurePool(PoolConfig opConfig) {
        GenericObjectPool.Config bconfig = new GenericObjectPool.Config();
        bconfig.maxActive = opConfig.getMaxActive();
        bconfig.maxIdle = opConfig.getMaxIdle();
        bconfig.testOnReturn = true;
        bconfig.timeBetweenEvictionRunsMillis = 180000L;
        bconfig.minEvictableIdleTimeMillis = 120000L;
        return bconfig;
    }

    public ObjectPool makeByteBufferPool(PoolableObjectFactory factory, PoolConfig opConfig) {
        GenericObjectPool.Config bconfig = this.configurePool(opConfig);
        bconfig.whenExhaustedAction = 1;
        return new GenericObjectPool(factory, bconfig);
    }

    public ObjectPool makeClientPool(PoolableObjectFactory factory, PoolConfig opConfig) {
        GenericObjectPool.Config bconfig = this.configurePool(opConfig);
        bconfig.whenExhaustedAction = 0;
        return new GenericObjectPool(factory, bconfig);
    }

    public ObjectPool makeClientHandlerPool(PoolableObjectFactory factory, PoolConfig opConfig) {
        GenericObjectPool.Config bconfig = this.configurePool(opConfig);
        bconfig.whenExhaustedAction = 0;
        return new GenericObjectPool(factory, bconfig);
    }

    public ObjectPool makeClientDataPool(PoolableObjectFactory factory, PoolConfig opConfig) {
        GenericObjectPool.Config bconfig = this.configurePool(opConfig);
        bconfig.whenExhaustedAction = 0;
        return new GenericObjectPool(factory, bconfig);
    }

    public void initPool(ObjectPool objectPool, PoolConfig opConfig) {
        int initSize = opConfig.getInitSize();
        try {
            while (objectPool.getNumIdle() < initSize) {
                objectPool.addObject();
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error: {0}", e);
        }
    }
}

