/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.quickserver.net.AppException;
import org.quickserver.net.InitServerHook;
import org.quickserver.net.ServerHook;
import org.quickserver.net.Service;
import org.quickserver.net.qsadmin.QSAdminServer;
import org.quickserver.net.server.Authenticator;
import org.quickserver.net.server.ClientAuthenticationHandler;
import org.quickserver.net.server.ClientBinaryHandler;
import org.quickserver.net.server.ClientCommandHandler;
import org.quickserver.net.server.ClientData;
import org.quickserver.net.server.ClientEvent;
import org.quickserver.net.server.ClientEventHandler;
import org.quickserver.net.server.ClientExtendedEventHandler;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.ClientIdentifier;
import org.quickserver.net.server.ClientObjectHandler;
import org.quickserver.net.server.ClientWriteHandler;
import org.quickserver.net.server.DataMode;
import org.quickserver.net.server.DataType;
import org.quickserver.net.server.GhostSocketReaper;
import org.quickserver.net.server.PoolManager;
import org.quickserver.net.server.TheClient;
import org.quickserver.net.server.gui.About;
import org.quickserver.net.server.impl.DefaultClientEventHandler;
import org.quickserver.net.server.impl.RegisterChannelRequest;
import org.quickserver.security.SecureStoreManager;
import org.quickserver.sql.DBPoolUtil;
import org.quickserver.util.Assertion;
import org.quickserver.util.ClassUtil;
import org.quickserver.util.JvmUtil;
import org.quickserver.util.MyString;
import org.quickserver.util.TextFile;
import org.quickserver.util.io.ByteBufferInputStream;
import org.quickserver.util.io.ByteBufferOutputStream;
import org.quickserver.util.pool.ByteBufferObjectFactory;
import org.quickserver.util.pool.ClientHandlerObjectFactory;
import org.quickserver.util.pool.PoolHelper;
import org.quickserver.util.pool.PoolableObject;
import org.quickserver.util.pool.QSObjectPool;
import org.quickserver.util.pool.QSObjectPoolMaker;
import org.quickserver.util.pool.thread.ClientPool;
import org.quickserver.util.pool.thread.ThreadObjectFactory;
import org.quickserver.util.xmlreader.AccessConstraintConfig;
import org.quickserver.util.xmlreader.BasicServerConfig;
import org.quickserver.util.xmlreader.ConfigReader;
import org.quickserver.util.xmlreader.DBObjectPoolConfig;
import org.quickserver.util.xmlreader.DefaultDataMode;
import org.quickserver.util.xmlreader.InitServerHooks;
import org.quickserver.util.xmlreader.PoolConfig;
import org.quickserver.util.xmlreader.QSAdminServerConfig;
import org.quickserver.util.xmlreader.QuickServerConfig;
import org.quickserver.util.xmlreader.Secure;
import org.quickserver.util.xmlreader.ServerHooks;

public class QuickServer
implements Runnable,
Service,
Cloneable,
Serializable {
    private static final String VER = "2.1.0";
    private static final String NEW_LINE = System.getProperty("org.quickserver.useOSLineSeparator") != null && System.getProperty("org.quickserver.useOSLineSeparator").equals("true") ? System.getProperty("line.separator") : "\r\n";
    private static final String pid;
    private String serverBanner;
    private String clientAuthenticationHandlerString;
    private String clientEventHandlerString;
    private String clientExtendedEventHandlerString;
    private String clientCommandHandlerString;
    private String clientObjectHandlerString;
    private String clientBinaryHandlerString;
    private String clientWriteHandlerString;
    private String clientDataString;
    private Authenticator authenticator;
    private ClientAuthenticationHandler clientAuthenticationHandler;
    private ClientEventHandler clientEventHandler;
    private ClientExtendedEventHandler clientExtendedEventHandler;
    private ClientCommandHandler clientCommandHandler;
    private ClientObjectHandler clientObjectHandler;
    private ClientBinaryHandler clientBinaryHandler;
    private ClientWriteHandler clientWriteHandler;
    private ClientData clientData;
    protected Class clientDataClass;
    private int serverPort = 9876;
    private Thread t;
    protected ServerSocket server;
    private String serverName = "QuickServer";
    private long maxConnection = -1L;
    private int socketTimeout = 60000;
    private String maxConnectionMsg = "-ERR Server Busy. Max Connection Reached";
    private String timeoutMsg = "-ERR Timeout";
    private String maxAuthTryMsg = "-ERR Max Auth Try Reached";
    private int maxAuthTry = 5;
    private InetAddress ipAddr;
    protected boolean stopServer;
    private Object[] storeObjects;
    private QSAdminServer adminServer;
    private static final Logger logger;
    private Logger appLogger;
    private long suspendMaxConnection;
    private String suspendMaxConnectionMsg;
    private int serviceState = -1;
    private QuickServerConfig config = new QuickServerConfig();
    private String consoleLoggingformatter;
    private String consoleLoggingLevel = "INFO";
    private ClientPool pool;
    private ObjectPool clientHandlerPool;
    private ObjectPool clientDataPool;
    private DBPoolUtil dBPoolUtil;
    private String loggingLevel = "INFO";
    private boolean skipValidation = false;
    private boolean communicationLogging = true;
    private String securityManagerClass;
    private AccessConstraintConfig accessConstraintConfig;
    private ClassLoader classLoader;
    private String applicationJarPath;
    private ServerHooks serverHooks;
    private ArrayList listOfServerHooks;
    private Secure secure;
    private BasicServerConfig basicConfig = this.config;
    private SSLContext sslc;
    private KeyManager[] km = null;
    private TrustManager[] tm = null;
    private boolean runningSecure = false;
    private SecureStoreManager secureStoreManager = null;
    private Exception exceptionInRun = null;
    private ServerSocketChannel serverSocketChannel;
    private Selector selector;
    private boolean blockingMode = true;
    private ObjectPool byteBufferPool;
    private Date lastStartTime;
    private ClientIdentifier clientIdentifier;
    private GhostSocketReaper ghostSocketReaper;
    private PoolManager poolManager;
    private QSObjectPoolMaker qsObjectPoolMaker;
    private DataMode defaultDataModeIN = DataMode.STRING;
    private DataMode defaultDataModeOUT = DataMode.STRING;
    private Throwable serviceError;
    private Map registerChannelRequestMap;
    private boolean rawCommunicationLogging = false;
    private int rawCommunicationMaxLength = 100;

    public static final String getVersion() {
        return VER;
    }

    public static final float getVersionNo() {
        return QuickServer.getVersionNo(VER);
    }

    public static final float getVersionNo(String ver) {
        int j;
        float version = 0.0f;
        int i = ver.indexOf(" ");
        if (i == -1) {
            i = ver.length();
        }
        if ((i = (ver = ver.substring(0, i)).indexOf(".")) != -1 && (j = ver.indexOf(".", i)) != -1) {
            ver = ver.substring(0, i) + "." + MyString.replaceAll(ver.substring(i + 1), ".", "");
        }
        try {
            version = Float.parseFloat(ver);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Corrupt QuickServer");
        }
        return version;
    }

    public static String getNewLine() {
        return NEW_LINE;
    }

    public String toString() {
        return this.serverName + " : " + this.getPort();
    }

    public QuickServer() {
    }

    public QuickServer(String commandHandler) {
        this.setClientCommandHandler(commandHandler);
    }

    public QuickServer(String commandHandler, int port) {
        this(commandHandler);
        this.setPort(port);
    }

    public void startServer() throws AppException {
        logger.log(Level.FINE, "Starting {0}", this.getName());
        if (!this.isClosed()) {
            logger.log(Level.WARNING, "Server {0} already running.", this.getName());
            throw new AppException("Server " + this.getName() + " already running.");
        }
        this.blockingMode = this.getBasicConfig().getServerMode().getBlocking();
        if (!this.blockingMode) {
            logger.warning("QuickServer no longer supports non-blocking mode! So will run in blocking mode.");
            this.blockingMode = true;
            this.getBasicConfig().getServerMode().setBlocking(this.blockingMode);
        }
        if (this.serverBanner == null) {
            this.serverBanner = "\n-------------------------------\n Name : " + this.getName() + "\n Port : " + this.getPort() + "\n-------------------------------\n";
            logger.finest("Default Server Banner Generated");
        }
        try {
            this.loadApplicationClasses();
            Class clientIdentifierClass = this.getClass(this.getBasicConfig().getAdvancedSettings().getClientIdentifier(), true);
            this.clientIdentifier = (ClientIdentifier)clientIdentifierClass.newInstance();
            this.clientIdentifier.setQuickServer(this);
            Class poolManagerClass = this.getClass(this.getBasicConfig().getObjectPoolConfig().getPoolManager(), true);
            this.poolManager = (PoolManager)poolManagerClass.newInstance();
            Class qsObjectPoolMakerClass = this.getClass(this.getBasicConfig().getAdvancedSettings().getQsObjectPoolMaker(), true);
            this.qsObjectPoolMaker = (QSObjectPoolMaker)qsObjectPoolMakerClass.newInstance();
            this.loadServerHooksClasses();
            this.processServerHooks(100);
            if (this.getSecure().isLoad()) {
                this.loadSSLContext();
            }
            this.loadBusinessLogic();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Could not load class/s: " + e, e);
            throw new AppException("Could not load class/s : " + e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "Could not instantiate class/s: " + e, e);
            throw new AppException("Could not instantiate class/s: " + e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Illegal access to class/s: " + e, e);
            throw new AppException("Illegal access to class/s: " + e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException: " + e, e);
            throw new AppException("IOException: " + e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception: " + e, e);
            logger.log(Level.FINE, "StackTrace:\n{0}", MyString.getStackTrace(e));
            throw new AppException("Exception : " + e);
        }
        if (this.getSecurityManagerClass() != null) {
            System.setSecurityManager(this.getSecurityManager());
        }
        this.setServiceState(1);
        this.t = new Thread((Runnable)this, "QuickServer - " + this.getName());
        this.t.start();
        do {
            Thread.yield();
        } while (this.getServiceState() == 1);
        if (this.getServiceState() != 5) {
            if (this.exceptionInRun != null) {
                throw new AppException("Could not start server " + this.getName() + "! Details: " + this.exceptionInRun);
            }
            throw new AppException("Could not start server " + this.getName());
        }
        this.lastStartTime = new Date();
        logger.log(Level.FINE, "Started {0}, Date: {1}", new Object[]{this.getName(), this.lastStartTime});
    }

    public void stopServer() throws AppException {
        this.processServerHooks(201);
        logger.log(Level.WARNING, "Stopping {0}", this.getName());
        this.stopServer = true;
        Socket death = null;
        if (this.isClosed()) {
            logger.log(Level.WARNING, "Server {0} is not running!", this.getName());
            throw new AppException("Server " + this.getName() + " is not running!");
        }
        try {
            if (this.getBlockingMode()) {
                if (!this.getSecure().isEnable()) {
                    death = new Socket(this.server.getInetAddress(), this.server.getLocalPort());
                    death.getInputStream().read();
                    death.close();
                } else {
                    death = this.getSSLSocketFactory().createSocket(this.server.getInetAddress(), this.server.getLocalPort());
                    Thread.sleep(100L);
                    death.close();
                }
            }
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "IOError stopping {0}: {1}", new Object[]{this.getName(), e});
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error stopping {0}: {1}", new Object[]{this.getName(), e});
            throw new AppException("Error in stopServer " + this.getName() + ": " + e);
        }
        int i = 0;
        while (this.getServiceState() != 0) {
            try {
                Thread.sleep(60L);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error waiting for {0} to fully stop. Error: {1}", new Object[]{this.getName(), e});
            }
            if (i > 1000) {
                logger.severe("Server was not stopped even after 10sec.. will terminate now.");
                System.exit(-1);
            }
            ++i;
        }
        if (this.adminServer == null || this.getQSAdminServer().getServer() != this) {
            this.setClassLoader(null);
        }
        logger.log(Level.INFO, "Stopped {0}", this.getName());
    }

    public void restartServer() throws AppException {
        this.stopServer();
        this.startServer();
    }

    public String getName() {
        return this.serverName;
    }

    public void setName(String name) {
        this.serverName = name;
        logger.log(Level.FINEST, "Set to : {0}", name);
    }

    public String getServerBanner() {
        return this.serverBanner;
    }

    public void setServerBanner(String banner) {
        this.serverBanner = banner;
        logger.log(Level.FINEST, "Set to : {0}", banner);
    }

    public void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Port number can not be less than 0!");
        }
        this.serverPort = port;
        logger.log(Level.FINEST, "Set to {0}", port);
    }

    public int getPort() {
        if (!this.isClosed()) {
            return this.server.getLocalPort();
        }
        if (!this.getSecure().isEnable()) {
            return this.serverPort;
        }
        int _port = this.getSecure().getPort();
        if (_port == -1) {
            return this.serverPort;
        }
        return _port;
    }

    public void setClientCommandHandler(String handler) {
        this.clientCommandHandlerString = handler;
        logger.log(Level.FINEST, "Set to {0}", handler);
    }

    public String getClientCommandHandler() {
        return this.clientCommandHandlerString;
    }

    public void setClientAuthenticationHandler(String authenticator) {
        this.clientAuthenticationHandlerString = authenticator;
        logger.log(Level.FINEST, "Set to {0}", authenticator);
    }

    public String getClientAuthenticationHandler() {
        return this.clientAuthenticationHandlerString;
    }

    public void setAuthenticator(String authenticator) {
        this.clientAuthenticationHandlerString = authenticator;
        logger.log(Level.FINEST, "Set to {0}", authenticator);
    }

    public String getAuthenticator() {
        return this.clientAuthenticationHandlerString;
    }

    public void setClientData(String data) {
        this.clientDataString = data;
        logger.log(Level.FINEST, "Set to {0}", data);
    }

    public String getClientData() {
        return this.clientDataString;
    }

    public void setTimeout(int time) {
        this.socketTimeout = time > 0 ? time : 0;
        logger.log(Level.FINEST, "Set to {0}", this.socketTimeout);
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    public void setMaxAuthTry(int authTry) {
        this.maxAuthTry = authTry;
        logger.log(Level.FINEST, "Set to {0}", authTry);
    }

    public int getMaxAuthTry() {
        return this.maxAuthTry;
    }

    public void setMaxAuthTryMsg(String msg) {
        this.maxAuthTryMsg = msg;
        logger.log(Level.FINEST, "Set to {0}", msg);
    }

    public String getMaxAuthTryMsg() {
        return this.maxAuthTryMsg;
    }

    public void setTimeoutMsg(String msg) {
        this.timeoutMsg = msg;
        logger.log(Level.FINEST, "Set to {0}", msg);
    }

    public String getTimeoutMsg() {
        return this.timeoutMsg;
    }

    private TheClient initTheClient() {
        TheClient theClient = new TheClient();
        theClient.setServer(this);
        theClient.setTimeoutMsg(this.getTimeoutMsg());
        theClient.setMaxAuthTry(this.getMaxAuthTry());
        theClient.setMaxAuthTryMsg(this.getMaxAuthTryMsg());
        theClient.setClientEventHandler(this.clientEventHandler);
        theClient.setClientExtendedEventHandler(this.clientExtendedEventHandler);
        theClient.setClientCommandHandler(this.clientCommandHandler);
        theClient.setClientObjectHandler(this.clientObjectHandler);
        theClient.setClientBinaryHandler(this.clientBinaryHandler);
        theClient.setClientWriteHandler(this.clientWriteHandler);
        theClient.setAuthenticator(this.authenticator);
        theClient.setClientAuthenticationHandler(this.clientAuthenticationHandler);
        theClient.setTimeout(this.socketTimeout);
        theClient.setMaxConnectionMsg(this.maxConnectionMsg);
        theClient.setCommunicationLogging(this.getCommunicationLogging());
        return theClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block64: {
            block57: {
                block55: {
                    block56: {
                        this.exceptionInRun = null;
                        TheClient theClient = this.initTheClient();
                        try {
                            try {
                                this.stopServer = false;
                                this.closeAllPools();
                                this.initAllPools();
                                this.makeServerSocket();
                                if (this.getServerBanner().length() > 0) {
                                    System.out.println(this.getServerBanner());
                                }
                                this.setServiceState(5);
                                this.processServerHooks(101);
                                if (!this.getBlockingMode()) {
                                    this.runNonBlocking(theClient);
                                    if (this.stopServer) {
                                        logger.log(Level.FINEST, "Closing selector for {0}", this.getName());
                                        this.selector.close();
                                    }
                                    Object var4_2 = null;
                                    if (!this.getBlockingMode()) break block55;
                                    logger.log(Level.WARNING, "Closing {0}", this.getName());
                                    break block56;
                                }
                                this.runBlocking(theClient);
                                break block57;
                            }
                            catch (BindException e) {
                                block59: {
                                    this.exceptionInRun = e;
                                    logger.log(Level.SEVERE, "{0} BindException for Port {1} @ {2} : {3}", new Object[]{this.getName(), this.getPort(), this.getBindAddr().getHostAddress(), e.getMessage()});
                                    Object var4_4 = null;
                                    if (this.getBlockingMode()) {
                                        logger.log(Level.WARNING, "Closing {0}", this.getName());
                                        try {
                                            if (!this.isClosed()) {
                                                this.server.close();
                                            }
                                        }
                                        catch (Exception e2) {
                                            throw new RuntimeException(e2);
                                        }
                                        this.server = null;
                                        this.serverSocketChannel = null;
                                        this.setServiceState(0);
                                        logger.log(Level.WARNING, "Closed {0}", this.getName());
                                        this.processServerHooks(202);
                                        return;
                                    }
                                    if (this.getBlockingMode()) return;
                                    if (this.exceptionInRun == null) return;
                                    logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
                                    try {
                                        if (this.isClosed()) break block59;
                                        if (this.serverSocketChannel != null) {
                                            this.serverSocketChannel.close();
                                        }
                                        if (this.server != null) {
                                            this.server.close();
                                        }
                                    }
                                    catch (Exception e3) {
                                        throw new RuntimeException(e3);
                                    }
                                }
                                this.server = null;
                                this.serverSocketChannel = null;
                                this.setServiceState(0);
                                logger.log(Level.WARNING, "Closed {0}", this.getName());
                                this.processServerHooks(202);
                                return;
                            }
                            catch (SSLException e) {
                                block60: {
                                    this.exceptionInRun = e;
                                    logger.log(Level.SEVERE, "SSLException {0}", e);
                                    logger.log(Level.FINE, "StackTrace:\n{0}", MyString.getStackTrace(e));
                                    Object var4_5 = null;
                                    if (!this.getBlockingMode()) break block60;
                                    logger.log(Level.WARNING, "Closing {0}", this.getName());
                                    try {}
                                    catch (Exception e2) {
                                        throw new RuntimeException(e2);
                                    }
                                    if (!this.isClosed()) {
                                        this.server.close();
                                    }
                                    this.server = null;
                                    this.serverSocketChannel = null;
                                    this.setServiceState(0);
                                    logger.log(Level.WARNING, "Closed {0}", this.getName());
                                    this.processServerHooks(202);
                                    return;
                                }
                                if (this.getBlockingMode()) return;
                                if (this.exceptionInRun == null) return;
                                logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
                                try {}
                                catch (Exception e3) {
                                    throw new RuntimeException(e3);
                                }
                                if (!this.isClosed()) {
                                    if (this.serverSocketChannel != null) {
                                        this.serverSocketChannel.close();
                                    }
                                    if (this.server != null) {
                                        this.server.close();
                                    }
                                }
                                this.server = null;
                                this.serverSocketChannel = null;
                                this.setServiceState(0);
                                logger.log(Level.WARNING, "Closed {0}", this.getName());
                                this.processServerHooks(202);
                                return;
                            }
                            catch (IOException e) {
                                block61: {
                                    this.exceptionInRun = e;
                                    logger.log(Level.SEVERE, "IOError {0}", e);
                                    logger.log(Level.FINE, "StackTrace:\n{0}", MyString.getStackTrace(e));
                                    Object var4_6 = null;
                                    if (!this.getBlockingMode()) break block61;
                                    logger.log(Level.WARNING, "Closing {0}", this.getName());
                                    try {}
                                    catch (Exception e2) {
                                        throw new RuntimeException(e2);
                                    }
                                    if (!this.isClosed()) {
                                        this.server.close();
                                    }
                                    this.server = null;
                                    this.serverSocketChannel = null;
                                    this.setServiceState(0);
                                    logger.log(Level.WARNING, "Closed {0}", this.getName());
                                    this.processServerHooks(202);
                                    return;
                                }
                                if (this.getBlockingMode()) return;
                                if (this.exceptionInRun == null) return;
                                logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
                                try {}
                                catch (Exception e3) {
                                    throw new RuntimeException(e3);
                                }
                                if (!this.isClosed()) {
                                    if (this.serverSocketChannel != null) {
                                        this.serverSocketChannel.close();
                                    }
                                    if (this.server != null) {
                                        this.server.close();
                                    }
                                }
                                this.server = null;
                                this.serverSocketChannel = null;
                                this.setServiceState(0);
                                logger.log(Level.WARNING, "Closed {0}", this.getName());
                                this.processServerHooks(202);
                                return;
                            }
                            catch (Exception e) {
                                block62: {
                                    this.exceptionInRun = e;
                                    logger.log(Level.SEVERE, "Error {0}", e);
                                    logger.log(Level.FINE, "StackTrace:\n{0}", MyString.getStackTrace(e));
                                    Object var4_7 = null;
                                    if (!this.getBlockingMode()) break block62;
                                    logger.log(Level.WARNING, "Closing {0}", this.getName());
                                    try {}
                                    catch (Exception e2) {
                                        throw new RuntimeException(e2);
                                    }
                                    if (!this.isClosed()) {
                                        this.server.close();
                                    }
                                    this.server = null;
                                    this.serverSocketChannel = null;
                                    this.setServiceState(0);
                                    logger.log(Level.WARNING, "Closed {0}", this.getName());
                                    this.processServerHooks(202);
                                    return;
                                }
                                if (this.getBlockingMode()) return;
                                if (this.exceptionInRun == null) return;
                                logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
                                try {}
                                catch (Exception e3) {
                                    throw new RuntimeException(e3);
                                }
                                if (!this.isClosed()) {
                                    if (this.serverSocketChannel != null) {
                                        this.serverSocketChannel.close();
                                    }
                                    if (this.server != null) {
                                        this.server.close();
                                    }
                                }
                                this.server = null;
                                this.serverSocketChannel = null;
                                this.setServiceState(0);
                                logger.log(Level.WARNING, "Closed {0}", this.getName());
                                this.processServerHooks(202);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            block63: {
                                Object var4_8 = null;
                                if (!this.getBlockingMode()) break block63;
                                logger.log(Level.WARNING, "Closing {0}", this.getName());
                                try {}
                                catch (Exception e2) {
                                    throw new RuntimeException(e2);
                                }
                                if (!this.isClosed()) {
                                    this.server.close();
                                }
                                this.server = null;
                                this.serverSocketChannel = null;
                                this.setServiceState(0);
                                logger.log(Level.WARNING, "Closed {0}", this.getName());
                                this.processServerHooks(202);
                                throw throwable;
                            }
                            if (this.getBlockingMode()) throw throwable;
                            if (this.exceptionInRun == null) throw throwable;
                            logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
                            try {}
                            catch (Exception e3) {
                                throw new RuntimeException(e3);
                            }
                            if (!this.isClosed()) {
                                if (this.serverSocketChannel != null) {
                                    this.serverSocketChannel.close();
                                }
                                if (this.server != null) {
                                    this.server.close();
                                }
                            }
                            this.server = null;
                            this.serverSocketChannel = null;
                            this.setServiceState(0);
                            logger.log(Level.WARNING, "Closed {0}", this.getName());
                            this.processServerHooks(202);
                            throw throwable;
                        }
                    }
                    try {}
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    if (!this.isClosed()) {
                        this.server.close();
                    }
                    this.server = null;
                    this.serverSocketChannel = null;
                    this.setServiceState(0);
                    logger.log(Level.WARNING, "Closed {0}", this.getName());
                    this.processServerHooks(202);
                    return;
                }
                if (this.getBlockingMode()) return;
                if (this.exceptionInRun == null) return;
                logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
                try {}
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
                if (!this.isClosed()) {
                    if (this.serverSocketChannel != null) {
                        this.serverSocketChannel.close();
                    }
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                this.server = null;
                this.serverSocketChannel = null;
                this.setServiceState(0);
                logger.log(Level.WARNING, "Closed {0}", this.getName());
                this.processServerHooks(202);
                return;
            }
            Object var4_3 = null;
            if (!this.getBlockingMode()) break block64;
            logger.log(Level.WARNING, "Closing {0}", this.getName());
            try {}
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            if (!this.isClosed()) {
                this.server.close();
            }
            this.server = null;
            this.serverSocketChannel = null;
            this.setServiceState(0);
            logger.log(Level.WARNING, "Closed {0}", this.getName());
            this.processServerHooks(202);
            return;
        }
        if (this.getBlockingMode()) return;
        if (this.exceptionInRun == null) return;
        logger.log(Level.WARNING, "Closing {0} - Had Error: {1}", new Object[]{this.getName(), this.exceptionInRun});
        try {}
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
        if (!this.isClosed()) {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.server != null) {
                this.server.close();
            }
        }
        this.server = null;
        this.serverSocketChannel = null;
        this.setServiceState(0);
        logger.log(Level.WARNING, "Closed {0}", this.getName());
        this.processServerHooks(202);
    }

    public void setMaxConnection(long maxConnection) {
        if (this.getServiceState() == 2) {
            this.suspendMaxConnection = maxConnection;
        } else {
            this.maxConnection = maxConnection;
        }
        logger.log(Level.FINEST, "Set to {0}", maxConnection);
    }

    public long getMaxConnection() {
        return this.maxConnection;
    }

    public long getClientCount() {
        if (this.clientHandlerPool != null) {
            try {
                return this.getClientHandlerPool().getNumActive();
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public long getHighestActiveClientCount() {
        if (this.clientHandlerPool != null) {
            try {
                return ((QSObjectPool)this.getClientHandlerPool()).getHighestActiveCount();
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setMaxConnectionMsg(String maxConnectionMsg) {
        if (this.getServiceState() == 2) {
            this.suspendMaxConnectionMsg = maxConnectionMsg;
        } else {
            this.maxConnectionMsg = maxConnectionMsg;
        }
        logger.log(Level.FINEST, "Set to {0}", maxConnectionMsg);
    }

    public String getMaxConnectionMsg() {
        return this.maxConnectionMsg;
    }

    public void setBindAddr(String bindAddr) throws UnknownHostException {
        this.ipAddr = InetAddress.getByName(bindAddr);
        logger.log(Level.FINEST, "Set to {0}", bindAddr);
    }

    public InetAddress getBindAddr() {
        if (this.ipAddr == null) {
            try {
                this.ipAddr = InetAddress.getByName("0.0.0.0");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to create default ip(0.0.0.0) : {0}", e);
                throw new RuntimeException("Error: Unable to find servers own ip : " + e);
            }
        }
        return this.ipAddr;
    }

    public void setStoreObjects(Object[] storeObjects) {
        this.storeObjects = storeObjects;
    }

    public Object[] getStoreObjects() {
        return this.storeObjects;
    }

    public void setQSAdminServerPort(int port) {
        this.getQSAdminServer().getServer().setPort(port);
    }

    public int getQSAdminServerPort() {
        return this.getQSAdminServer().getServer().getPort();
    }

    public void setQSAdminServerAuthenticator(String authenticator) {
        this.getQSAdminServer().getServer().setClientAuthenticationHandler(authenticator);
    }

    public String getQSAdminServerAuthenticator() {
        return this.getQSAdminServer().getServer().getAuthenticator();
    }

    public void startQSAdminServer(int port, String authenticator) throws AppException {
        this.getQSAdminServer().setClientAuthenticationHandler(authenticator);
        this.getQSAdminServer().startServer(port);
    }

    public void startQSAdminServer() throws AppException {
        this.getQSAdminServer().startServer();
    }

    public QSAdminServer getQSAdminServer() {
        if (this.adminServer == null) {
            this.adminServer = new QSAdminServer(this);
        }
        return this.adminServer;
    }

    public void setQSAdminServer(QSAdminServer adminServer) {
        if (adminServer == null) {
            this.adminServer = adminServer;
        }
    }

    public boolean isClosed() {
        if (this.server == null) {
            return true;
        }
        return this.server.isClosed();
    }

    public Logger getAppLogger() {
        if (this.appLogger != null) {
            return this.appLogger;
        }
        return logger;
    }

    public void setAppLogger(Logger appLogger) {
        this.appLogger = appLogger;
    }

    public void setClientObjectHandler(String handler) {
        this.clientObjectHandlerString = handler;
        logger.log(Level.FINEST, "Set to {0}", handler);
    }

    public String getClientObjectHandler() {
        return this.clientObjectHandlerString;
    }

    public void setConsoleLoggingFormatter(String formatter) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (formatter == null) {
            return;
        }
        this.consoleLoggingformatter = formatter;
        Formatter conformatter = (Formatter)this.getClass(formatter, true).newInstance();
        Logger jdkLogger = Logger.getLogger("");
        Handler[] handlers = jdkLogger.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            if (!ConsoleHandler.class.isInstance(handlers[index])) continue;
            handlers[index].setFormatter(conformatter);
        }
        logger.log(Level.FINEST, "Set to {0}", formatter);
    }

    public String getConsoleLoggingFormatter() {
        return this.consoleLoggingformatter;
    }

    public void setConsoleLoggingToMini() {
        try {
            this.setConsoleLoggingFormatter("org.quickserver.util.logging.MiniFormatter");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Setting to logging.MiniFormatter : {0}", e);
        }
    }

    public void setConsoleLoggingToMicro() {
        try {
            this.setConsoleLoggingFormatter("org.quickserver.util.logging.MicroFormatter");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Setting to MicroFormatter : {0}", e);
        }
    }

    public void setConsoleLoggingLevel(Level level) {
        Logger rlogger = Logger.getLogger("");
        Handler[] handlers = rlogger.getHandlers();
        boolean isConsole = true;
        try {
            if (System.console() == null) {
                isConsole = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int index = 0; index < handlers.length; ++index) {
            if (!ConsoleHandler.class.isInstance(handlers[index])) continue;
            if (!isConsole && level != Level.OFF) {
                System.out.println("QuickServer: You do not have a console.. so turning console logger off..");
                level = Level.OFF;
            }
            if (level == Level.OFF) {
                logger.info("QuickServer: Removing console handler.. ");
                rlogger.removeHandler(handlers[index]);
                handlers[index].setLevel(level);
                handlers[index].close();
                continue;
            }
            handlers[index].setLevel(level);
        }
        this.consoleLoggingLevel = level == Level.SEVERE ? "SEVERE" : (level == Level.WARNING ? "WARNING" : (level == Level.INFO ? "INFO" : (level == Level.CONFIG ? "CONFIG" : (level == Level.FINE ? "FINE" : (level == Level.FINER ? "FINER" : (level == Level.FINEST ? "FINEST" : (level == Level.OFF ? "OFF" : "UNKNOWN")))))));
        logger.log(Level.FINE, "Set to {0}", level);
    }

    public String getConsoleLoggingLevel() {
        return this.consoleLoggingLevel;
    }

    public void setLoggingLevel(Level level) {
        Logger rlogger = Logger.getLogger("");
        Handler[] handlers = rlogger.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level);
        }
        this.loggingLevel = level == Level.SEVERE ? "SEVERE" : (level == Level.WARNING ? "WARNING" : (level == Level.INFO ? "INFO" : (level == Level.CONFIG ? "CONFIG" : (level == Level.FINE ? "FINE" : (level == Level.FINER ? "FINER" : (level == Level.FINEST ? "FINEST" : (level == Level.OFF ? "OFF" : "UNKNOWN")))))));
        this.consoleLoggingLevel = this.loggingLevel;
        logger.log(Level.FINE, "Set to {0}", level);
    }

    public Throwable getServiceError() {
        return this.serviceError;
    }

    public synchronized boolean initService(Object[] param) {
        this.serviceError = null;
        try {
            this.initServer(param);
        }
        catch (Exception e) {
            this.serviceError = e;
            return false;
        }
        return true;
    }

    public synchronized boolean initService(QuickServerConfig qsConfig) {
        this.serviceError = null;
        try {
            this.initServer(qsConfig);
        }
        catch (Exception e) {
            this.serviceError = e;
            return false;
        }
        return true;
    }

    public boolean startService() {
        this.serviceError = null;
        if (this.getServiceState() == 5) {
            return false;
        }
        try {
            this.startServer();
        }
        catch (AppException e) {
            this.serviceError = e;
            return false;
        }
        return true;
    }

    public boolean stopService() {
        this.serviceError = null;
        if (this.getServiceState() == 0) {
            return false;
        }
        try {
            this.stopServer();
            this.clearAllPools();
        }
        catch (AppException e) {
            this.serviceError = e;
            return false;
        }
        catch (Exception e) {
            this.serviceError = e;
            return false;
        }
        return true;
    }

    public boolean suspendService() {
        this.serviceError = null;
        if (this.getServiceState() == 5) {
            this.suspendMaxConnection = this.maxConnection;
            this.suspendMaxConnectionMsg = this.maxConnectionMsg;
            this.maxConnection = 0L;
            this.maxConnectionMsg = "Service is suspended.";
            this.setServiceState(2);
            logger.log(Level.INFO, "Service {0} is suspended.", this.getName());
            return true;
        }
        return false;
    }

    public boolean resumeService() {
        this.serviceError = null;
        if (this.getServiceState() == 2) {
            this.maxConnection = this.suspendMaxConnection;
            this.maxConnectionMsg = this.suspendMaxConnectionMsg;
            this.setServiceState(5);
            logger.log(Level.INFO, "Service {0} resumed.", this.getName());
            return true;
        }
        return false;
    }

    public String info() {
        this.serviceError = null;
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName()).append("\n");
        buf.append(this.getBindAddr().getHostAddress()).append(" ");
        buf.append(this.getPort()).append("\n");
        return buf.toString();
    }

    public synchronized void initServer(Object[] param) throws AppException {
        QuickServerConfig qsConfig = null;
        try {
            qsConfig = ConfigReader.read((String)param[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not init server from xml file {0} : {1}", new Object[]{new File((String)param[0]).getAbsolutePath(), e});
            throw new AppException("Could not init server from xml file", e);
        }
        this.initServer(qsConfig);
    }

    public synchronized void initServer(QuickServerConfig qsConfig) throws AppException {
        this.setConfig(qsConfig);
        try {
            this.configQuickServer();
            this.loadApplicationClasses();
            InitServerHooks ish = this.getConfig().getInitServerHooks();
            if (ish != null) {
                Iterator iterator = ish.iterator();
                String initServerHookClassName = null;
                Class initServerHookClass = null;
                InitServerHook initServerHook = null;
                while (iterator.hasNext()) {
                    initServerHookClassName = (String)iterator.next();
                    initServerHookClass = this.getClass(initServerHookClassName, true);
                    initServerHook = (InitServerHook)initServerHookClass.newInstance();
                    logger.log(Level.INFO, "Loaded init server hook: {0}", initServerHookClassName);
                    logger.log(Level.FINE, "Init server hook info: {0}", initServerHook.info());
                    initServerHook.handleInit(this);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not load init server hook: {0}", e);
            logger.log(Level.WARNING, "StackTrace:\n{0}", MyString.getStackTrace(e));
            throw new AppException("Could not load init server hook", e);
        }
        this.setServiceState(1);
        logger.log(Level.FINEST, "\r\n{0}", MyString.getSystemInfo(QuickServer.getVersion()));
    }

    public int getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(int state) {
        this.serviceState = state;
    }

    private void configConsoleLoggingLevel(QuickServer qs, String temp) {
        if (temp.equals("SEVERE")) {
            qs.setConsoleLoggingLevel(Level.SEVERE);
        } else if (temp.equals("WARNING")) {
            qs.setConsoleLoggingLevel(Level.WARNING);
        } else if (temp.equals("INFO")) {
            qs.setConsoleLoggingLevel(Level.INFO);
        } else if (temp.equals("CONFIG")) {
            qs.setConsoleLoggingLevel(Level.CONFIG);
        } else if (temp.equals("FINE")) {
            qs.setConsoleLoggingLevel(Level.FINE);
        } else if (temp.equals("FINER")) {
            qs.setConsoleLoggingLevel(Level.FINER);
        } else if (temp.equals("FINEST")) {
            qs.setConsoleLoggingLevel(Level.FINEST);
        } else if (temp.equals("OFF")) {
            qs.setConsoleLoggingLevel(Level.OFF);
        } else {
            logger.log(Level.WARNING, "unknown level {0}", temp);
        }
    }

    public void configQuickServer(QuickServerConfig config) throws Exception {
        QuickServer qs = this;
        qs.setConfig(config);
        qs.setBasicConfig(config);
        String temp = config.getConsoleLoggingLevel();
        this.configConsoleLoggingLevel(qs, temp);
        temp = null;
        qs.setConsoleLoggingFormatter(config.getConsoleLoggingFormatter());
        qs.setName(config.getName());
        qs.setPort(config.getPort());
        qs.setClientEventHandler(config.getClientEventHandler());
        qs.setClientCommandHandler(config.getClientCommandHandler());
        if (config.getAuthenticator() != null) {
            qs.setAuthenticator(config.getAuthenticator());
        } else if (config.getClientAuthenticationHandler() != null) {
            qs.setClientAuthenticationHandler(config.getClientAuthenticationHandler());
        }
        qs.setClientObjectHandler(config.getClientObjectHandler());
        qs.setClientBinaryHandler(config.getClientBinaryHandler());
        qs.setClientWriteHandler(config.getClientWriteHandler());
        qs.setClientData(config.getClientData());
        qs.setClientExtendedEventHandler(config.getClientExtendedEventHandler());
        qs.setDefaultDataMode(config.getDefaultDataMode());
        qs.setServerBanner(config.getServerBanner());
        qs.setTimeout(config.getTimeout());
        qs.setMaxAuthTry(config.getMaxAuthTry());
        qs.setMaxAuthTryMsg(config.getMaxAuthTryMsg());
        qs.setTimeoutMsg(config.getTimeoutMsg());
        qs.setMaxConnection(config.getMaxConnection());
        qs.setMaxConnectionMsg(config.getMaxConnectionMsg());
        qs.setBindAddr(config.getBindAddr());
        qs.setCommunicationLogging(config.getCommunicationLogging());
        qs.setSecurityManagerClass(config.getSecurityManagerClass());
        qs.setAccessConstraintConfig(config.getAccessConstraintConfig());
        temp = config.getApplicationJarPath();
        if (temp != null) {
            File ajp = new File(temp);
            if (!ajp.isAbsolute()) {
                temp = config.getConfigFile();
                ajp = new File(temp);
                temp = ajp.getParent() + File.separatorChar + config.getApplicationJarPath();
                config.setApplicationJarPath(temp);
                temp = null;
            }
            qs.setApplicationJarPath(config.getApplicationJarPath());
            if (config.getQSAdminServerConfig() != null) {
                this.getQSAdminServer().getServer().setApplicationJarPath(config.getApplicationJarPath());
            }
        }
        qs.setServerHooks(config.getServerHooks());
        qs.setSecure(config.getSecure());
    }

    public void configQuickServer(QSAdminServerConfig config) throws Exception {
        QuickServer qs = this.getQSAdminServer().getServer();
        qs.setBasicConfig(config);
        String temp = this.getConsoleLoggingLevel();
        this.configConsoleLoggingLevel(qs, temp);
        qs.setConsoleLoggingFormatter(this.getConsoleLoggingFormatter());
        qs.setClientEventHandler(config.getClientEventHandler());
        qs.setClientCommandHandler(config.getClientCommandHandler());
        qs.setName(config.getName());
        qs.setPort(config.getPort());
        if (config.getAuthenticator() != null) {
            qs.setAuthenticator(config.getAuthenticator());
        } else if (config.getClientAuthenticationHandler() != null) {
            qs.setClientAuthenticationHandler(config.getClientAuthenticationHandler());
        }
        qs.setClientObjectHandler(config.getClientObjectHandler());
        qs.setClientBinaryHandler(config.getClientBinaryHandler());
        qs.setClientWriteHandler(config.getClientWriteHandler());
        qs.setClientData(config.getClientData());
        qs.setClientExtendedEventHandler(config.getClientExtendedEventHandler());
        qs.setDefaultDataMode(config.getDefaultDataMode());
        qs.setServerBanner(config.getServerBanner());
        qs.setTimeout(config.getTimeout());
        qs.setMaxAuthTry(config.getMaxAuthTry());
        qs.setMaxAuthTryMsg(config.getMaxAuthTryMsg());
        qs.setTimeoutMsg(config.getTimeoutMsg());
        qs.setMaxConnection(config.getMaxConnection());
        qs.setMaxConnectionMsg(config.getMaxConnectionMsg());
        qs.setBindAddr(config.getBindAddr());
        qs.setCommunicationLogging(config.getCommunicationLogging());
        this.getQSAdminServer().setCommandPlugin(config.getCommandPlugin());
        if (config.getCommandShellEnable().equals("true")) {
            this.getQSAdminServer().setShellEnable(true);
        }
        this.getQSAdminServer().setPromptName(config.getCommandShellPromptName());
        qs.setAccessConstraintConfig(config.getAccessConstraintConfig());
        qs.setServerHooks(config.getServerHooks());
        qs.setSecure(config.getSecure());
    }

    public void configQuickServer() throws Exception {
        this.configQuickServer(this.getConfig());
        if (this.getConfig().getQSAdminServerConfig() != null) {
            this.configQuickServer(this.getConfig().getQSAdminServerConfig());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length >= 1) {
                if (args[0].equals("-about")) {
                    About.main(null);
                } else if (args[0].equals("-load") && args.length >= 2) {
                    QuickServer qs = QuickServer.load(args[1]);
                    if (qs != null) {
                        QuickServer.handleOptions(args, qs);
                    }
                } else {
                    System.out.println(QuickServer.printUsage());
                }
            } else {
                System.out.println(QuickServer.printUsage());
                About.showAbout();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static QuickServer load(String xml) throws AppException {
        QuickServer qs = new QuickServer();
        Object[] config = new Object[]{xml};
        qs.initServer(config);
        qs.startServer();
        if (qs.getConfig().getQSAdminServerConfig() != null) {
            qs.startQSAdminServer();
        }
        return qs;
    }

    private static String printUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuickServer - Java library/framework for creating robust multi-client TCP servers.\n");
        sb.append("Copyright (C) QuickServer.org\n\n");
        sb.append("Usage: QuickServer [-options]\n");
        sb.append("Where options include:\n");
        sb.append("  -about\tOpens About Dialog box\n");
        sb.append("  -load <xml_config_file> [load-options]\tLoads the server from xml file.\n");
        sb.append("  Where load-options include:\n");
        sb.append("     -fullXML2File <file_name>\tDumps the Full XML configuration of the QuickServer loaded.\n");
        return sb.toString();
    }

    private static void handleOptions(String[] args, QuickServer quickserver) {
        if (args.length < 3) {
            return;
        }
        if (args[2].equals("-fullXML2File") && args.length >= 4) {
            File file = new File(args[3]);
            logger.log(Level.INFO, "Writing full xml configuration to file: {0}", file.getAbsolutePath());
            try {
                TextFile.write(file, quickserver.getConfig().toXML(null));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error writing full xml configuration: {0}", e);
            }
        }
    }

    public void clearAllPools() throws Exception {
        try {
            if (this.pool != null) {
                this.getClientPool().clear();
            }
            if (this.clientHandlerPool != null) {
                this.getClientHandlerPool().clear();
            }
            if (this.getClientDataPool() != null) {
                this.getClientDataPool().clear();
            }
            if (this.getDBPoolUtil() != null) {
                this.getDBPoolUtil().clean();
            }
            if (this.byteBufferPool != null) {
                this.getByteBufferPool().clear();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error: {0}", e);
            throw e;
        }
    }

    public void closeAllPools() throws Exception {
        if (this.pool == null && this.clientHandlerPool == null && this.getClientDataPool() == null && this.getDBPoolUtil() == null && this.byteBufferPool == null) {
            return;
        }
        logger.log(Level.FINE, "Closing pools for {0}", this.getName());
        try {
            if (this.pool != null && PoolHelper.isPoolOpen(this.getClientPool().getObjectPool())) {
                logger.finer("Closing ClientThread pool.");
                this.getClientPool().close();
            }
            if (this.clientHandlerPool != null && PoolHelper.isPoolOpen(this.getClientHandlerPool())) {
                logger.finer("Closing ClientHandler pool.");
                this.getClientHandlerPool().close();
            }
            if (this.getClientDataPool() != null && PoolHelper.isPoolOpen(this.getClientDataPool())) {
                logger.finer("Closing ClientData pool.");
                this.getClientDataPool().close();
            }
            if (this.getDBPoolUtil() != null) {
                logger.finer("Closing DB pool.");
                this.getDBPoolUtil().clean();
            }
            if (this.byteBufferPool != null && PoolHelper.isPoolOpen(this.getByteBufferPool())) {
                logger.finer("Closing ByteBuffer pool.");
                this.getByteBufferPool().close();
            }
            logger.log(Level.FINE, "Closed pools for {0}", this.getName());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error closing pools for {0}: {1}", new Object[]{this.getName(), e});
            throw e;
        }
    }

    public void initAllPools() throws Exception {
        logger.fine("Creating pools");
        if (!this.getBlockingMode()) {
            this.makeByteBufferPool(this.getBasicConfig().getObjectPoolConfig().getByteBufferObjectPoolConfig());
        }
        this.makeClientPool(this.getBasicConfig().getObjectPoolConfig().getThreadObjectPoolConfig());
        this.makeClientHandlerPool(this.getBasicConfig().getObjectPoolConfig().getClientHandlerObjectPoolConfig());
        if (this.clientDataClass != null) {
            try {
                this.clientData = (ClientData)this.clientDataClass.newInstance();
                if (PoolableObject.class.isInstance(this.clientData)) {
                    PoolableObject po = (PoolableObject)((Object)this.clientData);
                    if (po.isPoolable()) {
                        this.makeClientDataPool(po.getPoolableObjectFactory(), this.getBasicConfig().getObjectPoolConfig().getClientDataObjectPoolConfig());
                    } else {
                        this.clientDataPool = null;
                        logger.fine("ClientData is not poolable!");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error: {0}", e);
                throw e;
            }
        }
        try {
            this.makeDBObjectPool();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in makeDBObjectPool() : {0}", e);
            logger.log(Level.FINE, "StackTrace:\n{0}", MyString.getStackTrace(e));
            throw e;
        }
        logger.fine("Created pools");
    }

    public ClientPool getClientPool() {
        if (this.pool == null) {
            throw new IllegalStateException("No ClientPool available yet!");
        }
        return this.pool;
    }

    private void makeClientHandlerPool(PoolConfig opConfig) throws Exception {
        logger.finer("Creating ClientHandler pool");
        ClientHandlerObjectFactory factory = new ClientHandlerObjectFactory(this.getBlockingMode());
        this.clientHandlerPool = this.poolManager.makeClientHandlerPool((PoolableObjectFactory)factory, opConfig);
        this.poolManager.initPool(this.clientHandlerPool, opConfig);
        this.clientHandlerPool = this.makeQSObjectPool(this.clientHandlerPool);
        this.clientIdentifier.setClientHandlerPool((QSObjectPool)this.clientHandlerPool);
    }

    public ObjectPool getClientHandlerPool() {
        if (this.clientHandlerPool == null) {
            throw new IllegalStateException("No ClientHandler Pool available yet!");
        }
        return this.clientHandlerPool;
    }

    public void setConfig(QuickServerConfig config) {
        this.config = config;
    }

    public QuickServerConfig getConfig() {
        return this.config;
    }

    private void makeClientDataPool(PoolableObjectFactory factory, PoolConfig opConfig) throws Exception {
        logger.finer("Creating ClientData pool");
        this.clientDataPool = this.poolManager.makeClientDataPool(factory, opConfig);
        this.poolManager.initPool(this.clientDataPool, opConfig);
        this.clientDataPool = this.makeQSObjectPool(this.clientDataPool);
    }

    public ObjectPool getClientDataPool() {
        return this.clientDataPool;
    }

    public DBPoolUtil getDBPoolUtil() {
        return this.dBPoolUtil;
    }

    public void setDBObjectPoolConfig(DBObjectPoolConfig dBObjectPoolConfig) {
        this.getConfig().setDBObjectPoolConfig(dBObjectPoolConfig);
    }

    private void makeDBObjectPool() throws Exception {
        if (this.getConfig().getDBObjectPoolConfig() != null) {
            logger.fine("Creating DBObject Pool");
            Class dbPoolUtilClass = this.getClass(this.getConfig().getDBObjectPoolConfig().getDbPoolUtil(), true);
            this.dBPoolUtil = (DBPoolUtil)dbPoolUtilClass.newInstance();
            this.dBPoolUtil.setDatabaseConnections(this.getConfig().getDBObjectPoolConfig().getDatabaseConnectionSet().iterator());
            this.dBPoolUtil.initPool();
        }
    }

    public ClientHandler findFirstClientById(String id) {
        return this.clientIdentifier.findFirstClientById(id);
    }

    public Iterator findAllClient() {
        return this.clientIdentifier.findAllClient();
    }

    public Iterator findAllClientById(String pattern) {
        return this.clientIdentifier.findAllClientById(pattern);
    }

    public ClientHandler findClientByKey(String key) {
        return this.clientIdentifier.findClientByKey(key);
    }

    public Iterator findAllClientByKey(String pattern) {
        return this.clientIdentifier.findAllClientByKey(pattern);
    }

    public void nextClientIsTrusted() {
        this.setSkipValidation(true);
    }

    private synchronized boolean getSkipValidation() {
        return this.skipValidation;
    }

    private synchronized void setSkipValidation(boolean validation) {
        this.skipValidation = validation;
    }

    public void setCommunicationLogging(boolean communicationLogging) {
        this.communicationLogging = communicationLogging;
    }

    public boolean getCommunicationLogging() {
        return this.communicationLogging;
    }

    public void setSecurityManagerClass(String securityManagerClass) {
        if (securityManagerClass != null) {
            this.securityManagerClass = securityManagerClass;
        }
    }

    public String getSecurityManagerClass() {
        return this.securityManagerClass;
    }

    public SecurityManager getSecurityManager() throws AppException {
        if (this.getSecurityManagerClass() == null) {
            return null;
        }
        SecurityManager sm = null;
        try {
            sm = (SecurityManager)this.getClass(this.getSecurityManagerClass(), true).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AppException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new AppException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new AppException(e.getMessage());
        }
        return sm;
    }

    public void setAccessConstraintConfig(AccessConstraintConfig accessConstraintConfig) {
        this.accessConstraintConfig = accessConstraintConfig;
    }

    public AccessConstraintConfig getAccessConstraintConfig() {
        return this.accessConstraintConfig;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getClass(String name, boolean reload) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Class name can't be null!");
        }
        logger.log(Level.FINEST, "Class: {0}, reload: {1}", new Object[]{name, reload});
        if (reload && this.classLoader != null) {
            return this.classLoader.loadClass(name);
        }
        if (reload && this.classLoader == null && this.getClass().getClassLoader() != null) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        if (!reload && this.classLoader != null) {
            return Class.forName(name, true, this.classLoader);
        }
        return Class.forName(name, true, this.getClass().getClassLoader());
    }

    protected void setApplicationJarPath(String applicationJarPath) {
        this.applicationJarPath = applicationJarPath;
    }

    public String getApplicationJarPath() {
        return this.applicationJarPath;
    }

    public void setServerHooks(ServerHooks serverHooks) {
        this.serverHooks = serverHooks;
    }

    public ServerHooks getServerHooks() {
        if (this.serverHooks == null) {
            this.serverHooks = new ServerHooks();
        }
        return this.serverHooks;
    }

    private void loadServerHooksClasses() {
        if (this.getServerHooks() == null) {
            return;
        }
        this.listOfServerHooks = new ArrayList();
        ServerHook serverHook = null;
        String serverHookClassName2 = null;
        Class serverHookClass = null;
        serverHook = new GhostSocketReaper();
        serverHook.initHook(this);
        this.listOfServerHooks.add(serverHook);
        this.ghostSocketReaper = serverHook;
        for (String serverHookClassName2 : this.getServerHooks()) {
            try {
                serverHookClass = this.getClass(serverHookClassName2, true);
                serverHook = (ServerHook)serverHookClass.newInstance();
                serverHook.initHook(this);
                this.listOfServerHooks.add(serverHook);
                logger.log(Level.INFO, "Loaded server hook: {0}", serverHookClassName2);
                logger.log(Level.FINE, "Server hook info: {0}", serverHook.info());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not load server hook [{0}]: {1}", new Object[]{serverHookClassName2, e});
                logger.log(Level.FINE, "StackTrace:\n{0}", MyString.getStackTrace(e));
            }
        }
    }

    protected void processServerHooks(int event) {
        if (this.listOfServerHooks == null) {
            logger.warning("listOfServerHooks was null!");
            return;
        }
        ServerHook serverHook = null;
        boolean result = false;
        Iterator iterator = this.listOfServerHooks.iterator();
        String hooktype = "UNKNOWN";
        switch (event) {
            case 100: {
                hooktype = "PRE_STARTUP";
                break;
            }
            case 101: {
                hooktype = "POST_STARTUP";
                break;
            }
            case 201: {
                hooktype = "PRE_SHUTDOWN";
                break;
            }
            case 202: {
                hooktype = "POST_SHUTDOWN";
            }
        }
        while (iterator.hasNext()) {
            serverHook = (ServerHook)iterator.next();
            try {
                result = serverHook.handleEvent(event);
            }
            catch (Exception e) {
                result = false;
                logger.log(Level.WARNING, "Error invoking {0} hook [{1}]: {2}", new Object[]{hooktype, serverHook.getClass().getName(), e.getMessage()});
            }
            logger.log(Level.FINE, "Invoked {0} hook [{1}] was: {2}", new Object[]{hooktype, serverHook.getClass().getName(), result});
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
            QuickServer _qs = (QuickServer)object;
            _qs.setQSAdminServer(new QSAdminServer(_qs));
        }
        catch (CloneNotSupportedException e) {
            logger.log(Level.WARNING, "Error cloning : {0}", e);
        }
        return object;
    }

    public void setSecure(Secure secure) {
        this.secure = secure;
    }

    public Secure getSecure() {
        if (this.secure == null) {
            this.secure = new Secure();
        }
        return this.secure;
    }

    public boolean isRunningSecure() {
        return this.runningSecure;
    }

    public void setRunningSecure(boolean runningSecure) {
        this.runningSecure = runningSecure;
    }

    private File makeAbsoluteToConfig(String fileName) {
        Assertion.affirm(fileName != null, "FileName can't be null");
        return ConfigReader.makeAbsoluteToConfig(fileName, this.getConfig());
    }

    protected void makeServerSocket() throws BindException, IOException {
        this.server = null;
        logger.log(Level.FINEST, "Binding {0} to IP: {1}", new Object[]{this.getName(), this.getBindAddr()});
        InetSocketAddress bindAddress = new InetSocketAddress(this.getBindAddr(), this.getPort());
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(this.getBindAddr());
            if (ni != null) {
                logger.fine("NetworkInterface: " + ni);
            }
        }
        catch (Exception ni) {
        }
        catch (Error ni) {
            // empty catch block
        }
        if (!this.getSecure().isEnable()) {
            logger.log(Level.FINE, "Making a normal ServerSocket for {0}", this.getName());
            this.setRunningSecure(false);
            if (!this.getBlockingMode()) {
                this.serverSocketChannel = ServerSocketChannel.open();
                this.server = this.serverSocketChannel.socket();
                this.server.bind(bindAddress, this.getBasicConfig().getAdvancedSettings().getBacklog());
            } else {
                this.server = new ServerSocket(this.getPort(), this.getBasicConfig().getAdvancedSettings().getBacklog(), this.getBindAddr());
            }
        } else {
            try {
                logger.log(Level.FINE, "Making a secure ServerSocket for {0}", this.getName());
                this.getSSLContext();
                this.setRunningSecure(true);
                if (!this.getBlockingMode()) {
                    logger.log(Level.FINE, "Making a secure ServerSocketChannel for {0}", this.getName());
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.server = this.serverSocketChannel.socket();
                    this.server.bind(bindAddress, this.getBasicConfig().getAdvancedSettings().getBacklog());
                } else {
                    SSLServerSocketFactory ssf = this.getSSLContext().getServerSocketFactory();
                    SSLServerSocket serversocket = (SSLServerSocket)ssf.createServerSocket(this.getPort(), this.getBasicConfig().getAdvancedSettings().getBacklog(), this.getBindAddr());
                    serversocket.setNeedClientAuth(this.secure.isClientAuthEnable());
                    this.setRunningSecure(true);
                    this.secureStoreManager.logSSLServerSocketInfo(serversocket);
                    this.server = serversocket;
                    this.serverSocketChannel = this.server.getChannel();
                    if (this.serverSocketChannel == null && !this.getBlockingMode()) {
                        logger.warning("Secure Server does not support Channel! So will run in blocking mode.");
                        this.blockingMode = false;
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.WARNING, "NoSuchAlgorithmException : {0}", e);
                throw new IOException("Error creating secure socket : " + e.getMessage());
            }
            catch (KeyManagementException e) {
                logger.log(Level.WARNING, "KeyManagementException : {0}", e);
                throw new IOException("Error creating secure socket : " + e.getMessage());
            }
        }
        this.server.setReuseAddress(true);
        int connectionTime = 0;
        int latency = 0;
        int bandwidth = 0;
        connectionTime = this.getBasicConfig().getAdvancedSettings().getPerformancePreferencesConnectionTime();
        latency = this.getBasicConfig().getAdvancedSettings().getPerformancePreferencesLatency();
        bandwidth = this.getBasicConfig().getAdvancedSettings().getPerformancePreferencesBandwidth();
        logger.log(Level.FINE, "getPerformancePreferencesConnectionTime : {0}", connectionTime);
        logger.log(Level.FINE, "getPerformancePreferencesLatency : {0}", latency);
        logger.log(Level.FINE, "getPerformancePreferencesBandwidth : {0}", bandwidth);
        this.server.setPerformancePreferences(connectionTime, latency, bandwidth);
        int clientSocketReceiveBufferSize = this.getBasicConfig().getAdvancedSettings().getClientSocketReceiveBufferSize();
        if (clientSocketReceiveBufferSize > 0) {
            logger.log(Level.FINE, "clientSocketReceiveBufferSize: {0}", clientSocketReceiveBufferSize);
            this.server.setReceiveBufferSize(clientSocketReceiveBufferSize);
        }
        if (!this.getBlockingMode()) {
            logger.log(Level.FINE, "Server Mode {0} - Non Blocking", this.getName());
            if (this.selector == null || !this.selector.isOpen()) {
                logger.finest("Opening new selector");
                this.selector = Selector.open();
            } else {
                logger.log(Level.FINEST, "Reusing selector: {0}", this.selector);
            }
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.register(this.selector, 16);
            this.selector.wakeup();
        } else {
            logger.log(Level.FINE, "Server Mode {0} - Blocking", this.getName());
        }
    }

    public void setBasicConfig(BasicServerConfig basicConfig) throws Exception {
        Assertion.affirm(basicConfig != null, "BasicServerConfig can't be null");
        this.basicConfig = basicConfig;
    }

    public BasicServerConfig getBasicConfig() {
        return this.basicConfig;
    }

    public void loadSSLContext() throws IOException {
        if (!this.getSecure().isLoad()) {
            throw new IllegalStateException("Secure setting is not yet enabled for loading!");
        }
        logger.info("Loading Secure Context..");
        this.km = null;
        this.tm = null;
        try {
            String ssManager = "org.quickserver.security.SecureStoreManager";
            if (this.getSecure().getSecureStore() != null) {
                ssManager = this.getSecure().getSecureStore().getSecureStoreManager();
            }
            Class secureStoreManagerClass = this.getClass(ssManager, true);
            this.secureStoreManager = (SecureStoreManager)secureStoreManagerClass.newInstance();
            this.km = this.secureStoreManager.loadKeyManagers(this.getConfig());
            logger.fine("KeyManager got");
            this.tm = this.secureStoreManager.loadTrustManagers(this.getConfig());
            logger.fine("TrustManager got");
            this.sslc = this.secureStoreManager.getSSLContext(this.getConfig());
            this.sslc.init(this.km, this.tm, null);
            logger.fine("SSLContext loaded " + this.sslc.getProvider());
        }
        catch (KeyStoreException e) {
            logger.warning("KeyStoreException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("NoSuchAlgorithmException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            logger.warning("NoSuchProviderException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            logger.warning("UnrecoverableKeyException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (CertificateException e) {
            logger.warning("CertificateException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (KeyManagementException e) {
            logger.warning("KeyManagementException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            logger.warning("GeneralSecurityException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            logger.warning("ClassNotFoundException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (InstantiationException e) {
            logger.warning("InstantiationException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.warning("IllegalAccessException : " + e);
            throw new IOException("Error creating secure socket : " + e.getMessage());
        }
    }

    public SSLContext getSSLContext() throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return this.getSSLContext(null);
    }

    public SSLContext getSSLContext(String protocol) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (this.sslc == null) {
            this.loadSSLContext();
        }
        return this.sslc;
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (this.sslc == null) {
            this.loadSSLContext();
        }
        return this.secureStoreManager.getSocketFactory(this.getSSLContext());
    }

    public SSLSocketFactory getSSLSocketFactory(String protocol) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (this.sslc == null) {
            this.loadSSLContext();
        }
        return this.secureStoreManager.getSocketFactory(this.getSSLContext(protocol));
    }

    public void setClientBinaryHandler(String handler) {
        this.clientBinaryHandlerString = handler;
        logger.finest("Set to " + handler);
    }

    public String getClientBinaryHandler() {
        return this.clientBinaryHandlerString;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Selector getSelector() {
        return this.selector;
    }

    private void runBlocking(TheClient theClient) throws Exception {
        Socket client = null;
        ClientHandler _chPolled = null;
        int linger = this.getBasicConfig().getAdvancedSettings().getSocketLinger();
        int socketTrafficClass = 0;
        if (this.getBasicConfig().getAdvancedSettings().getClientSocketTrafficClass() != null) {
            socketTrafficClass = Integer.parseInt(this.getBasicConfig().getAdvancedSettings().getClientSocketTrafficClass());
        }
        while (true) {
            client = this.server.accept();
            if (linger < 0) {
                client.setSoLinger(false, 0);
            } else {
                client.setSoLinger(true, linger);
            }
            client.setTcpNoDelay(this.getBasicConfig().getAdvancedSettings().getClientSocketTcpNoDelay());
            if (this.getBasicConfig().getAdvancedSettings().getClientSocketTrafficClass() != null) {
                client.setTrafficClass(socketTrafficClass);
            }
            if (this.getBasicConfig().getAdvancedSettings().getClientSocketSendBufferSize() != 0) {
                client.setSendBufferSize(this.getBasicConfig().getAdvancedSettings().getClientSocketSendBufferSize());
            }
            if (this.stopServer) {
                try {
                    client.close();
                }
                catch (Exception exception) {}
                break;
            }
            if (!this.checkAccessConstraint(client)) continue;
            if (!this.getSkipValidation() && this.maxConnection != -1L && (long)this.getClientHandlerPool().getNumActive() >= this.maxConnection) {
                theClient.setClientEvent(ClientEvent.MAX_CON_BLOCKING);
            } else {
                theClient.setClientEvent(ClientEvent.RUN_BLOCKING);
            }
            theClient.setTrusted(this.getSkipValidation());
            theClient.setSocket(client);
            theClient.setSocketChannel(client.getChannel());
            if (this.clientDataClass != null) {
                this.clientData = this.getClientDataPool() == null ? (ClientData)this.clientDataClass.newInstance() : (ClientData)this.getClientDataPool().borrowObject();
                theClient.setClientData(this.clientData);
            }
            try {
                _chPolled = (ClientHandler)this.getClientHandlerPool().borrowObject();
                _chPolled.handleClient(theClient);
            }
            catch (NoSuchElementException nsee) {
                logger.warning("Could not borrow ClientHandler from pool. Error: " + nsee);
                logger.warning("Closing Socket [" + client + "] since no ClientHandler available.");
                client.close();
            }
            if (_chPolled != null) {
                try {
                    this.getClientPool().addClient(_chPolled, true);
                }
                catch (NoSuchElementException nsee) {
                    logger.warning("Could not borrow Thread from pool. Error: " + nsee);
                }
                _chPolled = null;
            }
            client = null;
            this.setSkipValidation(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNonBlocking(TheClient theClient) throws Exception {
        int selectCount = 0;
        Iterator<Object> iterator = null;
        SelectionKey key = null;
        ServerSocketChannel serverChannel = null;
        SocketChannel socketChannel = null;
        Socket client = null;
        ClientHandler _chPolled = null;
        boolean stopServerProcessed = false;
        int linger = this.getBasicConfig().getAdvancedSettings().getSocketLinger();
        this.registerChannelRequestMap = new HashMap();
        int socketTrafficClass = 0;
        if (this.getBasicConfig().getAdvancedSettings().getClientSocketTrafficClass() != null) {
            socketTrafficClass = Integer.parseInt(this.getBasicConfig().getAdvancedSettings().getClientSocketTrafficClass());
        }
        while (true) {
            selectCount = this.selector.select(500L);
            Map map = this.registerChannelRequestMap;
            synchronized (map) {
                if (this.registerChannelRequestMap.size() > 0) {
                    RegisterChannelRequest req = null;
                    Object hashkey2 = null;
                    for (Object hashkey2 : this.registerChannelRequestMap.keySet()) {
                        req = (RegisterChannelRequest)this.registerChannelRequestMap.get(hashkey2);
                        req.register(this.getSelector());
                    }
                    iterator = null;
                    this.registerChannelRequestMap.clear();
                }
            }
            if (this.stopServer && !stopServerProcessed) {
                logger.warning("Closing " + this.getName());
                this.serverSocketChannel.close();
                stopServerProcessed = true;
                this.server = null;
                this.serverSocketChannel = null;
                this.setServiceState(0);
                logger.warning("Closed " + this.getName());
                this.processServerHooks(202);
            }
            if (!this.stopServer && stopServerProcessed) {
                logger.finest("Server must have re-started.. will break");
                break;
            }
            if (selectCount == 0 && stopServerProcessed) {
                Set<SelectionKey> keyset = this.selector.keys();
                if (!keyset.isEmpty() || this.getClientCount() > 0L) continue;
                break;
            }
            if (selectCount == 0) continue;
            iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                ClientHandler _ch;
                key = (SelectionKey)iterator.next();
                if (!key.isValid()) {
                    iterator.remove();
                    continue;
                }
                if (key.isAcceptable() && !this.stopServer) {
                    logger.finest("Key is Acceptable");
                    serverChannel = (ServerSocketChannel)key.channel();
                    socketChannel = serverChannel.accept();
                    if (socketChannel == null) {
                        iterator.remove();
                        continue;
                    }
                    client = socketChannel.socket();
                    if (linger < 0) {
                        client.setSoLinger(false, 0);
                    } else {
                        client.setSoLinger(true, linger);
                    }
                    client.setTcpNoDelay(this.getBasicConfig().getAdvancedSettings().getClientSocketTcpNoDelay());
                    if (this.getBasicConfig().getAdvancedSettings().getClientSocketTrafficClass() != null) {
                        client.setTrafficClass(socketTrafficClass);
                    }
                    if (this.getBasicConfig().getAdvancedSettings().getClientSocketSendBufferSize() != 0) {
                        client.setSendBufferSize(this.getBasicConfig().getAdvancedSettings().getClientSocketSendBufferSize());
                    }
                    if (!this.checkAccessConstraint(client)) {
                        iterator.remove();
                        continue;
                    }
                    socketChannel.configureBlocking(false);
                    theClient.setTrusted(this.getSkipValidation());
                    theClient.setSocket(socketChannel.socket());
                    theClient.setSocketChannel(socketChannel);
                    if (this.clientDataClass != null) {
                        this.clientData = this.getClientDataPool() == null ? (ClientData)this.clientDataClass.newInstance() : (ClientData)this.getClientDataPool().borrowObject();
                        theClient.setClientData(this.clientData);
                    }
                    if (!this.getSkipValidation() && this.maxConnection != -1L && (long)this.getClientHandlerPool().getNumActive() >= this.maxConnection) {
                        theClient.setClientEvent(ClientEvent.MAX_CON);
                    } else {
                        theClient.setClientEvent(ClientEvent.ACCEPT);
                    }
                    try {
                        _chPolled = (ClientHandler)this.getClientHandlerPool().borrowObject();
                        logger.finest("Asking " + _chPolled.getName() + " to handle.");
                        _chPolled.handleClient(theClient);
                    }
                    catch (NoSuchElementException nsee) {
                        logger.warning("Could not borrow ClientHandler Object from pool. Error: " + nsee);
                        logger.warning("Closing SocketChannel [" + serverChannel.socket() + "] since no ClientHandler available.");
                        socketChannel.close();
                    }
                    if (_chPolled != null) {
                        try {
                            this.getClientPool().addClient(_chPolled, true);
                        }
                        catch (NoSuchElementException nsee) {
                            logger.warning("Could not borrow Thread from pool. Error: " + nsee);
                        }
                        _chPolled = null;
                    }
                    socketChannel = null;
                    client = null;
                    this.setSkipValidation(false);
                } else if (key.isValid() && key.isReadable()) {
                    boolean addedEvent = false;
                    _ch = null;
                    try {
                        _ch = (ClientHandler)key.attachment();
                        logger.finest("Key is Readable, removing OP_READ from interestOps for " + _ch.getName());
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        _ch.addEvent(ClientEvent.READ);
                        addedEvent = true;
                        this.getClientPool().addClient(_ch);
                    }
                    catch (CancelledKeyException cke) {
                        logger.fine("Ignored Error - Key was Cancelled: " + cke);
                    }
                    catch (NoSuchElementException nsee) {
                        logger.finest("NoSuchElementException: " + nsee);
                        if (!addedEvent) continue;
                        _ch.removeEvent(ClientEvent.READ);
                        continue;
                    }
                    _ch = null;
                } else if (key.isValid() && key.isWritable()) {
                    if (!this.getClientPool().shouldNioWriteHappen()) continue;
                    boolean addedEvent = false;
                    _ch = null;
                    try {
                        _ch = (ClientHandler)key.attachment();
                        logger.finest("Key is Writable, removing OP_WRITE from interestOps for " + _ch.getName());
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                        _ch.addEvent(ClientEvent.WRITE);
                        addedEvent = true;
                        this.getClientPool().addClient(_ch);
                    }
                    catch (CancelledKeyException cke) {
                        logger.fine("Ignored Error - Key was Cancelled: " + cke);
                    }
                    catch (NoSuchElementException nsee) {
                        logger.finest("NoSuchElementException: " + nsee);
                        if (!addedEvent) continue;
                        _ch.removeEvent(ClientEvent.WRITE);
                        continue;
                    }
                    _ch = null;
                } else if (this.stopServer && key.isAcceptable()) {
                    this.setSkipValidation(false);
                } else {
                    logger.warning("Unknown key got in SelectionKey: " + key);
                }
                iterator.remove();
                Thread.yield();
            }
            iterator = null;
        }
    }

    private boolean checkAccessConstraint(Socket socket) {
        try {
            if (this.getAccessConstraintConfig() != null) {
                this.getAccessConstraintConfig().checkAccept(socket);
            }
            return true;
        }
        catch (SecurityException se) {
            logger.warning("SecurityException occurred accepting connection : " + se.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerChannel(SocketChannel channel, int ops, Object att) throws IOException, ClosedChannelException {
        if (this.getSelector() == null) {
            throw new IllegalStateException("Selector is not open!");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Can't register a null channel!");
        }
        if (!channel.isConnected()) {
            throw new ClosedChannelException();
        }
        RegisterChannelRequest req = new RegisterChannelRequest(channel, ops, att);
        RegisterChannelRequest reqOld = null;
        Map map = this.registerChannelRequestMap;
        synchronized (map) {
            reqOld = (RegisterChannelRequest)this.registerChannelRequestMap.get(channel);
            if (reqOld == null) {
                this.registerChannelRequestMap.put(channel, req);
                this.getSelector().wakeup();
                return true;
            }
            if (!reqOld.equals(req)) {
                reqOld.setOps(reqOld.getOps() | req.getOps());
                reqOld.setAtt(req.getAtt());
                return true;
            }
            return false;
        }
    }

    private void makeByteBufferPool(PoolConfig opConfig) {
        logger.finer("Creating ByteBufferPool pool");
        int bufferSize = this.getBasicConfig().getAdvancedSettings().getByteBufferSize();
        boolean useDirectByteBuffer = this.getBasicConfig().getAdvancedSettings().getUseDirectByteBuffer();
        ByteBufferObjectFactory factory = new ByteBufferObjectFactory(bufferSize, useDirectByteBuffer);
        this.byteBufferPool = this.poolManager.makeByteBufferPool((PoolableObjectFactory)factory, opConfig);
        this.poolManager.initPool(this.byteBufferPool, opConfig);
    }

    public ObjectPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    private void makeClientPool(PoolConfig opConfig) throws Exception {
        logger.finer("Creating ClientThread pool");
        ThreadObjectFactory factory = new ThreadObjectFactory();
        ObjectPool objectPool = this.poolManager.makeClientPool((PoolableObjectFactory)factory, opConfig);
        this.pool = new ClientPool(this.makeQSObjectPool(objectPool), opConfig);
        factory.setClientPool(this.pool);
        this.pool.setMaxThreadsForNioWrite(this.getBasicConfig().getAdvancedSettings().getMaxThreadsForNioWrite());
        this.poolManager.initPool(objectPool, opConfig);
    }

    public void setClientWriteHandler(String handler) {
        this.clientWriteHandlerString = handler;
        logger.log(Level.FINEST, "Set to {0}", handler);
    }

    public String getClientWriteHandler() {
        return this.clientWriteHandlerString;
    }

    public Date getLastStartTime() {
        return this.lastStartTime;
    }

    public static void setDebugNonBlockingMode(boolean flag) {
        ByteBufferOutputStream.setDebug(flag);
        ByteBufferInputStream.setDebug(flag);
    }

    public ClientIdentifier getClientIdentifier() {
        return this.clientIdentifier;
    }

    private QSObjectPool makeQSObjectPool(ObjectPool objectPool) throws Exception {
        return this.qsObjectPoolMaker.getQSObjectPool(objectPool);
    }

    public boolean getBlockingMode() {
        return this.blockingMode;
    }

    protected void loadBusinessLogic() throws Exception {
        if (this.clientCommandHandlerString == null && this.clientEventHandlerString == null) {
            logger.severe("ClientCommandHandler AND ClientEventHandler was not set.");
            throw new AppException("ClientCommandHandler AND ClientEventHandler was not set.");
        }
        this.clientCommandHandler = null;
        if (this.clientCommandHandlerString != null) {
            logger.finest("Loading ClientCommandHandler class..");
            Class clientCommandHandlerClass = this.getClass(this.clientCommandHandlerString, true);
            this.clientCommandHandler = (ClientCommandHandler)clientCommandHandlerClass.newInstance();
        }
        boolean setClientCommandHandlerLookup = false;
        this.clientEventHandler = null;
        if (this.clientEventHandlerString == null) {
            this.clientEventHandlerString = "org.quickserver.net.server.impl.DefaultClientEventHandler";
            setClientCommandHandlerLookup = true;
        }
        logger.finest("Loading ClientEventHandler class..");
        if (this.clientEventHandlerString.equals(this.clientCommandHandlerString) && ClientEventHandler.class.isInstance(this.clientCommandHandler)) {
            this.clientEventHandler = (ClientEventHandler)((Object)this.clientCommandHandler);
        } else {
            this.clientEventHandler = (ClientEventHandler)this.getClass(this.clientEventHandlerString, true).newInstance();
            if (setClientCommandHandlerLookup) {
                ((DefaultClientEventHandler)this.clientEventHandler).setClientCommandHandler(this.clientCommandHandler);
            }
        }
        this.clientExtendedEventHandler = null;
        if (this.clientExtendedEventHandlerString != null) {
            logger.finest("Loading ClientExtendedEventHandler class..");
            if (this.clientExtendedEventHandlerString.equals(this.clientCommandHandlerString) && ClientExtendedEventHandler.class.isInstance(this.clientCommandHandler)) {
                this.clientExtendedEventHandler = (ClientExtendedEventHandler)((Object)this.clientCommandHandler);
            } else if (this.clientExtendedEventHandlerString.equals(this.clientEventHandlerString) && ClientExtendedEventHandler.class.isInstance(this.clientEventHandler)) {
                this.clientExtendedEventHandler = (ClientExtendedEventHandler)((Object)this.clientEventHandler);
            } else {
                Class clientExtendedEventHandlerClass = this.getClass(this.clientExtendedEventHandlerString, true);
                this.clientExtendedEventHandler = (ClientExtendedEventHandler)clientExtendedEventHandlerClass.newInstance();
            }
        }
        this.clientObjectHandler = null;
        if (this.clientObjectHandlerString != null) {
            logger.finest("Loading ClientObjectHandler class..");
            this.clientObjectHandler = this.clientObjectHandlerString.equals(this.clientCommandHandlerString) && ClientObjectHandler.class.isInstance(this.clientCommandHandler) ? (ClientObjectHandler)((Object)this.clientCommandHandler) : (this.clientObjectHandlerString.equals(this.clientEventHandlerString) && ClientObjectHandler.class.isInstance(this.clientEventHandler) ? (ClientObjectHandler)((Object)this.clientEventHandler) : (this.clientObjectHandlerString.equals(this.clientExtendedEventHandlerString) && ClientObjectHandler.class.isInstance(this.clientExtendedEventHandler) ? (ClientObjectHandler)((Object)this.clientExtendedEventHandler) : (ClientObjectHandler)this.getClass(this.clientObjectHandlerString, true).newInstance()));
        }
        this.clientBinaryHandler = null;
        if (this.clientBinaryHandlerString != null) {
            logger.finest("Loading ClientBinaryHandler class..");
            this.clientBinaryHandler = this.clientBinaryHandlerString.equals(this.clientCommandHandlerString) && ClientBinaryHandler.class.isInstance(this.clientCommandHandler) ? (ClientBinaryHandler)((Object)this.clientCommandHandler) : (this.clientBinaryHandlerString.equals(this.clientEventHandlerString) && ClientBinaryHandler.class.isInstance(this.clientEventHandler) ? (ClientBinaryHandler)((Object)this.clientEventHandler) : (this.clientBinaryHandlerString.equals(this.clientExtendedEventHandlerString) && ClientBinaryHandler.class.isInstance(this.clientExtendedEventHandler) ? (ClientBinaryHandler)((Object)this.clientExtendedEventHandler) : (this.clientBinaryHandlerString.equals(this.clientObjectHandlerString) && ClientBinaryHandler.class.isInstance(this.clientObjectHandler) ? (ClientBinaryHandler)((Object)this.clientObjectHandler) : (ClientBinaryHandler)this.getClass(this.clientBinaryHandlerString, true).newInstance())));
        }
        this.clientWriteHandler = null;
        if (this.clientWriteHandlerString != null) {
            logger.finest("Loading ClientWriteHandler class..");
            this.clientWriteHandler = this.clientWriteHandlerString.equals(this.clientCommandHandlerString) && ClientWriteHandler.class.isInstance(this.clientCommandHandler) ? (ClientWriteHandler)((Object)this.clientCommandHandler) : (this.clientWriteHandlerString.equals(this.clientEventHandlerString) && ClientWriteHandler.class.isInstance(this.clientEventHandler) ? (ClientWriteHandler)((Object)this.clientEventHandler) : (this.clientWriteHandlerString.equals(this.clientExtendedEventHandlerString) && ClientWriteHandler.class.isInstance(this.clientExtendedEventHandler) ? (ClientWriteHandler)((Object)this.clientExtendedEventHandler) : (this.clientWriteHandlerString.equals(this.clientObjectHandlerString) && ClientWriteHandler.class.isInstance(this.clientObjectHandler) ? (ClientWriteHandler)((Object)this.clientObjectHandler) : (this.clientWriteHandlerString.equals(this.clientBinaryHandlerString) && ClientWriteHandler.class.isInstance(this.clientBinaryHandler) ? (ClientWriteHandler)((Object)this.clientBinaryHandler) : (ClientWriteHandler)this.getClass(this.clientWriteHandlerString, true).newInstance()))));
        }
        Class authenticatorClass = null;
        if (this.clientAuthenticationHandlerString != null) {
            logger.finest("Loading ClientAuthenticationHandler class..");
            authenticatorClass = this.getClass(this.clientAuthenticationHandlerString, true);
        }
        if (authenticatorClass != null) {
            Object obj = authenticatorClass.newInstance();
            if (ClientAuthenticationHandler.class.isInstance(obj)) {
                this.clientAuthenticationHandler = (ClientAuthenticationHandler)obj;
            } else {
                this.authenticator = (Authenticator)obj;
            }
        }
        this.clientDataClass = null;
        if (this.clientDataString != null) {
            logger.finest("Loading ClientData class..");
            this.clientDataClass = this.getClass(this.clientDataString, true);
        }
        Assertion.affirm(this.clientEventHandler != null, "ClientEventHandler was not loaded!");
    }

    public void setClientEventHandler(String handler) {
        this.clientEventHandlerString = handler;
        logger.finest("Set to " + handler);
    }

    public String getClientEventHandler() {
        return this.clientEventHandlerString;
    }

    public void setDefaultDataMode(DataMode dataMode, DataType dataType) throws IOException {
        if (dataType == DataType.IN) {
            this.defaultDataModeIN = dataMode;
        }
        if (dataType == DataType.OUT) {
            this.defaultDataModeOUT = dataMode;
        }
    }

    public void setDefaultDataMode(DefaultDataMode defaultDataMode) throws IOException {
        this.defaultDataModeIN = defaultDataMode.getDataMode(DataType.IN);
        this.defaultDataModeOUT = defaultDataMode.getDataMode(DataType.OUT);
    }

    public DataMode getDefaultDataMode(DataType dataType) {
        if (dataType == DataType.IN) {
            return this.defaultDataModeIN;
        }
        if (dataType == DataType.OUT) {
            return this.defaultDataModeOUT;
        }
        throw new IllegalArgumentException("Unknown DataType: " + dataType);
    }

    public void setClientExtendedEventHandler(String handler) {
        this.clientExtendedEventHandlerString = handler;
        logger.finest("Set to " + handler);
    }

    public String getClientExtendedEventHandler() {
        return this.clientExtendedEventHandlerString;
    }

    private void loadApplicationClasses() throws Exception {
        if (this.getApplicationJarPath() != null && this.getClassLoader() == null) {
            this.setClassLoader(ClassUtil.getClassLoader(this.getApplicationJarPath()));
            if (this.adminServer != null) {
                this.adminServer.getServer().setClassLoader(this.getClassLoader());
            }
        }
    }

    public static String getPID() {
        return pid;
    }

    public boolean isRawCommunicationLogging() {
        return this.rawCommunicationLogging;
    }

    public void setRawCommunicationLogging(boolean rawCommunicationLogging) {
        this.rawCommunicationLogging = rawCommunicationLogging;
    }

    public int getRawCommunicationMaxLength() {
        return this.rawCommunicationMaxLength;
    }

    public void setRawCommunicationMaxLength(int rawCommunicationMaxLength) {
        this.rawCommunicationMaxLength = rawCommunicationMaxLength;
    }

    public String getUptime() {
        Date lst = this.getLastStartTime();
        return JvmUtil.getUptime(lst);
    }

    static {
        String _pid = ManagementFactory.getRuntimeMXBean().getName();
        int i = _pid.indexOf("@");
        pid = _pid.substring(0, i);
        System.out.print("Loading QuickServer v" + QuickServer.getVersion() + " [PID:" + pid + "]");
        System.out.print(".");
        logger = Logger.getLogger(QuickServer.class.getName());
        System.out.print(".");
        System.out.print(".");
        System.out.println(" Done");
        logger.log(Level.FINE, "PID: {0}", pid);
    }
}

