/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server;

import java.io.IOException;
import org.quickserver.net.AppException;
import org.quickserver.net.ConnectionLostException;
import org.quickserver.net.server.Authenticator;
import org.quickserver.net.server.ClientEvent;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.DataMode;
import org.quickserver.net.server.DataType;
import org.quickserver.util.io.ByteBufferInputStream;

public abstract class QuickAuthenticator
implements Authenticator {
    public abstract boolean askAuthorisation(ClientHandler var1) throws IOException, AppException;

    public void sendString(ClientHandler clientHandler, String msg) throws IOException {
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.STRING) {
                clientHandler.setDataMode(DataMode.STRING, DataType.OUT);
            }
            clientHandler.sendClientMsg(msg);
        }
    }

    public String askStringInput(ClientHandler clientHandler, String msg) throws IOException {
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.STRING) {
                clientHandler.setDataMode(DataMode.STRING, DataType.OUT);
            }
            clientHandler.sendClientMsg(msg);
        }
        if (clientHandler.getDataMode(DataType.IN) != DataMode.STRING) {
            clientHandler.setDataMode(DataMode.STRING, DataType.IN);
        }
        String data = null;
        if (clientHandler.hasEvent(ClientEvent.RUN_BLOCKING)) {
            data = clientHandler.getBufferedReader().readLine();
        } else {
            ByteBufferInputStream bbin = (ByteBufferInputStream)clientHandler.getInputStream();
            data = bbin.readLine();
        }
        if (data != null) {
            return data;
        }
        throw new ConnectionLostException();
    }

    public void sendObject(ClientHandler clientHandler, Object msg) throws IOException {
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.OBJECT) {
                clientHandler.setDataMode(DataMode.OBJECT, DataType.OUT);
            }
            clientHandler.sendClientObject(msg);
        }
    }

    public Object askObjectInput(ClientHandler clientHandler, Object msg) throws IOException, ClassNotFoundException {
        Object data;
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.OBJECT) {
                clientHandler.setDataMode(DataMode.OBJECT, DataType.OUT);
            }
            clientHandler.sendClientObject(msg);
        }
        if (clientHandler.getDataMode(DataType.IN) != DataMode.OBJECT) {
            clientHandler.setDataMode(DataMode.OBJECT, DataType.IN);
        }
        if ((data = clientHandler.getObjectInputStream().readObject()) != null) {
            return data;
        }
        throw new ConnectionLostException();
    }

    public void sendByte(ClientHandler clientHandler, String msg) throws IOException {
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.BYTE) {
                clientHandler.setDataMode(DataMode.BYTE, DataType.OUT);
            }
            clientHandler.sendClientBytes(msg);
        }
    }

    public String askByteInput(ClientHandler clientHandler, String msg) throws IOException {
        String data;
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.BYTE) {
                clientHandler.setDataMode(DataMode.BYTE, DataType.OUT);
            }
            clientHandler.sendClientBytes(msg);
        }
        if (clientHandler.getDataMode(DataType.IN) != DataMode.BYTE) {
            clientHandler.setDataMode(DataMode.BYTE, DataType.IN);
        }
        if ((data = clientHandler.readBytes()) != null) {
            return data;
        }
        throw new ConnectionLostException();
    }

    public void sendBinary(ClientHandler clientHandler, byte[] msg) throws IOException {
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.BINARY) {
                clientHandler.setDataMode(DataMode.BINARY, DataType.OUT);
            }
            clientHandler.sendClientBinary(msg);
        }
    }

    public byte[] askBinaryInput(ClientHandler clientHandler, byte[] msg) throws IOException {
        byte[] data;
        if (msg != null) {
            if (clientHandler.getDataMode(DataType.OUT) != DataMode.BINARY) {
                clientHandler.setDataMode(DataMode.BINARY, DataType.OUT);
            }
            clientHandler.sendClientBinary(msg);
        }
        if (clientHandler.getDataMode(DataType.IN) != DataMode.BINARY) {
            clientHandler.setDataMode(DataMode.BINARY, DataType.IN);
        }
        if ((data = clientHandler.readBinary()) != null) {
            return data;
        }
        throw new ConnectionLostException();
    }
}

