/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.qsadmin;

import java.awt.Robot;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Date;
import java.util.logging.Logger;
import org.quickserver.net.server.QuickServer;
import org.quickserver.util.MyString;

public class QSAdminShell
extends Thread {
    private static Logger logger = Logger.getLogger(QSAdminShell.class.getName());
    private String promptName = "QSAdmin";
    private String promptPostFix = ":> ";
    private String prompt = this.promptName + this.promptPostFix;
    private String error = "Error: ";
    private BufferedReader in;
    private String command = "";
    private Socket clientSocket = null;
    private QuickServer server;
    private InputStream s_in;
    private OutputStream s_out;
    private BufferedReader s_br;
    private BufferedOutputStream s_bo;
    private boolean gotResponse;
    private boolean multilineResponse;
    private boolean stop = false;
    private static QSAdminShell qsAdminShell;
    private static long oldMaxClient;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QSAdminShell getInstance(QuickServer server, String promptName) {
        if (qsAdminShell == null) {
            if (server == null) return null;
            qsAdminShell = new QSAdminShell(server, promptName);
            qsAdminShell.start();
            return qsAdminShell;
        } else {
            if (server != null) {
                QSAdminShell.qsAdminShell.server = server;
            }
            if (promptName != null) {
                QSAdminShell.qsAdminShell.promptName = promptName;
            }
            QSAdminShell.qsAdminShell.stop = false;
        }
        return qsAdminShell;
    }

    private QSAdminShell(QuickServer server, String promptName) {
        super("GUIAdminShell");
        this.setDaemon(true);
        this.server = server;
        if (promptName != null) {
            this.setPromptName(promptName);
        }
        boolean isConsole = true;
        try {
            if (System.console() == null) {
                isConsole = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isConsole) {
            try {
                this.in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.warning("UTF-8 was not supported: " + e);
                this.in = new BufferedReader(new InputStreamReader(System.in));
            }
            logger.fine("Starting QSAdmin Shell");
        } else {
            System.out.println("QuickServer: System does not have console so not starting QSAdmin Shell!");
        }
    }

    public void setPromptName(String name) {
        if (name == null) {
            return;
        }
        this.promptName = name;
        this.prompt = this.promptName + this.promptPostFix;
    }

    public String getPromptName() {
        return this.promptName;
    }

    public void stopShell() throws IOException {
        this.stop = true;
        this.clientSocket.close();
    }

    public void run() {
        if (this.in == null) {
            logger.warning("We do not have System.in.. So stopping QSAdminShell.");
            return;
        }
        try {
            for (int i = 0; i < 3; ++i) {
                QSAdminShell.sleep(500L);
                if (!this.server.getQSAdminServer().getServer().isClosed()) {
                    this.connect();
                    break;
                }
                if (i != 3) continue;
                logger.warning(this.error + "QSAdminServer is not running!! So stopping QSAdminShell.");
                return;
            }
        }
        catch (Exception e) {
            logger.fine(this.error + e.getMessage());
        }
        while (!this.stop) {
            try {
                this.print(this.prompt);
                this.command = this.in.readLine();
                if (this.stop) {
                    if (this.command.trim().equals("")) break;
                    System.out.println("Command ignored since shell was closed.");
                    break;
                }
                if (this.command == null) {
                    System.out.println("");
                    logger.severe("User must have forced an exit at shell!");
                    continue;
                }
                if (this.command.equals("FullThreadDump")) {
                    QSAdminShell.tryFullThreadDump();
                    continue;
                }
                if (this.command.toLowerCase().startsWith("disconnect")) {
                    try {
                        this.clientSocket.close();
                        this.s_bo.close();
                        this.s_br.close();
                    }
                    catch (Exception er) {
                        this.println("-ERR " + er);
                    }
                    break;
                }
                if (!this.command.trim().equals("")) {
                    if (this.clientSocket == null && !this.connect()) continue;
                    this.sendCommand(this.command);
                    continue;
                }
                if (this.clientSocket != null) continue;
                this.connect();
            }
            catch (Exception e) {
                this.println("-ERR " + e);
            }
        }
        qsAdminShell = null;
    }

    private void print(String text) {
        System.out.print(text);
    }

    private void println(String text) {
        System.out.println(text);
    }

    private boolean connect() throws IOException {
        try {
            this.server.getQSAdminServer().getServer().nextClientIsTrusted();
            int port = this.server.getQSAdminServer().getServer().getPort();
            String host = this.server.getQSAdminServer().getServer().getBindAddr().getHostAddress();
            this.connect(host, port);
            return true;
        }
        catch (Exception e) {
            this.println(this.error + e.getMessage());
            logger.warning(MyString.getStackTrace(e));
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.clientSocket = null;
            }
            return false;
        }
    }

    private void connect(String host, int port) throws IOException {
        this.clientSocket = new Socket(host, port);
        this.clientSocket.setSoTimeout(0);
        this.s_in = this.clientSocket.getInputStream();
        this.s_out = this.clientSocket.getOutputStream();
        this.s_br = new BufferedReader(new InputStreamReader(this.s_in, "UTF-8"));
        this.s_bo = new BufferedOutputStream(this.s_out);
        String temp = null;
        temp = this.s_br.readLine();
        temp = this.s_br.readLine();
        temp = this.s_br.readLine();
        if (oldMaxClient == -1L) {
            try {
                long maxC = -1L;
                this.sendCommand("get self maxClient", false);
                temp = this.s_br.readLine();
                maxC = Long.parseLong(temp.substring(4));
                if (maxC != -1L && maxC != 0L) {
                    oldMaxClient = maxC++;
                    this.sendCommand("set self maxClient " + maxC, false);
                    temp = this.s_br.readLine();
                    if (!temp.startsWith("+OK")) {
                        this.println(this.error + "Could not increase max client from QSAdmin : " + this.s_br);
                    }
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception ignoreEx) {
                this.println(this.error + ignoreEx.getMessage());
            }
        }
        this.startSocketListener();
    }

    private synchronized void sendCommand(String command) throws IOException {
        this.sendCommand(command, true);
    }

    private synchronized void sendCommand(String command, boolean wait) throws IOException {
        if (this.clientSocket == null) {
            this.println(this.error + "Not connected yet");
        }
        command = command + QuickServer.getNewLine();
        this.gotResponse = false;
        byte[] d = command.getBytes();
        this.s_bo.write(d, 0, d.length);
        this.s_bo.flush();
        try {
            while (wait && !this.gotResponse) {
                QSAdminShell.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            logger.fine(this.error + e.getMessage());
        }
    }

    public void startSocketListener() {
        String pad = "";
        Thread t = new Thread(){

            public void run() {
                String rec = "";
                while (true) {
                    try {
                        rec = QSAdminShell.this.s_br.readLine();
                    }
                    catch (IOException e) {
                        logger.info("Shell Closed! " + e.getMessage());
                        break;
                    }
                    if (rec == null) {
                        QSAdminShell.this.clientSocket = null;
                        break;
                    }
                    if (rec.equals("+OK info follows")) {
                        QSAdminShell.this.multilineResponse = true;
                    }
                    QSAdminShell.this.println("" + rec);
                    if (!QSAdminShell.this.multilineResponse) {
                        QSAdminShell.this.gotResponse = true;
                        continue;
                    }
                    if (!rec.equals(".")) continue;
                    QSAdminShell.this.gotResponse = true;
                    QSAdminShell.this.multilineResponse = false;
                }
                try {
                    QSAdminShell.this.clientSocket.close();
                    QSAdminShell.this.clientSocket = null;
                }
                catch (Exception e) {
                    logger.fine(QSAdminShell.this.error + e.getMessage());
                }
            }
        };
        t.setDaemon(true);
        t.setName("GUIAdminShell-SocketListener");
        t.start();
    }

    public static void tryFullThreadDump() {
        System.out.println("Trying to get Full Thread Dump @ " + new Date());
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().startsWith("windows")) {
            try {
                Robot robot = new Robot();
                robot.keyPress(17);
                robot.keyPress(3);
                robot.keyRelease(3);
                robot.keyRelease(17);
            }
            catch (Exception ignore) {
                logger.warning("Could not press: Ctrl+Break");
            }
        } else {
            try {
                Robot robot = new Robot();
                robot.keyPress(17);
                robot.keyPress(92);
                robot.keyRelease(92);
                robot.keyRelease(17);
            }
            catch (Exception ignore) {
                logger.warning("Could not press: Ctrl+\\");
            }
        }
    }

    static {
        oldMaxClient = -1L;
    }
}

