/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.qsadmin;

import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.quickserver.net.AppException;
import org.quickserver.net.qsadmin.CommandPlugin;
import org.quickserver.net.qsadmin.QSAdminShell;
import org.quickserver.net.server.QuickServer;

public class QSAdminServer {
    private static Logger logger = Logger.getLogger(QSAdminServer.class.getName());
    private static final String VER = "2.0";
    private QuickServer controlServer;
    private QuickServer adminServer;
    private int port = 9877;
    private String cmdHandle = "org.quickserver.net.qsadmin.CommandHandler";
    private String auth = "org.quickserver.net.qsadmin.Authenticator";
    private String data = "org.quickserver.net.qsadmin.Data";
    private String pluginClass;
    private CommandPlugin plugin;
    private boolean shellEnable;
    private String promptName;

    public QSAdminServer(QuickServer controlServer) {
        this.controlServer = controlServer;
        this.adminServer = new QuickServer();
        this.adminServer.setClientEventHandler(this.cmdHandle);
        this.adminServer.setClientCommandHandler(this.cmdHandle);
        this.adminServer.setClientAuthenticationHandler(this.auth);
        this.adminServer.setClientData(this.data);
        this.adminServer.setPort(this.port);
        this.adminServer.setAppLogger(logger);
        this.adminServer.setName("QSAdminServer v 2.0");
        this.adminServer.setMaxConnection(1L);
        this.adminServer.getBasicConfig().getServerMode().setBlocking(true);
        try {
            this.adminServer.setBindAddr("127.0.0.1");
        }
        catch (UnknownHostException e) {
            logger.warning("Could not bind to 127.0.0.1");
            throw new RuntimeException("Could not bind to 127.0.0.1 : " + e);
        }
        this.adminServer.setQSAdminServer(this);
    }

    public void setAuthenticator(String authenticator) {
        if (authenticator != null) {
            this.adminServer.setClientAuthenticationHandler(authenticator);
        }
    }

    public void setClientAuthenticationHandler(String authenticator) {
        if (authenticator != null) {
            this.adminServer.setClientAuthenticationHandler(authenticator);
        }
    }

    public void startServer(int port) throws AppException {
        this.adminServer.setPort(port);
        this.startServer();
    }

    public void startServer() throws AppException {
        this.prepareCommandPlugin();
        Object[] store = new Object[]{this.getControlServer(), this.plugin, this};
        this.adminServer.setStoreObjects(store);
        if (this.getControlServer() == null) {
            throw new NullPointerException("control Server was null");
        }
        try {
            this.adminServer.startServer();
            if (this.isShellEnable()) {
                QSAdminShell.getInstance(this.getControlServer(), this.getPromptName());
            }
        }
        catch (AppException e) {
            logger.warning("AppError : " + e);
            throw e;
        }
    }

    public QuickServer getServer() {
        return this.adminServer;
    }

    public QuickServer getControlServer() {
        return this.controlServer;
    }

    private void prepareCommandPlugin() {
        String _pluginClass = this.getCommandPlugin();
        if (_pluginClass == null) {
            return;
        }
        try {
            Class cl = this.getControlServer().getClass(this.pluginClass, true);
            this.plugin = (CommandPlugin)cl.newInstance();
        }
        catch (Exception e) {
            logger.warning("Error loading plugin : " + e);
        }
    }

    public void setCommandPlugin(String pluginClass) throws Exception {
        if (pluginClass == null) {
            return;
        }
        this.pluginClass = pluginClass;
    }

    public String getCommandPlugin() {
        return this.pluginClass;
    }

    public static String getVersion() {
        return VER;
    }

    public boolean isShellEnable() {
        return this.shellEnable;
    }

    public void setShellEnable(boolean flag) {
        this.shellEnable = flag;
    }

    public void setPromptName(String promptName) {
        if (promptName != null && !promptName.equals("")) {
            this.promptName = promptName;
        }
    }

    public String getPromptName() {
        return this.promptName;
    }
}

