/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.querz.io.ExceptionTriConsumer;
import net.querz.io.MaxDepthIO;
import net.querz.nbt.io.NBTOutput;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.EndTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public class LittleEndianNBTOutputStream
implements DataOutput,
NBTOutput,
MaxDepthIO,
Closeable {
    private final DataOutputStream output;
    private static Map<Byte, ExceptionTriConsumer<LittleEndianNBTOutputStream, Tag<?>, Integer, IOException>> writers = new HashMap();
    private static Map<Class<?>, Byte> classIdMapping = new HashMap();

    private static void put(byte id, ExceptionTriConsumer<LittleEndianNBTOutputStream, Tag<?>, Integer, IOException> f, Class<?> clazz) {
        writers.put(id, f);
        classIdMapping.put(clazz, id);
    }

    public LittleEndianNBTOutputStream(OutputStream out) {
        this.output = new DataOutputStream(out);
    }

    public LittleEndianNBTOutputStream(DataOutputStream out) {
        this.output = out;
    }

    @Override
    public void writeTag(NamedTag tag, int maxDepth) throws IOException {
        this.writeByte(tag.getTag().getID());
        if (tag.getTag().getID() != 0) {
            this.writeUTF(tag.getName() == null ? "" : tag.getName());
        }
        this.writeRawTag(tag.getTag(), maxDepth);
    }

    @Override
    public void writeTag(Tag<?> tag, int maxDepth) throws IOException {
        this.writeByte(tag.getID());
        if (tag.getID() != 0) {
            this.writeUTF("");
        }
        this.writeRawTag(tag, maxDepth);
    }

    public void writeRawTag(Tag<?> tag, int maxDepth) throws IOException {
        ExceptionTriConsumer<LittleEndianNBTOutputStream, Tag<?>, Integer, IOException> f = writers.get(tag.getID());
        if (f == null) {
            throw new IOException("invalid tag \"" + tag.getID() + "\"");
        }
        f.accept(this, tag, maxDepth);
    }

    static byte idFromClass(Class<?> clazz) {
        Byte id = classIdMapping.get(clazz);
        if (id == null) {
            throw new IllegalArgumentException("unknown Tag class " + clazz.getName());
        }
        return id;
    }

    private static void writeByte(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeByte(((ByteTag)tag).asByte());
    }

    private static void writeShort(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeShort(((ShortTag)tag).asShort());
    }

    private static void writeInt(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((IntTag)tag).asInt());
    }

    private static void writeLong(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeLong(((LongTag)tag).asLong());
    }

    private static void writeFloat(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeFloat(((FloatTag)tag).asFloat());
    }

    private static void writeDouble(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeDouble(((DoubleTag)tag).asDouble());
    }

    private static void writeString(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeUTF(((StringTag)tag).getValue());
    }

    private static void writeByteArray(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((ByteArrayTag)tag).length());
        out.write((byte[])((ByteArrayTag)tag).getValue());
    }

    private static void writeIntArray(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((IntArrayTag)tag).length());
        for (int i : (int[])((IntArrayTag)tag).getValue()) {
            out.writeInt(i);
        }
    }

    private static void writeLongArray(LittleEndianNBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((LongArrayTag)tag).length());
        for (long l : (long[])((LongArrayTag)tag).getValue()) {
            out.writeLong(l);
        }
    }

    private static void writeList(LittleEndianNBTOutputStream out, Tag<?> tag, int maxDepth) throws IOException {
        out.writeByte(LittleEndianNBTOutputStream.idFromClass(((ListTag)tag).getTypeClass()));
        out.writeInt(((ListTag)tag).size());
        for (Tag t : (ListTag)tag) {
            out.writeRawTag(t, out.decrementMaxDepth(maxDepth));
        }
    }

    private static void writeCompound(LittleEndianNBTOutputStream out, Tag<?> tag, int maxDepth) throws IOException {
        for (Map.Entry<String, Tag<?>> entry : (CompoundTag)tag) {
            if (entry.getValue().getID() == 0) {
                throw new IOException("end tag not allowed");
            }
            out.writeByte(entry.getValue().getID());
            out.writeUTF(entry.getKey());
            out.writeRawTag(entry.getValue(), out.decrementMaxDepth(maxDepth));
        }
        out.writeByte(0);
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.output.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.output.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.output.writeShort(Short.reverseBytes((short)v));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.output.writeChar(Character.reverseBytes((char)v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.output.writeInt(Integer.reverseBytes(v));
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.output.writeLong(Long.reverseBytes(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.output.writeInt(Integer.reverseBytes(Float.floatToIntBits(v)));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.output.writeLong(Long.reverseBytes(Double.doubleToLongBits(v)));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.output.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.output.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }

    static {
        LittleEndianNBTOutputStream.put((byte)0, (o, t, d) -> {}, EndTag.class);
        LittleEndianNBTOutputStream.put((byte)1, (o, t, d) -> LittleEndianNBTOutputStream.writeByte(o, t), ByteTag.class);
        LittleEndianNBTOutputStream.put((byte)2, (o, t, d) -> LittleEndianNBTOutputStream.writeShort(o, t), ShortTag.class);
        LittleEndianNBTOutputStream.put((byte)3, (o, t, d) -> LittleEndianNBTOutputStream.writeInt(o, t), IntTag.class);
        LittleEndianNBTOutputStream.put((byte)4, (o, t, d) -> LittleEndianNBTOutputStream.writeLong(o, t), LongTag.class);
        LittleEndianNBTOutputStream.put((byte)5, (o, t, d) -> LittleEndianNBTOutputStream.writeFloat(o, t), FloatTag.class);
        LittleEndianNBTOutputStream.put((byte)6, (o, t, d) -> LittleEndianNBTOutputStream.writeDouble(o, t), DoubleTag.class);
        LittleEndianNBTOutputStream.put((byte)7, (o, t, d) -> LittleEndianNBTOutputStream.writeByteArray(o, t), ByteArrayTag.class);
        LittleEndianNBTOutputStream.put((byte)8, (o, t, d) -> LittleEndianNBTOutputStream.writeString(o, t), StringTag.class);
        LittleEndianNBTOutputStream.put((byte)9, LittleEndianNBTOutputStream::writeList, ListTag.class);
        LittleEndianNBTOutputStream.put((byte)10, LittleEndianNBTOutputStream::writeCompound, CompoundTag.class);
        LittleEndianNBTOutputStream.put((byte)11, (o, t, d) -> LittleEndianNBTOutputStream.writeIntArray(o, t), IntArrayTag.class);
        LittleEndianNBTOutputStream.put((byte)12, (o, t, d) -> LittleEndianNBTOutputStream.writeLongArray(o, t), LongArrayTag.class);
    }
}

