/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectmapk.jackson.module.kogera.ser.serializers;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.github.projectmapk.jackson.module.kogera.InternalCommonsKt;
import io.github.projectmapk.jackson.module.kogera.ReflectionCache;
import io.github.projectmapk.jackson.module.kogera.ValueClassUnboxConverter;
import io.github.projectmapk.jackson.module.kogera.ser.serializers.ValueClassStaticJsonKeySerializer;
import io.github.projectmapk.jackson.module.kogera.ser.serializers.ValueClassUnboxKeySerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/projectmapk/jackson/module/kogera/ser/serializers/KotlinKeySerializers;", "Lcom/fasterxml/jackson/databind/ser/Serializers$Base;", "cache", "Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;", "(Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;)V", "findSerializer", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "config", "Lcom/fasterxml/jackson/databind/SerializationConfig;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kogera"})
public final class KotlinKeySerializers
extends Serializers.Base {
    @NotNull
    private final ReflectionCache cache;

    public KotlinKeySerializers(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @Nullable
    public JsonSerializer<?> findSerializer(@NotNull SerializationConfig config, @NotNull JavaType type, @NotNull BeanDescription beanDesc) {
        JsonSerializer jsonSerializer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        Class rawClass = type.getRawClass();
        Intrinsics.checkNotNullExpressionValue((Object)rawClass, (String)"rawClass");
        if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
            ValueClassUnboxConverter<?> unboxConverter = this.cache.getValueClassUnboxConverter(rawClass);
            StdSerializer stdSerializer = ValueClassStaticJsonKeySerializer.Companion.createOrNull(unboxConverter);
            if (stdSerializer == null) {
                stdSerializer = new ValueClassUnboxKeySerializer(unboxConverter);
            }
            jsonSerializer = (JsonSerializer)stdSerializer;
        } else {
            jsonSerializer = null;
        }
        return jsonSerializer;
    }
}

