/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectmapk.jackson.module.kogera.deser.singleton_support;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import io.github.projectmapk.jackson.module.kogera.JmClass;
import io.github.projectmapk.jackson.module.kogera.ReflectionCache;
import io.github.projectmapk.jackson.module.kogera.deser.singleton_support.KotlinObjectSingletonDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.Flag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0016\u0010\r\u001a\u0004\u0018\u00010\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/projectmapk/jackson/module/kogera/deser/singleton_support/KotlinBeanDeserializerModifier;", "Lcom/fasterxml/jackson/databind/deser/BeanDeserializerModifier;", "cache", "Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;", "(Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;)V", "modifyDeserializer", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "", "config", "Lcom/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "deserializer", "objectSingletonInstance", "beanClass", "Ljava/lang/Class;", "jackson-module-kogera"})
public final class KotlinBeanDeserializerModifier
extends BeanDeserializerModifier {
    @NotNull
    private final ReflectionCache cache;

    public KotlinBeanDeserializerModifier(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    private final Object objectSingletonInstance(Class<?> beanClass) {
        Object object;
        JmClass jmClass = this.cache.getJmClass(beanClass);
        if (jmClass != null) {
            JmClass it = jmClass;
            boolean bl = false;
            int flags = it.getFlags();
            object = Flag.Class.IS_OBJECT.invoke(flags) && !Flag.Class.IS_COMPANION_OBJECT.invoke(flags) ? beanClass.getDeclaredField("INSTANCE").get(null) : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public JsonDeserializer<? extends Object> modifyDeserializer(@NotNull DeserializationConfig config, @NotNull BeanDescription beanDesc, @NotNull JsonDeserializer<?> deserializer) {
        JsonDeserializer jsonDeserializer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        JsonDeserializer modifiedFromParent = super.modifyDeserializer(config, beanDesc, deserializer);
        Class clazz = beanDesc.getBeanClass();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"beanDesc.beanClass");
        Object object = this.objectSingletonInstance(clazz);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)modifiedFromParent, (String)"modifiedFromParent");
            jsonDeserializer = new KotlinObjectSingletonDeserializer(it, modifiedFromParent);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)modifiedFromParent, (String)"modifiedFromParent");
            jsonDeserializer = modifiedFromParent;
        }
        return jsonDeserializer;
    }
}

