/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectmapk.jackson.module.kogera.deser.deserializers;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import io.github.projectmapk.jackson.module.kogera.InternalCommonsKt;
import io.github.projectmapk.jackson.module.kogera.JmClass;
import io.github.projectmapk.jackson.module.kogera.ReflectionCache;
import io.github.projectmapk.jackson.module.kogera.ValueClassBoxConverter;
import io.github.projectmapk.jackson.module.kogera.deser.JavaToKotlinDurationConverter;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.KotlinDeserializersKt;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.RegexDeserializer;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.SequenceDeserializer;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.UByteDeserializer;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.UIntDeserializer;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.ULongDeserializer;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.UShortDeserializer;
import io.github.projectmapk.jackson.module.kogera.deser.deserializers.ValueClassBoxDeserializer;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/projectmapk/jackson/module/kogera/deser/deserializers/KotlinDeserializers;", "Lcom/fasterxml/jackson/databind/deser/Deserializers$Base;", "cache", "Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;", "useJavaDurationConversion", "", "(Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;Z)V", "findBeanDeserializer", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "config", "Lcom/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kogera"})
public final class KotlinDeserializers
extends Deserializers.Base {
    @NotNull
    private final ReflectionCache cache;
    private final boolean useJavaDurationConversion;

    public KotlinDeserializers(@NotNull ReflectionCache cache, boolean useJavaDurationConversion) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
        this.useJavaDurationConversion = useJavaDurationConversion;
    }

    @Nullable
    public JsonDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @Nullable DeserializationConfig config, @NotNull BeanDescription beanDesc) {
        JsonDeserializer jsonDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        Class rawClass = type.getRawClass();
        if (Intrinsics.areEqual((Object)rawClass, Sequence.class)) {
            jsonDeserializer = (JsonDeserializer)SequenceDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, Regex.class)) {
            jsonDeserializer = (JsonDeserializer)RegexDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UByte.class)) {
            jsonDeserializer = (JsonDeserializer)UByteDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UShort.class)) {
            jsonDeserializer = (JsonDeserializer)UShortDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UInt.class)) {
            jsonDeserializer = (JsonDeserializer)UIntDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, ULong.class)) {
            jsonDeserializer = (JsonDeserializer)ULongDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, Duration.class)) {
            JavaToKotlinDurationConverter javaToKotlinDurationConverter;
            JavaToKotlinDurationConverter it = javaToKotlinDurationConverter = JavaToKotlinDurationConverter.INSTANCE;
            boolean bl = false;
            JavaToKotlinDurationConverter javaToKotlinDurationConverter2 = this.useJavaDurationConversion ? javaToKotlinDurationConverter : null;
            jsonDeserializer = (JsonDeserializer)(javaToKotlinDurationConverter2 != null ? javaToKotlinDurationConverter2.getDelegatingDeserializer() : null);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)rawClass, (String)"rawClass");
            if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
                ValueClassBoxDeserializer valueClassBoxDeserializer;
                JmClass jmClass = this.cache.getJmClass(rawClass);
                Intrinsics.checkNotNull((Object)jmClass);
                Method method = KotlinDeserializersKt.access$findValueCreator(type, rawClass, jmClass);
                if (method != null) {
                    Method it = method;
                    boolean bl = false;
                    Class<?> unboxedClass = this.cache.getValueClassUnboxConverter(rawClass).getUnboxedClass();
                    ValueClassBoxConverter<?, ?> converter = this.cache.getValueClassBoxConverter(unboxedClass, rawClass);
                    valueClassBoxDeserializer = new ValueClassBoxDeserializer(it, converter);
                } else {
                    valueClassBoxDeserializer = null;
                }
                jsonDeserializer = (JsonDeserializer)valueClassBoxDeserializer;
            } else {
                jsonDeserializer = null;
            }
        }
        return jsonDeserializer;
    }
}

