/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectmapk.jackson.module.kogera;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.LRUMap;
import io.github.projectmapk.jackson.module.kogera.InternalCommonsKt;
import io.github.projectmapk.jackson.module.kogera.JmClass;
import io.github.projectmapk.jackson.module.kogera.JmClassKt;
import io.github.projectmapk.jackson.module.kogera.ValueClassBoxConverter;
import io.github.projectmapk.jackson.module.kogera.ValueClassUnboxConverter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.KmType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0007J&\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0016\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u00020\fH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;", "Ljava/io/Serializable;", "reflectionCacheSize", "", "(I)V", "classCache", "Lcom/fasterxml/jackson/databind/util/LRUMap;", "Ljava/lang/Class;", "Lio/github/projectmapk/jackson/module/kogera/JmClass;", "valueClassBoxConverterCache", "Lio/github/projectmapk/jackson/module/kogera/ValueClassBoxConverter;", "valueClassReturnTypeCache", "Ljava/lang/reflect/Method;", "Ljava/util/Optional;", "valueClassUnboxConverterCache", "Lio/github/projectmapk/jackson/module/kogera/ValueClassUnboxConverter;", "findBoxedReturnType", "getter", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedMethod;", "getJmClass", "clazz", "getValueClassBoxConverter", "unboxedClass", "valueClass", "getValueClassUnboxConverter", "getValueClassReturnType", "Companion", "jackson-module-kogera"})
public final class ReflectionCache
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LRUMap<Class<?>, JmClass> classCache;
    @NotNull
    private final LRUMap<Method, Optional<Class<?>>> valueClassReturnTypeCache;
    @NotNull
    private final LRUMap<Class<?>, ValueClassBoxConverter<?, ?>> valueClassBoxConverterCache;
    @NotNull
    private final LRUMap<Class<?>, ValueClassUnboxConverter<?>> valueClassUnboxConverterCache;
    private static final long serialVersionUID = 3L;

    public ReflectionCache(int reflectionCacheSize) {
        this.classCache = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.valueClassReturnTypeCache = new LRUMap(0, reflectionCacheSize);
        this.valueClassBoxConverterCache = new LRUMap(0, reflectionCacheSize);
        this.valueClassUnboxConverterCache = new LRUMap(0, reflectionCacheSize);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JmClass getJmClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        JmClass jmClass = (JmClass)this.classCache.get(clazz);
        if (jmClass == null) {
            JmClass jmClass2;
            void $this$mapNotNullTo$iv$iv;
            JmClass jmClass3;
            Metadata metadata;
            ReflectionCache $this$getJmClass_u24lambda_u242 = this;
            boolean bl = false;
            Metadata metadata2 = metadata = clazz.getAnnotation(Metadata.class);
            if (metadata2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)metadata2, (String)"clazz.getAnnotation(Meta\u2026lass.java) ?: return null");
            Metadata metadata3 = metadata;
            if (!clazz.isInterface()) {
                Class<?> clazz2;
                Class<?> clazz3 = clazz2 = clazz.getSuperclass();
                if (clazz3 != null) {
                    Intrinsics.checkNotNullExpressionValue(clazz3, (String)"superclass");
                    Class<?> it = clazz2;
                    boolean bl2 = false;
                    jmClass3 = !Intrinsics.areEqual(it, Object.class) ? $this$getJmClass_u24lambda_u242.getJmClass(it) : null;
                } else {
                    jmClass3 = null;
                }
            } else {
                jmClass3 = null;
            }
            JmClass superJmClass = jmClass3;
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"clazz.interfaces");
            Object[] $this$mapNotNull$iv = classArray;
            boolean $i$f$mapNotNull = false;
            Object[] bl2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                JmClass it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl3 = false;
                Class it = (Class)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if ($this$getJmClass_u24lambda_u242.getJmClass(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List interfaceJmClasses = (List)destination$iv$iv;
            JmClass value = JmClassKt.JmClass(clazz, metadata3, superJmClass, interfaceJmClasses);
            JmClass jmClass4 = jmClass2 = (JmClass)$this$getJmClass_u24lambda_u242.classCache.putIfAbsent(clazz, (Object)value);
            if (jmClass4 == null) {
                jmClass = value;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)jmClass4, (String)"classCache.putIfAbsent(clazz, value) ?: value");
                jmClass = jmClass2;
            }
        }
        return jmClass;
    }

    private final Class<?> getValueClassReturnType(Method $this$getValueClassReturnType) {
        Object object;
        Class<?> clazz = $this$getValueClassReturnType.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"declaringClass");
        JmClass jmClass = this.getJmClass(clazz);
        Object kotlinProperty = jmClass != null ? jmClass.findPropertyByGetter($this$getValueClassReturnType) : null;
        Object object2 = kotlinProperty;
        if (object2 != null && (object2 = object2.getReturnType()) != null && (object2 = InternalCommonsKt.reconstructClassOrNull((KmType)object2)) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            object = InternalCommonsKt.isUnboxableValueClass(it) ? object3 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final Class<?> findBoxedReturnType(@NotNull AnnotatedMethod getter) {
        Optional<Class<?>> optional;
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        Method method = getter.getMember();
        Optional<Class<?>> optional2 = (Optional<Class<?>>)this.valueClassReturnTypeCache.get((Object)method);
        if (optional2 != null) {
            optional = optional2;
        } else {
            Class<?> clazz = method.getReturnType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"method.returnType");
            if (InternalCommonsKt.isUnboxableValueClass(clazz)) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            Optional<Class<?>> optional3 = Optional.ofNullable(this.getValueClassReturnType(method));
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"ofNullable(method.getValueClassReturnType())");
            Optional<Class<?>> value = optional3;
            optional = (Optional<Class<?>>)this.valueClassReturnTypeCache.putIfAbsent((Object)method, value);
            if (optional == null) {
                optional = value;
            }
        }
        return optional.orElse(null);
    }

    @NotNull
    public final ValueClassBoxConverter<?, ?> getValueClassBoxConverter(@NotNull Class<?> unboxedClass, @NotNull Class<?> valueClass) {
        ValueClassBoxConverter valueClassBoxConverter;
        Intrinsics.checkNotNullParameter(unboxedClass, (String)"unboxedClass");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        ValueClassBoxConverter valueClassBoxConverter2 = (ValueClassBoxConverter)((Object)this.valueClassBoxConverterCache.get(valueClass));
        if (valueClassBoxConverter2 == null) {
            ValueClassBoxConverter valueClassBoxConverter3;
            ReflectionCache $this$getValueClassBoxConverter_u24lambda_u244 = this;
            boolean bl = false;
            ValueClassBoxConverter value = new ValueClassBoxConverter(unboxedClass, valueClass);
            ValueClassBoxConverter valueClassBoxConverter4 = valueClassBoxConverter3 = (ValueClassBoxConverter)((Object)$this$getValueClassBoxConverter_u24lambda_u244.valueClassBoxConverterCache.putIfAbsent(valueClass, value));
            if (valueClassBoxConverter4 == null) {
                valueClassBoxConverter = value;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)valueClassBoxConverter4), (String)"valueClassBoxConverterCa\u2026lueClass, value) ?: value");
                valueClassBoxConverter = valueClassBoxConverter3;
            }
        } else {
            valueClassBoxConverter = valueClassBoxConverter2;
        }
        return valueClassBoxConverter;
    }

    @NotNull
    public final ValueClassUnboxConverter<?> getValueClassUnboxConverter(@NotNull Class<?> valueClass) {
        ValueClassUnboxConverter valueClassUnboxConverter;
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        ValueClassUnboxConverter valueClassUnboxConverter2 = (ValueClassUnboxConverter)((Object)this.valueClassUnboxConverterCache.get(valueClass));
        if (valueClassUnboxConverter2 == null) {
            ValueClassUnboxConverter valueClassUnboxConverter3;
            ReflectionCache $this$getValueClassUnboxConverter_u24lambda_u245 = this;
            boolean bl = false;
            ValueClassUnboxConverter value = new ValueClassUnboxConverter(valueClass);
            ValueClassUnboxConverter valueClassUnboxConverter4 = valueClassUnboxConverter3 = (ValueClassUnboxConverter)((Object)$this$getValueClassUnboxConverter_u24lambda_u245.valueClassUnboxConverterCache.putIfAbsent(valueClass, value));
            if (valueClassUnboxConverter4 == null) {
                valueClassUnboxConverter = value;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)valueClassUnboxConverter4), (String)"valueClassUnboxConverter\u2026lueClass, value) ?: value");
                valueClassUnboxConverter = valueClassUnboxConverter3;
            }
        } else {
            valueClassUnboxConverter = valueClassUnboxConverter2;
        }
        return valueClassUnboxConverter;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lio/github/projectmapk/jackson/module/kogera/ReflectionCache$Companion;", "", "()V", "serialVersionUID", "", "getSerialVersionUID$annotations", "jackson-module-kogera"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getSerialVersionUID$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

