/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter.utils;

import android.bluetooth.BluetoothGatt;
import android.support.annotation.NonNull;
import com.polidea.rxandroidble.RxBleCustomOperation;
import com.polidea.rxandroidble.internal.RxBleLog;
import com.polidea.rxandroidble.internal.connection.RxBleGattCallback;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;

public class RefreshGattCustomOperation
implements RxBleCustomOperation<Boolean> {
    @NonNull
    public Observable<Boolean> asObservable(final BluetoothGatt bluetoothGatt, RxBleGattCallback rxBleGattCallback, Scheduler scheduler) throws Throwable {
        return Observable.amb((Observable)Observable.fromCallable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = false;
                try {
                    Method bluetoothGattRefreshFunction = bluetoothGatt.getClass().getMethod("refresh", new Class[0]);
                    if (bluetoothGattRefreshFunction == null) {
                        RxBleLog.d((String)"Could not find function BluetoothGatt.refresh()", (Object[])new Object[0]);
                    } else {
                        success = (Boolean)bluetoothGattRefreshFunction.invoke((Object)bluetoothGatt, new Object[0]);
                        if (!success) {
                            RxBleLog.d((String)"BluetoothGatt.refresh() returned false", (Object[])new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    RxBleLog.d((Throwable)e, (String)"Could not call function BluetoothGatt.refresh()", (Object[])new Object[0]);
                }
                RxBleLog.i((String)"Calling BluetoothGatt.refresh() status: %s", (Object[])new Object[]{success ? "Success" : "Failure"});
                return success;
            }
        }).subscribeOn(scheduler).delay(1L, TimeUnit.SECONDS, scheduler), (Observable)rxBleGattCallback.observeDisconnect());
    }
}

