/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AdvertisementData {
    private byte[] manufacturerData;
    private Map<UUID, byte[]> serviceData;
    private List<UUID> serviceUUIDs;
    private String localName;
    private Integer txPowerLevel;
    private List<UUID> solicitedServiceUUIDs;
    private static final long BLUETOOTH_BASE_UUID_LSB = -9223371485494954757L;
    private static final int BLUETOOTH_BASE_UUID_MSB = 4096;

    public String getLocalName() {
        return this.localName;
    }

    public byte[] getManufacturerData() {
        return this.manufacturerData;
    }

    public Map<UUID, byte[]> getServiceData() {
        return this.serviceData;
    }

    public List<UUID> getServiceUUIDs() {
        return this.serviceUUIDs;
    }

    public Integer getTxPowerLevel() {
        return this.txPowerLevel;
    }

    public List<UUID> getSolicitedServiceUUIDs() {
        return this.solicitedServiceUUIDs;
    }

    private AdvertisementData() {
    }

    public AdvertisementData(byte[] manufacturerData, Map<UUID, byte[]> serviceData, List<UUID> serviceUUIDs, String localName, Integer txPowerLevel, List<UUID> solicitedServiceUUIDs) {
        this.manufacturerData = manufacturerData;
        this.serviceData = serviceData;
        this.serviceUUIDs = serviceUUIDs;
        this.localName = localName;
        this.txPowerLevel = txPowerLevel;
        this.solicitedServiceUUIDs = solicitedServiceUUIDs;
    }

    public static AdvertisementData parseScanResponseData(byte[] advertisement) {
        int adLength;
        AdvertisementData advData = new AdvertisementData();
        ByteBuffer rawData = ByteBuffer.wrap(advertisement).order(ByteOrder.LITTLE_ENDIAN);
        while (rawData.remaining() >= 2 && (adLength = rawData.get() & 0xFF) != 0) {
            int adType = rawData.get() & 0xFF;
            if (rawData.remaining() < --adLength) break;
            AdvertisementData.parseAdvertisementData(advData, adType, adLength, rawData.slice().order(ByteOrder.LITTLE_ENDIAN));
            rawData.position(rawData.position() + adLength);
        }
        return advData;
    }

    private static void parseAdvertisementData(AdvertisementData advData, int adType, int adLength, ByteBuffer data) {
        switch (adType) {
            case 255: {
                AdvertisementData.parseManufacturerData(advData, adLength, data);
                break;
            }
            case 2: 
            case 3: {
                AdvertisementData.parseServiceUUIDs(advData, adLength, data, 2);
                break;
            }
            case 4: 
            case 5: {
                AdvertisementData.parseServiceUUIDs(advData, adLength, data, 4);
                break;
            }
            case 6: 
            case 7: {
                AdvertisementData.parseServiceUUIDs(advData, adLength, data, 16);
                break;
            }
            case 8: 
            case 9: {
                AdvertisementData.parseLocalName(advData, adType, adLength, data);
                break;
            }
            case 10: {
                AdvertisementData.parseTxPowerLevel(advData, adLength, data);
                break;
            }
            case 20: {
                AdvertisementData.parseSolicitedServiceUUIDs(advData, adLength, data, 2);
                break;
            }
            case 31: {
                AdvertisementData.parseSolicitedServiceUUIDs(advData, adLength, data, 4);
                break;
            }
            case 21: {
                AdvertisementData.parseSolicitedServiceUUIDs(advData, adLength, data, 16);
                break;
            }
            case 22: {
                AdvertisementData.parseServiceData(advData, adLength, data, 2);
                break;
            }
            case 32: {
                AdvertisementData.parseServiceData(advData, adLength, data, 4);
                break;
            }
            case 33: {
                AdvertisementData.parseServiceData(advData, adLength, data, 16);
            }
        }
    }

    private static void parseLocalName(AdvertisementData advData, int adType, int adLength, ByteBuffer data) {
        if (advData.localName == null || adType == 9) {
            byte[] bytes = new byte[adLength];
            data.get(bytes, 0, adLength);
            advData.localName = new String(bytes, Charset.forName("UTF-8"));
        }
    }

    private static UUID parseUUID(ByteBuffer data, int uuidLength) {
        long lsb;
        long msb;
        switch (uuidLength) {
            case 2: {
                msb = (((long)data.getShort() & 0xFFFFL) << 32) + 4096L;
                lsb = -9223371485494954757L;
                break;
            }
            case 4: {
                msb = ((long)data.getInt() << 32) + 4096L;
                lsb = -9223371485494954757L;
                break;
            }
            case 16: {
                lsb = data.getLong();
                msb = data.getLong();
                break;
            }
            default: {
                data.position(data.position() + uuidLength);
                return null;
            }
        }
        return new UUID(msb, lsb);
    }

    private static void parseSolicitedServiceUUIDs(AdvertisementData advData, int adLength, ByteBuffer data, int uuidLength) {
        if (advData.solicitedServiceUUIDs == null) {
            advData.solicitedServiceUUIDs = new ArrayList<UUID>();
        }
        while (data.remaining() >= uuidLength && data.position() < adLength) {
            advData.solicitedServiceUUIDs.add(AdvertisementData.parseUUID(data, uuidLength));
        }
    }

    private static void parseServiceUUIDs(AdvertisementData advData, int adLength, ByteBuffer data, int uuidLength) {
        if (advData.serviceUUIDs == null) {
            advData.serviceUUIDs = new ArrayList<UUID>();
        }
        while (data.remaining() >= uuidLength && data.position() < adLength) {
            advData.serviceUUIDs.add(AdvertisementData.parseUUID(data, uuidLength));
        }
    }

    private static void parseServiceData(AdvertisementData advData, int adLength, ByteBuffer data, int uuidLength) {
        if (adLength < uuidLength) {
            return;
        }
        if (advData.serviceData == null) {
            advData.serviceData = new HashMap<UUID, byte[]>();
        }
        UUID serviceUUID = AdvertisementData.parseUUID(data, uuidLength);
        int serviceDataLength = adLength - uuidLength;
        byte[] serviceData = new byte[serviceDataLength];
        data.get(serviceData, 0, serviceDataLength);
        advData.serviceData.put(serviceUUID, serviceData);
    }

    private static void parseTxPowerLevel(AdvertisementData advData, int adLength, ByteBuffer data) {
        if (adLength != 1) {
            return;
        }
        advData.txPowerLevel = data.get();
    }

    private static void parseManufacturerData(AdvertisementData advData, int adLength, ByteBuffer data) {
        if (adLength < 2) {
            return;
        }
        advData.manufacturerData = new byte[adLength];
        data.get(advData.manufacturerData, 0, adLength);
    }
}

