/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerListener;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerView;
import com.pierfrancescosoffritti.youtubeplayer.ui.PlayerUIController;
import com.pierfrancescosoffritti.youtubeplayer.ui.menu.YouTubePlayerMenu;
import com.pierfrancescosoffritti.youtubeplayer.ui.menu.defaultMenu.DefaultYouTubePlayerMenu;
import com.pierfrancescosoffritti.youtubeplayer.utils.Utils;

public class DefaultPlayerUIController
implements PlayerUIController,
YouTubePlayerListener,
YouTubePlayerFullScreenListener,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    @NonNull
    private final YouTubePlayerView youTubePlayerView;
    @NonNull
    private final YouTubePlayer youTubePlayer;
    @NonNull
    private YouTubePlayerMenu youTubePlayerMenu;
    private View panel;
    private View controlsRoot;
    private LinearLayout extraViewsContainer;
    private TextView videoTitle;
    private TextView videoCurrentTime;
    private TextView videoDuration;
    private TextView liveVideoIndicator;
    private ProgressBar progressBar;
    private ImageView menuButton;
    private ImageView playPauseButton;
    private ImageView youTubeButton;
    private ImageView fullScreenButton;
    private ImageView customActionLeft;
    private ImageView customActionRight;
    private SeekBar seekBar;
    @Nullable
    private View.OnClickListener onFullScreenButtonListener;
    @Nullable
    private View.OnClickListener onMenuButtonClickListener;
    private boolean isPlaying = false;
    private boolean isVisible = true;
    private boolean canFadeControls = false;
    private boolean showUI = true;
    private boolean showPlayPauseButton = true;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable fadeOutRunnable = new Runnable(){

        @Override
        public void run() {
            DefaultPlayerUIController.this.fadeControls(0.0f);
        }
    };
    private boolean seekBarTouchStarted = false;
    private int newSeekBarProgress = -1;

    public DefaultPlayerUIController(@NonNull YouTubePlayerView youTubePlayerView, @NonNull YouTubePlayer youTubePlayer) {
        this.youTubePlayerView = youTubePlayerView;
        this.youTubePlayer = youTubePlayer;
        View defaultPlayerUI = View.inflate((Context)youTubePlayerView.getContext(), (int)R.layout.default_player_ui, (ViewGroup)youTubePlayerView);
        this.initViews(defaultPlayerUI);
        this.youTubePlayerMenu = new DefaultYouTubePlayerMenu(youTubePlayerView.getContext());
    }

    private void initViews(View controlsView) {
        this.panel = controlsView.findViewById(R.id.panel);
        this.controlsRoot = controlsView.findViewById(R.id.controls_root);
        this.extraViewsContainer = (LinearLayout)controlsView.findViewById(R.id.extra_views_container);
        this.videoTitle = (TextView)controlsView.findViewById(R.id.video_title);
        this.videoCurrentTime = (TextView)controlsView.findViewById(R.id.video_current_time);
        this.videoDuration = (TextView)controlsView.findViewById(R.id.video_duration);
        this.liveVideoIndicator = (TextView)controlsView.findViewById(R.id.live_video_indicator);
        this.progressBar = (ProgressBar)controlsView.findViewById(R.id.progress);
        this.menuButton = (ImageView)controlsView.findViewById(R.id.menu_button);
        this.playPauseButton = (ImageView)controlsView.findViewById(R.id.play_pause_button);
        this.youTubeButton = (ImageView)controlsView.findViewById(R.id.youtube_button);
        this.fullScreenButton = (ImageView)controlsView.findViewById(R.id.fullscreen_button);
        this.customActionLeft = (ImageView)controlsView.findViewById(R.id.custom_action_left_button);
        this.customActionRight = (ImageView)controlsView.findViewById(R.id.custom_action_right_button);
        this.seekBar = (SeekBar)controlsView.findViewById(R.id.seek_bar);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.panel.setOnClickListener((View.OnClickListener)this);
        this.playPauseButton.setOnClickListener((View.OnClickListener)this);
        this.menuButton.setOnClickListener((View.OnClickListener)this);
        this.fullScreenButton.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void showVideoTitle(boolean show) {
        int visibility = show ? 0 : 8;
        this.videoTitle.setVisibility(visibility);
    }

    @Override
    public void setVideoTitle(@NonNull String title) {
        this.videoTitle.setText((CharSequence)title);
    }

    @Override
    public void showUI(boolean show) {
        int visibility = show ? 0 : 4;
        this.controlsRoot.setVisibility(visibility);
        this.showUI = show;
    }

    @Override
    public void showPlayPauseButton(boolean show) {
        int visibility = show ? 0 : 8;
        this.playPauseButton.setVisibility(visibility);
        this.showPlayPauseButton = show;
    }

    @Override
    public void enableLiveVideoUI(boolean enable) {
        if (enable) {
            this.videoDuration.setVisibility(4);
            this.seekBar.setVisibility(4);
            this.videoCurrentTime.setVisibility(4);
            this.liveVideoIndicator.setVisibility(0);
        } else {
            this.videoDuration.setVisibility(0);
            this.seekBar.setVisibility(0);
            this.videoCurrentTime.setVisibility(0);
            this.liveVideoIndicator.setVisibility(8);
        }
    }

    @Override
    public void setCustomAction1(@NonNull Drawable icon, View.OnClickListener clickListener) {
        this.customActionLeft.setImageDrawable(icon);
        this.customActionLeft.setOnClickListener(clickListener);
        this.showCustomAction1(clickListener != null);
    }

    @Override
    public void setCustomAction2(@NonNull Drawable icon, View.OnClickListener clickListener) {
        this.customActionRight.setImageDrawable(icon);
        this.customActionRight.setOnClickListener(clickListener);
        this.showCustomAction2(clickListener != null);
    }

    @Override
    public void showCustomAction1(boolean show) {
        int visibility = show ? 0 : 8;
        this.customActionLeft.setVisibility(visibility);
    }

    @Override
    public void showCustomAction2(boolean show) {
        int visibility = show ? 0 : 8;
        this.customActionRight.setVisibility(visibility);
    }

    @Override
    public void showMenuButton(boolean show) {
        int visibility = show ? 0 : 8;
        this.menuButton.setVisibility(visibility);
    }

    @Override
    public void setCustomMenuButtonClickListener(@NonNull View.OnClickListener customMenuButtonClickListener) {
        this.onMenuButtonClickListener = customMenuButtonClickListener;
    }

    @Override
    public void showCurrentTime(boolean show) {
        int visibility = show ? 0 : 8;
        this.videoCurrentTime.setVisibility(visibility);
    }

    @Override
    public void showDuration(boolean show) {
        int visibility = show ? 0 : 8;
        this.videoDuration.setVisibility(visibility);
    }

    @Override
    public void showSeekBar(boolean show) {
        int visibility = show ? 0 : 4;
        this.seekBar.setVisibility(visibility);
    }

    @Override
    public void showYouTubeButton(boolean show) {
        int visibility = show ? 0 : 8;
        this.youTubeButton.setVisibility(visibility);
    }

    @Override
    public void addView(@NonNull View view) {
        this.extraViewsContainer.addView(view, 0);
    }

    @Override
    public void removeView(@NonNull View view) {
        this.extraViewsContainer.removeView(view);
    }

    @Override
    @NonNull
    public YouTubePlayerMenu getMenu() {
        return this.youTubePlayerMenu;
    }

    @Override
    public void setMenu(@NonNull YouTubePlayerMenu youTubePlayerMenu) {
        this.youTubePlayerMenu = youTubePlayerMenu;
    }

    @Override
    public void showFullscreenButton(boolean show) {
        int visibility = show ? 0 : 8;
        this.fullScreenButton.setVisibility(visibility);
    }

    @Override
    public void setCustomFullScreenButtonClickListener(@NonNull View.OnClickListener customFullScreenButtonClickListener) {
        this.onFullScreenButtonListener = customFullScreenButtonClickListener;
    }

    public void onClick(View view) {
        if (view == this.panel) {
            this.toggleControlsVisibility();
        } else if (view == this.playPauseButton) {
            this.onPlayButtonPressed();
        } else if (view == this.fullScreenButton) {
            this.onFullScreenButtonPressed();
        } else if (view == this.menuButton) {
            this.onMenuButtonPressed();
        }
    }

    private void onMenuButtonPressed() {
        if (this.onMenuButtonClickListener == null) {
            this.youTubePlayerMenu.show((View)this.menuButton);
        } else {
            this.onMenuButtonClickListener.onClick((View)this.menuButton);
        }
    }

    private void onFullScreenButtonPressed() {
        if (this.onFullScreenButtonListener == null) {
            this.youTubePlayerView.toggleFullScreen();
        } else {
            this.onFullScreenButtonListener.onClick((View)this.fullScreenButton);
        }
    }

    private void onPlayButtonPressed() {
        if (this.isPlaying) {
            this.youTubePlayer.pause();
        } else {
            this.youTubePlayer.play();
        }
    }

    private void updatePlayPauseButtonIcon(boolean playing) {
        int img = playing ? R.drawable.ic_pause_36dp : R.drawable.ic_play_36dp;
        this.playPauseButton.setImageResource(img);
    }

    private void toggleControlsVisibility() {
        float finalAlpha = this.isVisible ? 0.0f : 1.0f;
        this.fadeControls(finalAlpha);
    }

    private void fadeControls(final float finalAlpha) {
        if (!this.canFadeControls || !this.showUI) {
            return;
        }
        boolean bl = this.isVisible = finalAlpha != 0.0f;
        if (finalAlpha == 1.0f && this.isPlaying) {
            this.startFadeOutViewTimer();
        } else {
            this.handler.removeCallbacks(this.fadeOutRunnable);
        }
        this.controlsRoot.animate().alpha(finalAlpha).setDuration(300L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                if (finalAlpha == 1.0f) {
                    DefaultPlayerUIController.this.controlsRoot.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (finalAlpha == 0.0f) {
                    DefaultPlayerUIController.this.controlsRoot.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void startFadeOutViewTimer() {
        this.handler.postDelayed(this.fadeOutRunnable, 3000L);
    }

    @Override
    public void onYouTubePlayerEnterFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_exit_24dp);
    }

    @Override
    public void onYouTubePlayerExitFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_24dp);
    }

    @Override
    public void onStateChange(int state) {
        this.newSeekBarProgress = -1;
        this.updateControlsState(state);
        if (state == 1 || state == 2 || state == 5) {
            this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.youTubePlayerView.getContext(), (int)17170445));
            this.progressBar.setVisibility(8);
            if (this.showPlayPauseButton) {
                this.playPauseButton.setVisibility(0);
            }
            this.canFadeControls = true;
            boolean playing = state == 1;
            this.updatePlayPauseButtonIcon(playing);
            if (playing) {
                this.startFadeOutViewTimer();
            } else {
                this.handler.removeCallbacks(this.fadeOutRunnable);
            }
        } else {
            this.updatePlayPauseButtonIcon(false);
            this.fadeControls(1.0f);
            if (state == 3) {
                this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.youTubePlayerView.getContext(), (int)17170445));
                if (this.showPlayPauseButton) {
                    this.playPauseButton.setVisibility(4);
                }
                this.customActionLeft.setVisibility(8);
                this.customActionRight.setVisibility(8);
                this.canFadeControls = false;
            }
            if (state == -1) {
                this.canFadeControls = false;
                this.progressBar.setVisibility(8);
                if (this.showPlayPauseButton) {
                    this.playPauseButton.setVisibility(0);
                }
            }
        }
    }

    private void updateControlsState(int state) {
        switch (state) {
            case 0: {
                this.isPlaying = false;
                break;
            }
            case 2: {
                this.isPlaying = false;
                break;
            }
            case 1: {
                this.isPlaying = true;
                break;
            }
            case -1: {
                this.resetUI();
                break;
            }
        }
        this.updatePlayPauseButtonIcon(!this.isPlaying);
    }

    @Override
    public void onCurrentSecond(float second) {
        if (this.seekBarTouchStarted) {
            return;
        }
        if (this.newSeekBarProgress > 0 && !Utils.formatTime(second).equals(Utils.formatTime(this.newSeekBarProgress))) {
            return;
        }
        this.newSeekBarProgress = -1;
        this.seekBar.setProgress((int)second);
    }

    @Override
    public void onVideoDuration(float duration) {
        this.videoDuration.setText((CharSequence)Utils.formatTime(duration));
        this.seekBar.setMax((int)duration);
    }

    @Override
    public void onVideoId(final String videoId) {
        this.youTubeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + videoId)));
                DefaultPlayerUIController.this.controlsRoot.getContext().startActivity(intent);
            }
        });
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onMessage(String log) {
    }

    @Override
    public void onPlaybackQualityChange(String playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(String rate) {
    }

    @Override
    public void onError(int error) {
    }

    @Override
    public void onApiChange() {
    }

    public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
        this.videoCurrentTime.setText((CharSequence)Utils.formatTime(i));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.seekBarTouchStarted = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.isPlaying) {
            this.newSeekBarProgress = seekBar.getProgress();
        }
        this.youTubePlayer.seekTo(seekBar.getProgress());
        this.seekBarTouchStarted = false;
    }

    private void resetUI() {
        this.seekBar.setProgress(0);
        this.seekBar.setMax(0);
        this.videoDuration.post(new Runnable(){

            @Override
            public void run() {
                DefaultPlayerUIController.this.videoDuration.setText((CharSequence)"");
            }
        });
    }
}

