/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pierfrancescosoffritti.youtubeplayer.Callable;
import com.pierfrancescosoffritti.youtubeplayer.FullScreenHandler;
import com.pierfrancescosoffritti.youtubeplayer.NetworkReceiver;
import com.pierfrancescosoffritti.youtubeplayer.PlaybackResumer;
import com.pierfrancescosoffritti.youtubeplayer.PlayerControlsWrapper;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.Utils;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayerFullScreenListener;

public class YouTubePlayerView
extends FrameLayout
implements NetworkReceiver.NetworkListener {
    @NonNull
    private final NetworkReceiver networkReceiver;
    @NonNull
    private final YouTubePlayer youTubePlayer;
    @NonNull
    private final PlayerControlsWrapper playerControlsWrapper;
    @NonNull
    private final PlaybackResumer playbackResumer;
    private final FullScreenHandler fullScreenHandler = new FullScreenHandler();
    private boolean initialized = false;
    private Callable asyncInitialization;

    public YouTubePlayerView(Context context) {
        this(context, null);
    }

    public YouTubePlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YouTubePlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.youTubePlayer = new YouTubePlayer(context);
        this.addView((View)this.youTubePlayer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        View playerControls = YouTubePlayerView.inflate((Context)context, (int)R.layout.player_controls, (ViewGroup)this);
        this.playerControlsWrapper = new PlayerControlsWrapper(this, playerControls);
        this.playbackResumer = new PlaybackResumer(this);
        this.addFullScreenListener(this.playerControlsWrapper);
        this.youTubePlayer.addListener(this.playerControlsWrapper);
        this.youTubePlayer.addListener(this.playbackResumer);
        this.networkReceiver = new NetworkReceiver(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getLayoutParams().height == -2) {
            int sixteenNineHeight = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)widthMeasureSpec) * 9 / 16), (int)0x40000000);
            super.onMeasure(widthMeasureSpec, sixteenNineHeight);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void onFullScreenButtonListener(View.OnClickListener listener) {
        this.playerControlsWrapper.setOnFullScreenButtonListener(listener);
    }

    public void enterFullScreen() {
        this.fullScreenHandler.enterFullScreen((View)this);
    }

    public void exitFullScreen() {
        this.fullScreenHandler.exitFullScreen((View)this);
    }

    public boolean isFullScreen() {
        return this.fullScreenHandler.isFullScreen();
    }

    public void toggleFullScreen() {
        this.fullScreenHandler.toggleFullScreen((View)this);
    }

    public boolean addFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenHandler.addFullScreenListener(fullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenHandler.removeFullScreenListener(fullScreenListener);
    }

    public void initialize(final @Nullable YouTubePlayer.YouTubeListener youTubeListener, boolean handleNetworkEvents) {
        if (handleNetworkEvents) {
            this.getContext().registerReceiver((BroadcastReceiver)this.networkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (!Utils.isOnline(this.getContext())) {
            Log.e((String)"YouTubePlayerView", (String)"Can't initialize because device is not connected to the internet.");
            this.asyncInitialization = new Callable(){

                @Override
                public void call() {
                    Log.d((String)"YouTubePlayerView", (String)"Network available. Initializing player.");
                    YouTubePlayerView.this.youTubePlayer.initialize(youTubeListener);
                    YouTubePlayerView.this.initialized = true;
                    YouTubePlayerView.this.asyncInitialization = null;
                }
            };
            return;
        }
        this.youTubePlayer.initialize(youTubeListener);
        this.initialized = true;
    }

    public void addYouTubeListener(YouTubePlayer.YouTubeListener youTubeListener) {
        this.youTubePlayer.addListener(youTubeListener);
    }

    public void removeYouTubeListener(YouTubePlayer.YouTubeListener youTubeListener) {
        this.youTubePlayer.removeListener(youTubeListener);
    }

    public void loadVideo(String videoId, float startSecond) {
        this.youTubePlayer.loadVideo(videoId, startSecond);
        this.playerControlsWrapper.reset();
    }

    public void cueVideo(String videoId, float startSeconds) {
        this.youTubePlayer.cueVideo(videoId, startSeconds);
        this.playerControlsWrapper.reset();
    }

    public void release() {
        this.youTubePlayer.destroy();
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void seekTo(int time) {
        this.youTubePlayer.seekTo(time);
    }

    public void mute() {
        this.youTubePlayer.mute();
    }

    public void unMute() {
        this.youTubePlayer.unMute();
    }

    public void playVideo() {
        this.youTubePlayer.play();
    }

    public void pauseVideo() {
        this.youTubePlayer.pause();
    }

    @Override
    public void onNetworkAvailable() {
        if (!this.initialized && this.asyncInitialization != null) {
            this.asyncInitialization.call();
        } else {
            this.playbackResumer.resume();
        }
    }

    @Override
    public void onNetworkUnavailable() {
    }

    public void showTitle(boolean show) {
        this.playerControlsWrapper.showTitle(show);
    }

    public void setCustomActionRight(Drawable icon, View.OnClickListener clickListener) {
        this.playerControlsWrapper.setCustomActionRight(icon, clickListener);
    }

    public void setCustomActionLeft(Drawable icon, View.OnClickListener clickListener) {
        this.playerControlsWrapper.setCustomActionLeft(icon, clickListener);
    }

    public void showFullScreenButton(boolean show) {
        this.playerControlsWrapper.showFullscreenButton(show);
    }

    public void hideUI(boolean hide) {
        this.playerControlsWrapper.hideUI(hide);
    }
}

