/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer;

import com.pierfrancescosoffritti.youtubeplayer.AbstractYouTubeListener;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayerView;

class PlaybackResumer
extends AbstractYouTubeListener {
    private boolean isPlaying = false;
    private int error = Integer.MIN_VALUE;
    private String videoId;
    private float currentSecond;
    private YouTubePlayerView youTubePlayerView;

    PlaybackResumer(YouTubePlayerView youTubePlayerView) {
        this.youTubePlayerView = youTubePlayerView;
    }

    void resume() {
        if (this.isPlaying && this.error == 1) {
            this.youTubePlayerView.loadVideo(this.videoId, this.currentSecond);
        } else if (!this.isPlaying && this.error == 1) {
            this.youTubePlayerView.cueVideo(this.videoId, this.currentSecond);
        }
        this.error = -1;
    }

    @Override
    public void onStateChange(int state) {
        switch (state) {
            case 0: {
                this.isPlaying = false;
                break;
            }
            case 2: {
                this.isPlaying = false;
                break;
            }
            case 1: {
                this.isPlaying = true;
                break;
            }
        }
    }

    @Override
    public void onError(int error) {
        if (error == 1) {
            this.error = error;
        }
    }

    @Override
    public void onCurrentSecond(float second) {
        this.currentSecond = second;
    }

    @Override
    public void onVideoId(String videoId) {
        this.videoId = videoId;
    }
}

