/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayerBridge;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;

public class YouTubePlayer
extends WebView {
    @NonNull
    private Set<YouTubeListener> youTubeListeners;
    @NonNull
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    protected YouTubePlayer(Context context) {
        this(context, null);
    }

    protected YouTubePlayer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    protected YouTubePlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.youTubeListeners = new HashSet<YouTubeListener>();
    }

    protected void initialize(@Nullable YouTubeListener youTubeListener) {
        if (youTubeListener != null) {
            this.youTubeListeners.add(youTubeListener);
        }
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setCacheMode(2);
        settings.setMediaPlaybackRequiresUserGesture(false);
        this.addJavascriptInterface(new YouTubePlayerBridge(this), "YouTubePlayerBridge");
        this.loadDataWithBaseURL("https://www.youtube.com", this.getVideoPlayerHTML(), "text/html", "utf-8", null);
        this.setWebChromeClient(new WebChromeClient(){

            public Bitmap getDefaultVideoPoster() {
                Bitmap result = super.getDefaultVideoPoster();
                if (result == null) {
                    return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                return result;
            }
        });
    }

    private String getVideoPlayerHTML() {
        try {
            String read;
            InputStream inputStream = this.getResources().openRawResource(R.raw.player);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder("");
            while ((read = bufferedReader.readLine()) != null) {
                sb.append(read).append("\n");
            }
            inputStream.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void loadVideo(final String videoId, final float startSeconds) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                YouTubePlayer.this.loadUrl("javascript:loadVideo('" + videoId + "', " + startSeconds + ")");
            }
        });
    }

    protected void cueVideo(final String videoId, final float startSeconds) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                YouTubePlayer.this.loadUrl("javascript:cueVideo('" + videoId + "', " + startSeconds + ")");
            }
        });
    }

    protected void play() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                YouTubePlayer.this.loadUrl("javascript:playVideo()");
            }
        });
    }

    protected void pause() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                YouTubePlayer.this.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    protected void seekTo(final int time) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                YouTubePlayer.this.loadUrl("javascript:seekTo(" + time + ")");
            }
        });
    }

    @NonNull
    protected Set<YouTubeListener> getListeners() {
        return this.youTubeListeners;
    }

    protected boolean addListener(YouTubeListener listener) {
        return this.youTubeListeners.add(listener);
    }

    protected boolean removeListener(YouTubeListener listener) {
        return this.youTubeListeners.remove(listener);
    }

    public static class Error {
        public static final int INVALID_PARAMENTER_IN_REQUEST = 0;
        public static final int HTML_5_PLAYER = 1;
        public static final int VIDEO_NOT_FOUND = 2;
        public static final int VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER = 3;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PlayerError {
        }
    }

    public static class PlaybackQuality {
        public static final int SMALL = 0;
        public static final int MEDIUM = 1;
        public static final int LARGE = 2;
        public static final int HD720 = 3;
        public static final int HD1080 = 4;
        public static final int HIGH_RES = 5;
        public static final int DEFAULT = -1;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Quality {
        }
    }

    public static class State {
        public static final int UNSTARTED = -1;
        public static final int ENDED = 0;
        public static final int PLAYING = 1;
        public static final int PAUSED = 2;
        public static final int BUFFERING = 3;
        public static final int VIDEO_CUED = 5;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface YouTubePlayerState {
        }
    }

    public static interface YouTubeListener {
        public void onReady();

        public void onStateChange(int var1);

        public void onPlaybackQualityChange(int var1);

        public void onPlaybackRateChange(double var1);

        public void onError(int var1);

        public void onApiChange();

        public void onCurrentSecond(float var1);

        public void onVideoDuration(float var1);

        public void onLog(String var1);

        public void onVideoTitle(String var1);

        public void onVideoId(String var1);
    }
}

