/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Highlighter;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.PointD;
import java.util.ArrayList;
import java.util.List;

public class ChartHighlighter<T extends BarLineScatterCandleBubbleDataProvider>
implements Highlighter {
    protected T mChart;

    public ChartHighlighter(T chart) {
        this.mChart = chart;
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        float xVal = (float)this.getValsForTouch((float)x, (float)y).x;
        Highlight high = this.getHighlightForX(xVal, x, y);
        return high;
    }

    protected PointD getValsForTouch(float x, float y) {
        PointD pos = this.mChart.getTransformer(YAxis.AxisDependency.LEFT).getValuesByTouchPoint(x, y);
        return pos;
    }

    protected Highlight getHighlightForX(float xVal, float x, float y) {
        float rightAxisMinDist;
        List<Highlight> closestValues = this.getHighlightsAtXPos(xVal, x, y);
        if (closestValues.isEmpty()) {
            return null;
        }
        float leftAxisMinDist = this.getMinimumDistance(closestValues, y, YAxis.AxisDependency.LEFT);
        YAxis.AxisDependency axis = leftAxisMinDist < (rightAxisMinDist = this.getMinimumDistance(closestValues, y, YAxis.AxisDependency.RIGHT)) ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT;
        Highlight detail = this.getClosestHighlightByPixel(closestValues, x, y, axis, this.mChart.getMaxHighlightDistance());
        return detail;
    }

    protected float getMinimumDistance(List<Highlight> closestValues, float pos, YAxis.AxisDependency axis) {
        float distance = Float.MAX_VALUE;
        for (int i = 0; i < closestValues.size(); ++i) {
            float tempDistance;
            Highlight high = closestValues.get(i);
            if (high.getAxis() != axis || !((tempDistance = Math.abs(this.getHighlightPos(high) - pos)) < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    protected float getHighlightPos(Highlight h) {
        return h.getYPx();
    }

    protected List<Highlight> getHighlightsAtXPos(float xVal, float x, float y) {
        ArrayList<Highlight> vals = new ArrayList<Highlight>();
        BarLineScatterCandleBubbleData data = this.getData();
        if (data == null) {
            return vals;
        }
        int dataSetCount = data.getDataSetCount();
        for (int i = 0; i < dataSetCount; ++i) {
            Highlight high;
            Object dataSet = data.getDataSetByIndex(i);
            if (!dataSet.isHighlightEnabled() || (high = this.buildHighlight((IDataSet)dataSet, i, xVal, DataSet.Rounding.CLOSEST)) == null) continue;
            vals.add(high);
        }
        return vals;
    }

    protected Highlight buildHighlight(IDataSet set, int dataSetIndex, float xVal, DataSet.Rounding rounding) {
        Object e = set.getEntryForXPos(xVal, rounding);
        if (e == null) {
            return null;
        }
        PointD pixels = this.mChart.getTransformer(set.getAxisDependency()).getPixelsForValues(((Entry)e).getX(), ((BaseEntry)e).getY());
        return new Highlight(((Entry)e).getX(), ((BaseEntry)e).getY(), (float)pixels.x, (float)pixels.y, dataSetIndex, set.getAxisDependency());
    }

    public Highlight getClosestHighlightByPixel(List<Highlight> closestValues, float x, float y, YAxis.AxisDependency axis, float minSelectionDistance) {
        Highlight closest = null;
        float distance = minSelectionDistance;
        for (int i = 0; i < closestValues.size(); ++i) {
            float cDistance;
            Highlight high = closestValues.get(i);
            if (axis != null && high.getAxis() != axis || !((cDistance = this.getDistance(x, y, high.getXPx(), high.getYPx())) < distance)) continue;
            closest = high;
            distance = cDistance;
        }
        return closest;
    }

    protected float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    protected BarLineScatterCandleBubbleData getData() {
        return this.mChart.getData();
    }
}

