/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LegendRenderer
extends Renderer {
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected Legend mLegend;

    public LegendRenderer(ViewPortHandler viewPortHandler, Legend legend) {
        super(viewPortHandler);
        this.mLegend = legend;
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public void computeLegend(ChartData<?> data) {
        Typeface tf;
        if (!this.mLegend.isLegendCustom()) {
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<Integer> colors = new ArrayList<Integer>();
            for (int i = 0; i < data.getDataSetCount(); ++i) {
                Object dataSet = data.getDataSetByIndex(i);
                List<Integer> clrs = dataSet.getColors();
                int entryCount = dataSet.getEntryCount();
                if (dataSet instanceof IBarDataSet && ((IBarDataSet)dataSet).isStacked()) {
                    IBarDataSet bds = (IBarDataSet)dataSet;
                    String[] sLabels = bds.getStackLabels();
                    for (int j = 0; j < clrs.size() && j < bds.getStackSize(); ++j) {
                        labels.add(sLabels[j % sLabels.length]);
                        colors.add(clrs.get(j));
                    }
                    if (bds.getLabel() == null) continue;
                    colors.add(1122868);
                    labels.add(bds.getLabel());
                    continue;
                }
                if (dataSet instanceof IPieDataSet) {
                    IPieDataSet pds = (IPieDataSet)dataSet;
                    for (int j = 0; j < clrs.size() && j < entryCount; ++j) {
                        labels.add(((PieEntry)pds.getEntryForIndex(j)).getLabel());
                        colors.add(clrs.get(j));
                    }
                    if (pds.getLabel() == null) continue;
                    colors.add(1122868);
                    labels.add(pds.getLabel());
                    continue;
                }
                if (dataSet instanceof ICandleDataSet && ((ICandleDataSet)dataSet).getDecreasingColor() != 0x112233) {
                    int decreasingColor = ((ICandleDataSet)dataSet).getDecreasingColor();
                    colors.add(decreasingColor);
                    int increasingColor = ((ICandleDataSet)dataSet).getIncreasingColor();
                    colors.add(increasingColor);
                    labels.add(null);
                    labels.add(dataSet.getLabel());
                    continue;
                }
                for (int j = 0; j < clrs.size() && j < entryCount; ++j) {
                    if (j < clrs.size() - 1 && j < entryCount - 1) {
                        labels.add(null);
                    } else {
                        String label = data.getDataSetByIndex(i).getLabel();
                        labels.add(label);
                    }
                    colors.add(clrs.get(j));
                }
            }
            if (this.mLegend.getExtraColors() != null && this.mLegend.getExtraLabels() != null) {
                for (int color : this.mLegend.getExtraColors()) {
                    colors.add(color);
                }
                Collections.addAll(labels, this.mLegend.getExtraLabels());
            }
            this.mLegend.setComputedColors(colors);
            this.mLegend.setComputedLabels(labels);
        }
        if ((tf = this.mLegend.getTypeface()) != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        this.mLegend.calculateDimensions(this.mLegendLabelPaint, this.mViewPortHandler);
    }

    public void renderLegend(Canvas c) {
        if (!this.mLegend.isEnabled()) {
            return;
        }
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        float labelLineHeight = Utils.getLineHeight(this.mLegendLabelPaint);
        float labelLineSpacing = Utils.getLineSpacing(this.mLegendLabelPaint) + this.mLegend.getYEntrySpace();
        float formYOffset = labelLineHeight - (float)Utils.calcTextHeight(this.mLegendLabelPaint, "ABC") / 2.0f;
        String[] labels = this.mLegend.getLabels();
        int[] colors = this.mLegend.getColors();
        float formToTextSpace = this.mLegend.getFormToTextSpace();
        float xEntrySpace = this.mLegend.getXEntrySpace();
        Legend.LegendOrientation orientation = this.mLegend.getOrientation();
        Legend.LegendHorizontalAlignment horizontalAlignment = this.mLegend.getHorizontalAlignment();
        Legend.LegendVerticalAlignment verticalAlignment = this.mLegend.getVerticalAlignment();
        Legend.LegendDirection direction = this.mLegend.getDirection();
        float formSize = this.mLegend.getFormSize();
        float stackSpace = this.mLegend.getStackSpace();
        float yoffset = this.mLegend.getYOffset();
        float xoffset = this.mLegend.getXOffset();
        float originPosX = 0.0f;
        switch (horizontalAlignment) {
            case LEFT: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? xoffset : this.mViewPortHandler.contentLeft() + xoffset;
                if (direction != Legend.LegendDirection.RIGHT_TO_LEFT) break;
                originPosX += this.mLegend.mNeededWidth;
                break;
            }
            case RIGHT: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? this.mViewPortHandler.getChartWidth() - xoffset : this.mViewPortHandler.contentRight() - xoffset;
                if (direction != Legend.LegendDirection.LEFT_TO_RIGHT) break;
                originPosX -= this.mLegend.mNeededWidth;
                break;
            }
            case CENTER: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? this.mViewPortHandler.getChartWidth() / 2.0f : this.mViewPortHandler.contentLeft() + this.mViewPortHandler.contentWidth() / 2.0f;
                originPosX += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? xoffset : -xoffset;
                if (orientation != Legend.LegendOrientation.VERTICAL) break;
                originPosX = (float)((double)originPosX + (direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (double)(-this.mLegend.mNeededWidth) / 2.0 + (double)xoffset : (double)this.mLegend.mNeededWidth / 2.0 - (double)xoffset));
            }
        }
        switch (orientation) {
            case HORIZONTAL: {
                FSize[] calculatedLineSizes = this.mLegend.getCalculatedLineSizes();
                FSize[] calculatedLabelSizes = this.mLegend.getCalculatedLabelSizes();
                Boolean[] calculatedLabelBreakPoints = this.mLegend.getCalculatedLabelBreakPoints();
                float posX = originPosX;
                float posY = 0.0f;
                switch (verticalAlignment) {
                    case TOP: {
                        posY = yoffset;
                        break;
                    }
                    case BOTTOM: {
                        posY = this.mViewPortHandler.getChartHeight() - yoffset - this.mLegend.mNeededHeight;
                        break;
                    }
                    case CENTER: {
                        posY = (this.mViewPortHandler.getChartHeight() - this.mLegend.mNeededHeight) / 2.0f + yoffset;
                    }
                }
                int lineIndex = 0;
                int count = labels.length;
                for (int i = 0; i < count; ++i) {
                    boolean isStacked;
                    if (i < calculatedLabelBreakPoints.length && calculatedLabelBreakPoints[i].booleanValue()) {
                        posX = originPosX;
                        posY += labelLineHeight + labelLineSpacing;
                    }
                    if (posX == originPosX && horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER && lineIndex < calculatedLineSizes.length) {
                        posX += (direction == Legend.LegendDirection.RIGHT_TO_LEFT ? calculatedLineSizes[lineIndex].width : -calculatedLineSizes[lineIndex].width) / 2.0f;
                        ++lineIndex;
                    }
                    boolean drawingForm = colors[i] != 1122868;
                    boolean bl = isStacked = labels[i] == null;
                    if (drawingForm) {
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= formSize;
                        }
                        this.drawForm(c, posX, posY + formYOffset, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (!isStacked) {
                        if (drawingForm) {
                            posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -formToTextSpace : formToTextSpace;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= calculatedLabelSizes[i].width;
                        }
                        this.drawLabel(c, posX, posY + labelLineHeight, labels[i]);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += calculatedLabelSizes[i].width;
                        }
                        posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -xEntrySpace : xEntrySpace;
                        continue;
                    }
                    posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -stackSpace : stackSpace;
                }
                break;
            }
            case VERTICAL: {
                float stack = 0.0f;
                boolean wasStacked = false;
                float posY = 0.0f;
                switch (verticalAlignment) {
                    case TOP: {
                        posY = horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? 0.0f : this.mViewPortHandler.contentTop();
                        posY += yoffset;
                        break;
                    }
                    case BOTTOM: {
                        posY = horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? this.mViewPortHandler.getChartHeight() : this.mViewPortHandler.contentBottom();
                        posY -= this.mLegend.mNeededHeight + yoffset;
                        break;
                    }
                    case CENTER: {
                        posY = this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f + this.mLegend.getYOffset();
                    }
                }
                for (int i = 0; i < labels.length; ++i) {
                    Boolean drawingForm = colors[i] != 1122868;
                    float posX = originPosX;
                    if (drawingForm.booleanValue()) {
                        posX = direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (posX += stack) : (posX -= formSize - stack);
                        this.drawForm(c, posX, posY + formYOffset, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (labels[i] != null) {
                        if (drawingForm.booleanValue() && !wasStacked) {
                            posX += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? formToTextSpace : -formToTextSpace;
                        } else if (wasStacked) {
                            posX = originPosX;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        if (!wasStacked) {
                            this.drawLabel(c, posX, posY + labelLineHeight, labels[i]);
                        } else {
                            this.drawLabel(c, posX, (posY += labelLineHeight + labelLineSpacing) + labelLineHeight, labels[i]);
                        }
                        posY += labelLineHeight + labelLineSpacing;
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
        }
    }

    protected void drawForm(Canvas c, float x, float y, int index, Legend legend) {
        if (legend.getColors()[index] == 1122868) {
            return;
        }
        this.mLegendFormPaint.setColor(legend.getColors()[index]);
        float formsize = legend.getFormSize();
        float half = formsize / 2.0f;
        switch (legend.getForm()) {
            case CIRCLE: {
                c.drawCircle(x + half, y, half, this.mLegendFormPaint);
                break;
            }
            case SQUARE: {
                c.drawRect(x, y - half, x + formsize, y + half, this.mLegendFormPaint);
                break;
            }
            case LINE: {
                c.drawLine(x, y, x + formsize, y, this.mLegendFormPaint);
            }
        }
    }

    protected void drawLabel(Canvas c, float x, float y, String label) {
        c.drawText(label, x, y, this.mLegendLabelPaint);
    }
}

