/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Highlighter;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.CombinedDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;
import java.util.List;

public class CombinedHighlighter
extends ChartHighlighter<CombinedDataProvider>
implements Highlighter {
    protected BarHighlighter barHighlighter;

    public CombinedHighlighter(CombinedDataProvider chart, BarDataProvider barChart) {
        super(chart);
        this.barHighlighter = barChart.getBarData() == null ? null : new BarHighlighter(barChart);
    }

    @Override
    protected List<Highlight> getHighlightsAtXPos(float xVal, float x, float y) {
        ArrayList<Highlight> vals = new ArrayList<Highlight>();
        List<BarLineScatterCandleBubbleData> dataObjects = ((CombinedDataProvider)this.mChart).getCombinedData().getAllData();
        for (int i = 0; i < dataObjects.size(); ++i) {
            ChartData dataObject = dataObjects.get(i);
            if (this.barHighlighter != null && dataObject instanceof BarData) {
                Highlight high = this.barHighlighter.getHighlight(x, y);
                if (high == null) continue;
                high.setDataIndex(i);
                vals.add(high);
                continue;
            }
            int dataSetCount = dataObject.getDataSetCount();
            for (int j = 0; j < dataSetCount; ++j) {
                Object dataSet = dataObjects.get(i).getDataSetByIndex(j);
                if (!dataSet.isHighlightEnabled()) continue;
                Highlight s1 = this.buildHighlight((IDataSet)dataSet, j, xVal, DataSet.Rounding.CLOSEST);
                s1.setDataIndex(i);
                vals.add(s1);
            }
        }
        return vals;
    }
}

