/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Color;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class BubbleDataSet
extends BarLineScatterCandleBubbleDataSet<BubbleEntry> {
    protected float mXMax;
    protected float mXMin;
    protected float mMaxSize;
    private float mHighlightCircleWidth = 2.5f;

    public BubbleDataSet(List<BubbleEntry> yVals, String label) {
        super(yVals, label);
    }

    public void setHighlightCircleWidth(float width) {
        this.mHighlightCircleWidth = Utils.convertDpToPixel(width);
    }

    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    public void setColor(int color, int alpha) {
        super.setColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
    }

    @Override
    protected void calcMinMax(int start, int end) {
        if (this.mYVals.size() == 0) {
            return;
        }
        List entries = this.getYVals();
        int endValue = end == 0 ? this.mYVals.size() - 1 : end;
        this.mLastStart = start;
        this.mLastEnd = endValue;
        this.mYMin = this.yMin((BubbleEntry)entries.get(start));
        this.mYMax = this.yMax((BubbleEntry)entries.get(start));
        for (int i = start; i <= endValue; ++i) {
            float size;
            BubbleEntry entry = (BubbleEntry)entries.get(i);
            float ymin = this.yMin(entry);
            float ymax = this.yMax(entry);
            if (ymin < this.mYMin) {
                this.mYMin = ymin;
            }
            if (ymax > this.mYMax) {
                this.mYMax = ymax;
            }
            float xmin = this.xMin(entry);
            float xmax = this.xMax(entry);
            if (xmin < this.mXMin) {
                this.mXMin = xmin;
            }
            if (xmax > this.mXMax) {
                this.mXMax = xmax;
            }
            if (!((size = this.largestSize(entry)) > this.mMaxSize)) continue;
            this.mMaxSize = size;
        }
    }

    @Override
    public DataSet<BubbleEntry> copy() {
        ArrayList<BubbleEntry> yVals = new ArrayList<BubbleEntry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((BubbleEntry)this.mYVals.get(i)).copy());
        }
        BubbleDataSet copied = new BubbleDataSet((List<BubbleEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    public float getXMax() {
        return this.mXMax;
    }

    public float getXMin() {
        return this.mXMin;
    }

    public float getMaxSize() {
        return this.mMaxSize;
    }

    private float yMin(BubbleEntry entry) {
        return entry.getVal();
    }

    private float yMax(BubbleEntry entry) {
        return entry.getVal();
    }

    private float xMin(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float xMax(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float largestSize(BubbleEntry entry) {
        return entry.getSize();
    }
}

