/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarLineScatterCandleData;
import com.github.mikephil.charting.data.BarLineScatterCandleDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class BarLineChartTouchListener
extends ChartTouchListener<BarLineChartBase<? extends BarLineScatterCandleData<? extends BarLineScatterCandleDataSet<? extends Entry>>>> {
    private Matrix mMatrix = new Matrix();
    private Matrix mSavedMatrix = new Matrix();
    private PointF mTouchStartPoint = new PointF();
    private PointF mTouchPointCenter = new PointF();
    private float mSavedXDist = 1.0f;
    private float mSavedYDist = 1.0f;
    private float mSavedDist = 1.0f;
    private DataSet<?> mClosestDataSetToTouch;
    private VelocityTracker mVelocityTracker;
    private long mDecelerationLastTime = 0L;
    private PointF mDecelerationCurrentPoint = new PointF();
    private PointF mDecelerationVelocity = new PointF();

    public BarLineChartTouchListener(BarLineChartBase<? extends BarLineScatterCandleData<? extends BarLineScatterCandleDataSet<? extends Entry>>> chart, Matrix touchMatrix) {
        super(chart);
        this.mMatrix = touchMatrix;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        if (event.getActionMasked() == 3 && this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mTouchMode == 0) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (!(((BarLineChartBase)this.mChart).isDragEnabled() || ((BarLineChartBase)this.mChart).isScaleXEnabled() || ((BarLineChartBase)this.mChart).isScaleYEnabled())) {
            return true;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.stopDeceleration();
                this.saveTouchStart(event);
                break;
            }
            case 5: {
                if (event.getPointerCount() < 2) break;
                ((BarLineChartBase)this.mChart).disableScroll();
                this.saveTouchStart(event);
                this.mSavedXDist = BarLineChartTouchListener.getXDist(event);
                this.mSavedYDist = BarLineChartTouchListener.getYDist(event);
                this.mSavedDist = BarLineChartTouchListener.spacing(event);
                if (this.mSavedDist > 10.0f) {
                    this.mTouchMode = ((BarLineChartBase)this.mChart).isPinchZoomEnabled() ? 4 : (this.mSavedXDist > this.mSavedYDist ? 2 : 3);
                }
                BarLineChartTouchListener.midPoint(this.mTouchPointCenter, event);
                break;
            }
            case 2: {
                if (this.mTouchMode == 1) {
                    ((BarLineChartBase)this.mChart).disableScroll();
                    this.performDrag(event);
                    break;
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4) {
                    ((BarLineChartBase)this.mChart).disableScroll();
                    if (!((BarLineChartBase)this.mChart).isScaleXEnabled() && !((BarLineChartBase)this.mChart).isScaleYEnabled()) break;
                    this.performZoom(event);
                    break;
                }
                if (this.mTouchMode != 0 || !(Math.abs(BarLineChartTouchListener.distance(event.getX(), this.mTouchStartPoint.x, event.getY(), this.mTouchStartPoint.y)) > 5.0f)) break;
                if (((BarLineChartBase)this.mChart).hasNoDragOffset()) {
                    if (!((BarLineChartBase)this.mChart).isFullyZoomedOut() && ((BarLineChartBase)this.mChart).isDragEnabled()) {
                        this.mTouchMode = 1;
                        break;
                    }
                    if (!((BarLineChartBase)this.mChart).isHighlightPerDragEnabled()) break;
                    this.performHighlightDrag(event);
                    break;
                }
                if (!((BarLineChartBase)this.mChart).isDragEnabled()) break;
                this.mTouchMode = 1;
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                int pointerId = event.getPointerId(0);
                velocityTracker.computeCurrentVelocity(1000, (float)Utils.getMaximumFlingVelocity());
                float velocityY = velocityTracker.getYVelocity(pointerId);
                float velocityX = velocityTracker.getXVelocity(pointerId);
                if ((Math.abs(velocityX) > (float)Utils.getMinimumFlingVelocity() || Math.abs(velocityY) > (float)Utils.getMinimumFlingVelocity()) && this.mTouchMode == 1 && ((BarLineChartBase)this.mChart).isDragDecelerationEnabled()) {
                    this.stopDeceleration();
                    this.mDecelerationLastTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDecelerationCurrentPoint = new PointF(event.getX(), event.getY());
                    this.mDecelerationVelocity = new PointF(velocityX, velocityY);
                    Utils.postInvalidateOnAnimation((View)this.mChart);
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4 || this.mTouchMode == 5) {
                    ((BarLineChartBase)this.mChart).calculateOffsets();
                    ((BarLineChartBase)this.mChart).postInvalidate();
                }
                this.mTouchMode = 0;
                ((BarLineChartBase)this.mChart).enableScroll();
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 6: {
                Utils.velocityTrackerPointerUpCleanUpIfNecessary(event, this.mVelocityTracker);
                this.mTouchMode = 5;
                break;
            }
            case 3: {
                this.mTouchMode = 0;
            }
        }
        this.mMatrix = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, true);
        return true;
    }

    private void saveTouchStart(MotionEvent event) {
        this.mSavedMatrix.set(this.mMatrix);
        this.mTouchStartPoint.set(event.getX(), event.getY());
        this.mClosestDataSetToTouch = ((BarLineChartBase)this.mChart).getDataSetByTouchPoint(event.getX(), event.getY());
    }

    private void performDrag(MotionEvent event) {
        float dY;
        float dX;
        this.mMatrix.set(this.mSavedMatrix);
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (((BarLineChartBase)this.mChart).isAnyAxisInverted() && this.mClosestDataSetToTouch != null && ((BarLineChartBase)this.mChart).getAxis(this.mClosestDataSetToTouch.getAxisDependency()).isInverted()) {
            if (this.mChart instanceof HorizontalBarChart) {
                dX = -(event.getX() - this.mTouchStartPoint.x);
                dY = event.getY() - this.mTouchStartPoint.y;
            } else {
                dX = event.getX() - this.mTouchStartPoint.x;
                dY = -(event.getY() - this.mTouchStartPoint.y);
            }
        } else {
            dX = event.getX() - this.mTouchStartPoint.x;
            dY = event.getY() - this.mTouchStartPoint.y;
        }
        this.mMatrix.postTranslate(dX, dY);
        if (l != null) {
            l.onChartTranslate(event, dX, dY);
        }
    }

    private void performZoom(MotionEvent event) {
        if (event.getPointerCount() >= 2) {
            OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
            float totalDist = BarLineChartTouchListener.spacing(event);
            if (totalDist > 10.0f) {
                PointF t = this.getTrans(this.mTouchPointCenter.x, this.mTouchPointCenter.y);
                if (this.mTouchMode == 4) {
                    float scaleY;
                    float scale = totalDist / this.mSavedDist;
                    boolean isZoomingOut = scale < 1.0f;
                    boolean canZoomMoreX = isZoomingOut ? ((BarLineChartBase)this.mChart).getViewPortHandler().canZoomOutMoreX() : ((BarLineChartBase)this.mChart).getViewPortHandler().canZoomInMoreX();
                    float scaleX = ((BarLineChartBase)this.mChart).isScaleXEnabled() ? scale : 1.0f;
                    float f = scaleY = ((BarLineChartBase)this.mChart).isScaleYEnabled() ? scale : 1.0f;
                    if (((BarLineChartBase)this.mChart).isScaleYEnabled() || canZoomMoreX) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(scaleX, scaleY, t.x, t.y);
                        if (l != null) {
                            l.onChartScale(event, scaleX, scaleY);
                        }
                    }
                } else if (this.mTouchMode == 2 && ((BarLineChartBase)this.mChart).isScaleXEnabled()) {
                    boolean canZoomMoreX;
                    float xDist = BarLineChartTouchListener.getXDist(event);
                    float scaleX = xDist / this.mSavedXDist;
                    boolean isZoomingOut = scaleX < 1.0f;
                    boolean bl = canZoomMoreX = isZoomingOut ? ((BarLineChartBase)this.mChart).getViewPortHandler().canZoomOutMoreX() : ((BarLineChartBase)this.mChart).getViewPortHandler().canZoomInMoreX();
                    if (canZoomMoreX) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(scaleX, 1.0f, t.x, t.y);
                        if (l != null) {
                            l.onChartScale(event, scaleX, 1.0f);
                        }
                    }
                } else if (this.mTouchMode == 3 && ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                    float yDist = BarLineChartTouchListener.getYDist(event);
                    float scaleY = yDist / this.mSavedYDist;
                    this.mMatrix.set(this.mSavedMatrix);
                    this.mMatrix.postScale(1.0f, scaleY, t.x, t.y);
                    if (l != null) {
                        l.onChartScale(event, 1.0f, scaleY);
                    }
                }
            }
        }
    }

    private void performHighlight(MotionEvent e) {
        Highlight h = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(e.getX(), e.getY());
        if (h == null || h.equalTo(this.mLastHighlighted)) {
            ((BarLineChartBase)this.mChart).highlightTouch(null);
            this.mLastHighlighted = null;
        } else {
            this.mLastHighlighted = h;
            ((BarLineChartBase)this.mChart).highlightTouch(h);
        }
    }

    private void performHighlightDrag(MotionEvent e) {
        Highlight h = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(e.getX(), e.getY());
        if (h != null && !h.equalTo(this.mLastHighlighted)) {
            this.mLastHighlighted = h;
            ((BarLineChartBase)this.mChart).highlightTouch(h);
        }
    }

    private static void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    private static float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private static float getXDist(MotionEvent e) {
        float x = Math.abs(e.getX(0) - e.getX(1));
        return x;
    }

    private static float getYDist(MotionEvent e) {
        float y = Math.abs(e.getY(0) - e.getY(1));
        return y;
    }

    public PointF getTrans(float x, float y) {
        ViewPortHandler vph = ((BarLineChartBase)this.mChart).getViewPortHandler();
        float xTrans = x - vph.offsetLeft();
        float yTrans = 0.0f;
        yTrans = ((BarLineChartBase)this.mChart).isAnyAxisInverted() && this.mClosestDataSetToTouch != null && ((BarLineChartBase)this.mChart).isInverted(this.mClosestDataSetToTouch.getAxisDependency()) ? -(y - vph.offsetTop()) : -((float)((BarLineChartBase)this.mChart).getMeasuredHeight() - y - vph.offsetBottom());
        return new PointF(xTrans, yTrans);
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public boolean onDoubleTap(MotionEvent e) {
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartDoubleTapped(e);
            return super.onDoubleTap(e);
        }
        if (((BarLineChartBase)this.mChart).isDoubleTapToZoomEnabled()) {
            PointF trans = this.getTrans(e.getX(), e.getY());
            ((BarLineChartBase)this.mChart).zoom(((BarLineChartBase)this.mChart).isScaleXEnabled() ? 1.4f : 1.0f, ((BarLineChartBase)this.mChart).isScaleYEnabled() ? 1.4f : 1.0f, trans.x, trans.y);
            if (((BarLineChartBase)this.mChart).isLogEnabled()) {
                Log.i((String)"BarlineChartTouch", (String)("Double-Tap, Zooming In, x: " + trans.x + ", y: " + trans.y));
            }
        }
        return super.onDoubleTap(e);
    }

    public void onLongPress(MotionEvent e) {
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartLongPressed(e);
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.performHighlight(e);
        return super.onSingleTapUp(e);
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartSingleTapped(e);
        }
        return super.onSingleTapConfirmed(e);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartFling(e1, e2, velocityX, velocityY);
        }
        return super.onFling(e1, e2, velocityX, velocityY);
    }

    public void stopDeceleration() {
        this.mDecelerationVelocity = new PointF(0.0f, 0.0f);
    }

    public void computeScroll() {
        if (this.mDecelerationVelocity.x == 0.0f && this.mDecelerationVelocity.y == 0.0f) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDecelerationVelocity.x *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        this.mDecelerationVelocity.y *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        float timeInterval = (float)(currentTime - this.mDecelerationLastTime) / 1000.0f;
        float distanceX = this.mDecelerationVelocity.x * timeInterval;
        float distanceY = this.mDecelerationVelocity.y * timeInterval;
        this.mDecelerationCurrentPoint.x += distanceX;
        this.mDecelerationCurrentPoint.y += distanceY;
        MotionEvent event = MotionEvent.obtain((long)currentTime, (long)currentTime, (int)2, (float)this.mDecelerationCurrentPoint.x, (float)this.mDecelerationCurrentPoint.y, (int)0);
        this.performDrag(event);
        event.recycle();
        this.mMatrix = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, false);
        this.mDecelerationLastTime = currentTime;
        if ((double)Math.abs(this.mDecelerationVelocity.x) >= 0.01 || (double)Math.abs(this.mDecelerationVelocity.y) >= 0.01) {
            Utils.postInvalidateOnAnimation((View)this.mChart);
        } else {
            ((BarLineChartBase)this.mChart).calculateOffsets();
            ((BarLineChartBase)this.mChart).postInvalidate();
            this.stopDeceleration();
        }
    }
}

