/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.listener.PieRadarChartTouchListener;
import com.github.mikephil.charting.utils.SelectionDetail;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class PieRadarChartBase<T extends ChartData<? extends DataSet<? extends Entry>>>
extends Chart<T> {
    private float mRotationAngle = 270.0f;
    private float mRawRotationAngle = 270.0f;
    protected boolean mRotateEnabled = true;

    public PieRadarChartBase(Context context) {
        super(context);
    }

    public PieRadarChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieRadarChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mChartTouchListener = new PieRadarChartTouchListener(this);
    }

    @Override
    protected void calcMinMax() {
        this.mDeltaX = this.mData.getXVals().size() - 1;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mTouchEnabled && this.mChartTouchListener != null) {
            return this.mChartTouchListener.onTouch((View)this, event);
        }
        return super.onTouchEvent(event);
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof PieRadarChartTouchListener) {
            ((PieRadarChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax();
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    public void calculateOffsets() {
        XAxis x;
        float legendLeft = 0.0f;
        float legendRight = 0.0f;
        float legendBottom = 0.0f;
        float legendTop = 0.0f;
        if (this.mLegend != null && this.mLegend.isEnabled()) {
            PointF c;
            float legendHeight;
            float legendWidth;
            float spacing;
            float fullLegendWidth = Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getFormSize() + this.mLegend.getFormToTextSpace();
            if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER) {
                spacing = Utils.convertDpToPixel(13.0f);
                legendRight = fullLegendWidth + spacing;
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
                spacing = Utils.convertDpToPixel(8.0f);
                legendWidth = fullLegendWidth + spacing;
                legendHeight = this.mLegend.mNeededHeight + this.mLegend.mTextHeightMax;
                c = this.getCenter();
                PointF bottomRight = new PointF((float)this.getWidth() - legendWidth + 15.0f, legendHeight + 15.0f);
                float distLegend = this.distanceToCenter(bottomRight.x, bottomRight.y);
                PointF reference = this.getPosition(c, this.getRadius(), this.getAngleForPoint(bottomRight.x, bottomRight.y));
                float distReference = this.distanceToCenter(reference.x, reference.y);
                float min = Utils.convertDpToPixel(5.0f);
                if (distLegend < distReference) {
                    float diff = distReference - distLegend;
                    legendRight = min + diff;
                }
                if (bottomRight.y >= c.y && (float)this.getHeight() - legendWidth > (float)this.getWidth()) {
                    legendRight = legendWidth;
                }
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER) {
                spacing = Utils.convertDpToPixel(13.0f);
                legendLeft = fullLegendWidth + spacing;
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART) {
                spacing = Utils.convertDpToPixel(8.0f);
                legendWidth = fullLegendWidth + spacing;
                legendHeight = this.mLegend.mNeededHeight + this.mLegend.mTextHeightMax;
                c = this.getCenter();
                PointF bottomLeft = new PointF(legendWidth - 15.0f, legendHeight + 15.0f);
                float distLegend = this.distanceToCenter(bottomLeft.x, bottomLeft.y);
                PointF reference = this.getPosition(c, this.getRadius(), this.getAngleForPoint(bottomLeft.x, bottomLeft.y));
                float distReference = this.distanceToCenter(reference.x, reference.y);
                float min = Utils.convertDpToPixel(5.0f);
                if (distLegend < distReference) {
                    float diff = distReference - distLegend;
                    legendLeft = min + diff;
                }
                if (bottomLeft.y >= c.y && (float)this.getHeight() - legendWidth > (float)this.getWidth()) {
                    legendLeft = legendWidth;
                }
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                float yOffset = this.getRequiredBottomOffset();
                legendBottom = Math.min(this.mLegend.mNeededHeight + yOffset, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
            }
            legendLeft += this.getRequiredBaseOffset();
            legendRight += this.getRequiredBaseOffset();
            legendTop += this.getRequiredBaseOffset();
        }
        float min = Utils.convertDpToPixel(10.0f);
        if (this instanceof RadarChart && (x = ((RadarChart)this).getXAxis()).isEnabled()) {
            min = Math.max(Utils.convertDpToPixel(10.0f), (float)x.mLabelWidth);
        }
        float offsetLeft = Math.max(min, legendLeft += this.getExtraLeftOffset());
        float offsetTop = Math.max(min, legendTop += this.getExtraTopOffset());
        float offsetRight = Math.max(min, legendRight += this.getExtraRightOffset());
        float offsetBottom = Math.max(min, Math.max(this.getRequiredBaseOffset(), legendBottom += this.getExtraBottomOffset()));
        this.mViewPortHandler.restrainViewPort(offsetLeft, offsetTop, offsetRight, offsetBottom);
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom));
        }
    }

    public float getAngleForPoint(float x, float y) {
        PointF c = this.getCenterOffsets();
        double tx = x - c.x;
        double ty = y - c.y;
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > c.x) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    protected PointF getPosition(PointF center, float dist, float angle) {
        PointF p = new PointF((float)((double)center.x + (double)dist * Math.cos(Math.toRadians(angle))), (float)((double)center.y + (double)dist * Math.sin(Math.toRadians(angle))));
        return p;
    }

    public float distanceToCenter(float x, float y) {
        PointF c = this.getCenterOffsets();
        float dist = 0.0f;
        float xDist = 0.0f;
        float yDist = 0.0f;
        xDist = x > c.x ? x - c.x : c.x - x;
        yDist = y > c.y ? y - c.y : c.y - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        return dist;
    }

    public abstract int getIndexForAngle(float var1);

    public void setRotationAngle(float angle) {
        this.mRawRotationAngle = angle;
        this.mRotationAngle = Utils.getNormalizedAngle(this.mRawRotationAngle);
    }

    public float getRawRotationAngle() {
        return this.mRawRotationAngle;
    }

    public float getRotationAngle() {
        return this.mRotationAngle;
    }

    public void setRotationEnabled(boolean enabled) {
        this.mRotateEnabled = enabled;
    }

    public boolean isRotationEnabled() {
        return this.mRotateEnabled;
    }

    public float getDiameter() {
        RectF content = this.mViewPortHandler.getContentRect();
        return Math.min(content.width(), content.height());
    }

    public abstract float getRadius();

    protected abstract float getRequiredBottomOffset();

    protected abstract float getRequiredBaseOffset();

    @Override
    public float getYChartMax() {
        return 0.0f;
    }

    @Override
    public float getYChartMin() {
        return 0.0f;
    }

    public List<SelectionDetail> getSelectionDetailsAtIndex(int xIndex) {
        ArrayList<SelectionDetail> vals = new ArrayList<SelectionDetail>();
        for (int i = 0; i < this.mData.getDataSetCount(); ++i) {
            Object dataSet = this.mData.getDataSetByIndex(i);
            float yVal = ((DataSet)dataSet).getYValForXIndex(xIndex);
            if (yVal == Float.NaN) continue;
            vals.add(new SelectionDetail(yVal, i, (DataSet<?>)dataSet));
        }
        return vals;
    }

    @SuppressLint(value={"NewApi"})
    public void spin(int durationmillis, float fromangle, float toangle, Easing.EasingOption easing) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.setRotationAngle(fromangle);
        ObjectAnimator spinAnimator = ObjectAnimator.ofFloat((Object)this, (String)"rotationAngle", (float[])new float[]{fromangle, toangle});
        spinAnimator.setDuration((long)durationmillis);
        spinAnimator.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easing));
        spinAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PieRadarChartBase.this.postInvalidate();
            }
        });
        spinAnimator.start();
    }
}

