/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Color;
import android.graphics.DashPathEffect;
import com.github.mikephil.charting.utils.Utils;

public class LimitLine {
    private float mLimit = 0.0f;
    private float mLineWidth = 2.0f;
    private int mLineColor = Color.rgb((int)237, (int)91, (int)91);
    private DashPathEffect mDashPathEffect = null;

    public LimitLine(float limit) {
        this.mLimit = limit;
    }

    public float getLimit() {
        return this.mLimit;
    }

    public void setLineWidth(float width) {
        if (width < 0.2f) {
            width = 0.2f;
        }
        if (width > 12.0f) {
            width = 12.0f;
        }
        this.mLineWidth = Utils.convertDpToPixel(width);
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setLineColor(int color) {
        this.mLineColor = color;
    }

    public int getLineColor() {
        return this.mLineColor;
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mDashPathEffect = new DashPathEffect(new float[]{lineLength, spaceLength}, phase);
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    public boolean isDashedLineEnabled() {
        return this.mDashPathEffect != null;
    }

    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }
}

