/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class Legend {
    private float mLegendOffsetBottom = 12.0f;
    private float mLegendOffsetRight = 12.0f;
    private float mLegendOffsetLeft = 12.0f;
    private float mLegendOffsetTop = 12.0f;
    private int[] mColors;
    private String[] mLegendLabels;
    private LegendPosition mPosition = LegendPosition.BELOW_CHART_LEFT;
    private LegendForm mShape = LegendForm.SQUARE;
    private Typeface mTypeface = null;
    private float mTextSize = 9.0f;
    private int mTextColor = -16777216;
    private float mFormSize = Utils.convertDpToPixel(8.0f);
    private float mXEntrySpace = Utils.convertDpToPixel(6.0f);
    private float mYEntrySpace = Utils.convertDpToPixel(5.0f);
    private float mFormToTextSpace = Utils.convertDpToPixel(5.0f);
    private float mStackSpace = 3.0f;

    public Legend() {
        this.mTextSize = Utils.convertDpToPixel(9.0f);
        this.mStackSpace = Utils.convertDpToPixel(3.0f);
    }

    public Legend(int[] colors, String[] labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = colors;
        this.mLegendLabels = labels;
    }

    public Legend(ArrayList<Integer> colors, ArrayList<String> labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.size() != labels.size()) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = Utils.convertIntegers(colors);
        this.mLegendLabels = Utils.convertStrings(labels);
    }

    public int getMaximumEntryLength(Paint p) {
        int max = 0;
        for (int i = 0; i < this.mLegendLabels.length; ++i) {
            int length;
            if (this.mLegendLabels[i] == null || (length = Utils.calcTextWidth(p, this.mLegendLabels[i])) <= max) continue;
            max = length;
        }
        return max + (int)this.mFormSize;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public String[] getLegendLabels() {
        return this.mLegendLabels;
    }

    public void setLegendLabels(String[] labels) {
        if (this.mColors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mLegendLabels = labels;
    }

    public LegendPosition getPosition() {
        return this.mPosition;
    }

    public void setPosition(LegendPosition pos) {
        this.mPosition = pos;
    }

    public LegendForm getForm() {
        return this.mShape;
    }

    public void setForm(LegendForm shape) {
        this.mShape = shape;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(Typeface tf) {
        this.mTypeface = tf;
    }

    public void setFormSize(float size) {
        this.mFormSize = Utils.convertDpToPixel(size);
    }

    public float getFormSize() {
        return this.mFormSize;
    }

    public float getXEntrySpace() {
        return this.mXEntrySpace;
    }

    public void setXEntrySpace(float space) {
        this.mXEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getYEntrySpace() {
        return this.mYEntrySpace;
    }

    public void setYEntrySpace(float space) {
        this.mYEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getFormToTextSpace() {
        return this.mFormToTextSpace;
    }

    public void setFormToTextSpace(float space) {
        this.mFormToTextSpace = Utils.convertDpToPixel(space);
    }

    public void drawForm(Canvas c, float x, float y, Paint p, int index) {
        if (this.mColors[index] == -2) {
            return;
        }
        p.setColor(this.mColors[index]);
        float half = this.mFormSize / 2.0f;
        switch (this.getForm()) {
            case CIRCLE: {
                c.drawCircle(x + half, y + half, half, p);
                break;
            }
            case SQUARE: {
                c.drawRect(x, y, x + this.mFormSize, y + this.mFormSize, p);
                break;
            }
            case LINE: {
                c.drawLine(x - half, y + half, x + half, y + half, p);
            }
        }
    }

    public void drawLabel(Canvas c, float x, float y, Paint p, int index) {
        c.drawText(this.mLegendLabels[index], x, y, p);
    }

    public void apply(Legend l) {
        this.mPosition = l.mPosition;
        this.mShape = l.mShape;
        this.mTypeface = l.mTypeface;
        this.mFormSize = l.mFormSize;
        this.mXEntrySpace = l.mXEntrySpace;
        this.mYEntrySpace = l.mYEntrySpace;
        this.mFormToTextSpace = l.mFormToTextSpace;
        this.mTextSize = l.mTextSize;
        this.mStackSpace = l.mStackSpace;
        this.mTextColor = l.mTextColor;
        this.mLegendOffsetBottom = l.mLegendOffsetBottom;
        this.mLegendOffsetLeft = l.mLegendOffsetLeft;
        this.mLegendOffsetRight = l.mLegendOffsetRight;
        this.mLegendOffsetTop = l.mLegendOffsetTop;
    }

    public float getOffsetBottom() {
        return this.mLegendOffsetBottom;
    }

    public float getOffsetRight() {
        return this.mLegendOffsetRight;
    }

    public void setOffsetBottom(float off) {
        this.mLegendOffsetBottom = off;
    }

    public void setOffsetRight(float off) {
        this.mLegendOffsetRight = off;
    }

    public float getOffsetTop() {
        return this.mLegendOffsetTop;
    }

    public float getOffsetLeft() {
        return this.mLegendOffsetLeft;
    }

    public void setOffsetTop(float off) {
        this.mLegendOffsetTop = off;
    }

    public void setOffsetLeft(float off) {
        this.mLegendOffsetLeft = off;
    }

    public void setTextSize(float size) {
        this.mTextSize = Utils.convertDpToPixel(size);
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public float getStackSpace() {
        return this.mStackSpace;
    }

    public void setStackSpace(float space) {
        this.mStackSpace = space;
    }

    public float getFullWidth(Paint labelpaint) {
        float width = 0.0f;
        for (int i = 0; i < this.mLegendLabels.length; ++i) {
            if (this.mLegendLabels[i] != null) {
                if (this.mColors[i] != -2) {
                    width += this.mFormSize + this.mFormToTextSpace;
                }
                width += (float)Utils.calcTextWidth(labelpaint, this.mLegendLabels[i]) + this.mXEntrySpace;
                continue;
            }
            width += this.mFormSize + this.mStackSpace;
        }
        return width;
    }

    public float getFullHeight(Paint labelpaint) {
        float height = 0.0f;
        for (int i = 0; i < this.mLegendLabels.length; ++i) {
            if (this.mLegendLabels[i] == null) continue;
            height += (float)Utils.calcTextHeight(labelpaint, this.mLegendLabels[i]) + this.mYEntrySpace;
        }
        return height;
    }

    public void setTextColor(int color) {
        this.mTextColor = color;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public static enum LegendForm {
        SQUARE,
        CIRCLE,
        LINE;

    }

    public static enum LegendPosition {
        RIGHT_OF_CHART,
        BELOW_CHART_LEFT,
        BELOW_CHART_RIGHT,
        BELOW_CHART_CENTER;

    }
}

