/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class PieRadarChartTouchListener
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private PieRadarChartBase mChart;
    private GestureDetector mGestureDetector;
    private Highlight mLastHighlight = null;

    public PieRadarChartTouchListener(PieRadarChartBase ctx) {
        this.mChart = ctx;
        this.mGestureDetector = new GestureDetector(ctx.getContext(), (GestureDetector.OnGestureListener)this);
    }

    public boolean onTouch(View v, MotionEvent e) {
        if (this.mGestureDetector.onTouchEvent(e)) {
            return true;
        }
        if (this.mChart.isRotationEnabled()) {
            float x = e.getX();
            float y = e.getY();
            switch (e.getAction()) {
                case 0: {
                    this.mChart.setStartAngle(x, y);
                    break;
                }
                case 2: {
                    this.mChart.updateRotation(x, y);
                    this.mChart.invalidate();
                    break;
                }
            }
        }
        return true;
    }

    public void onLongPress(MotionEvent me) {
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        float distance = this.mChart.distanceToCenter(e.getX(), e.getY());
        if (distance > this.mChart.getRadius()) {
            this.mChart.highlightValues(null);
            this.mLastHighlight = null;
        } else {
            Highlight h;
            int index = this.mChart.getIndexForAngle(this.mChart.getAngleForPoint(e.getX(), e.getY()));
            ArrayList<SelInfo> valsAtIndex = this.mChart.getYValsAtIndex(index);
            int dataSetIndex = 0;
            if (this.mChart instanceof RadarChart) {
                dataSetIndex = Utils.getClosestDataSetIndex(valsAtIndex, distance / ((RadarChart)this.mChart).getFactor());
            }
            if ((h = new Highlight(index, dataSetIndex)).equalTo(this.mLastHighlight)) {
                this.mChart.highlightTouch(null);
                this.mLastHighlight = null;
            } else {
                this.mChart.highlightTouch(h);
                this.mLastHighlight = h;
            }
        }
        return true;
    }
}

