/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineRadarDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class LineDataSet
extends LineRadarDataSet<Entry> {
    private ArrayList<Integer> mCircleColors = new ArrayList();
    private float mCircleSize = 4.0f;
    private float mCubicIntensity = 0.2f;
    private DashPathEffect mDashPathEffect = null;
    private boolean mDrawCircles = true;
    private boolean mDrawCubic = false;

    public LineDataSet(ArrayList<Entry> yVals, String label) {
        super(yVals, label);
        this.mCircleColors.add(Color.rgb((int)140, (int)234, (int)255));
    }

    @Override
    public DataSet<Entry> copy() {
        ArrayList<Entry> yVals = new ArrayList<Entry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((Entry)this.mYVals.get(i)).copy());
        }
        LineDataSet copied = new LineDataSet(yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mCircleSize = this.mCircleSize;
        copied.mCircleColors = this.mCircleColors;
        copied.mDashPathEffect = this.mDashPathEffect;
        copied.mDrawCircles = this.mDrawCircles;
        copied.mDrawCubic = this.mDrawCubic;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    public void setCubicIntensity(float intensity) {
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (intensity < 0.05f) {
            intensity = 0.05f;
        }
        this.mCubicIntensity = intensity;
    }

    public float getCubicIntensity() {
        return this.mCubicIntensity;
    }

    public void setCircleSize(float size) {
        this.mCircleSize = Utils.convertDpToPixel(size);
    }

    public float getCircleSize() {
        return this.mCircleSize;
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mDashPathEffect = new DashPathEffect(new float[]{lineLength, spaceLength}, phase);
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    public boolean isDashedLineEnabled() {
        return this.mDashPathEffect != null;
    }

    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }

    public void setDrawCircles(boolean enabled) {
        this.mDrawCircles = enabled;
    }

    public boolean isDrawCirclesEnabled() {
        return this.mDrawCircles;
    }

    public void setDrawCubic(boolean enabled) {
        this.mDrawCubic = enabled;
    }

    public boolean isDrawCubicEnabled() {
        return this.mDrawCubic;
    }

    public ArrayList<Integer> getCircleColors() {
        return this.mCircleColors;
    }

    public int getCircleColor(int index) {
        return this.mCircleColors.get(index % this.mCircleColors.size());
    }

    public void setCircleColors(ArrayList<Integer> colors) {
        this.mCircleColors = colors;
    }

    public void setCircleColors(int[] colors) {
        this.mCircleColors = ColorTemplate.createColors(colors);
    }

    public void setCircleColors(int[] colors, Context c) {
        ArrayList<Integer> clrs = new ArrayList<Integer>();
        for (int color : colors) {
            clrs.add(c.getResources().getColor(color));
        }
        this.mCircleColors = clrs;
    }

    public void setCircleColor(int color) {
        this.resetCircleColors();
        this.mCircleColors.add(color);
    }

    public void resetCircleColors() {
        this.mCircleColors = new ArrayList();
    }
}

