/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BarLineScatterCandleRadarDataSet;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class CandleDataSet
extends BarLineScatterCandleRadarDataSet<CandleEntry> {
    private float mShadowWidth = 3.0f;
    private float mBodySpace = 0.1f;

    public CandleDataSet(ArrayList<CandleEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<CandleEntry> copy() {
        ArrayList<CandleEntry> yVals = new ArrayList<CandleEntry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((CandleEntry)this.mYVals.get(i)).copy());
        }
        CandleDataSet copied = new CandleDataSet(yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mShadowWidth = this.mShadowWidth;
        copied.mBodySpace = this.mBodySpace;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    @Override
    protected void calcMinMax() {
        if (this.mYVals.size() == 0) {
            return;
        }
        ArrayList entries = this.mYVals;
        this.mYMin = ((CandleEntry)entries.get(0)).getLow();
        this.mYMax = ((CandleEntry)entries.get(0)).getHigh();
        for (int i = 0; i < entries.size(); ++i) {
            CandleEntry e = (CandleEntry)entries.get(i);
            if (e.getLow() < this.mYMin) {
                this.mYMin = e.getLow();
            }
            if (!(e.getHigh() > this.mYMax)) continue;
            this.mYMax = e.getHigh();
        }
    }

    public void setBodySpace(float space) {
        if (space < 0.0f) {
            space = 0.0f;
        }
        if (space > 0.45f) {
            space = 0.45f;
        }
        this.mBodySpace = space;
    }

    public float getBodySpace() {
        return this.mBodySpace;
    }

    public void setShadowWidth(float width) {
        this.mShadowWidth = Utils.convertDpToPixel(width);
    }

    public float getShadowWidth() {
        return this.mShadowWidth;
    }
}

