/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BarLineScatterCandleRadarDataSet;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.LimitLine;
import java.util.ArrayList;

public abstract class BarLineScatterCandleRadarData<T extends BarLineScatterCandleRadarDataSet<? extends Entry>>
extends ChartData<T> {
    private ArrayList<LimitLine> mLimitLines;

    public BarLineScatterCandleRadarData(ArrayList<String> xVals, ArrayList<T> sets) {
        super(xVals, sets);
    }

    public BarLineScatterCandleRadarData(String[] xVals, ArrayList<T> sets) {
        super(xVals, sets);
    }

    public void addLimitLine(LimitLine limitLine) {
        if (this.mLimitLines == null) {
            this.mLimitLines = new ArrayList();
        }
        this.mLimitLines.add(limitLine);
        this.updateMinMax();
    }

    public void addLimitLines(ArrayList<LimitLine> lines) {
        this.mLimitLines = lines;
        this.updateMinMax();
    }

    public void resetLimitLines() {
        this.mLimitLines = null;
        this.calcMinMax(this.mDataSets);
    }

    public ArrayList<LimitLine> getLimitLines() {
        return this.mLimitLines;
    }

    public LimitLine getLimitLine(int index) {
        if (this.mLimitLines == null || this.mLimitLines.size() <= index) {
            return null;
        }
        return this.mLimitLines.get(index);
    }

    private void updateMinMax() {
        if (this.mLimitLines == null) {
            return;
        }
        for (int i = 0; i < this.mLimitLines.size(); ++i) {
            LimitLine l = this.mLimitLines.get(i);
            if (l.getLimit() > this.mYMax) {
                this.mYMax = l.getLimit();
            }
            if (!(l.getLimit() < this.mYMin)) continue;
            this.mYMin = l.getLimit();
        }
    }
}

