/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Path;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.data.ScatterDataSet;
import java.util.ArrayList;

public class ScatterChart
extends BarLineChartBase<ScatterData> {
    public ScatterChart(Context context) {
        super(context);
    }

    public ScatterChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ScatterChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void drawData() {
        ArrayList dataSets = ((ScatterData)this.mCurrentData).getDataSets();
        for (int i = 0; i < ((ScatterData)this.mCurrentData).getDataSetCount(); ++i) {
            ScatterDataSet dataSet = (ScatterDataSet)dataSets.get(i);
            ArrayList entries = dataSet.getYVals();
            float shapeHalf = dataSet.getScatterShapeSize() / 2.0f;
            float[] valuePoints = this.generateTransformedValuesLineScatter(entries);
            ScatterShape shape = dataSet.getScatterShape();
            int j = 0;
            while ((float)j < (float)valuePoints.length * this.mPhaseX && !this.isOffContentRight(valuePoints[j])) {
                if (!(j != 0 && this.isOffContentLeft(valuePoints[j - 1]) && this.isOffContentTop(valuePoints[j + 1]) && this.isOffContentBottom(valuePoints[j + 1]))) {
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    if (shape == ScatterShape.SQUARE) {
                        this.mDrawCanvas.drawRect(valuePoints[j] - shapeHalf, valuePoints[j + 1] - shapeHalf, valuePoints[j] + shapeHalf, valuePoints[j + 1] + shapeHalf, this.mRenderPaint);
                    } else if (shape == ScatterShape.CIRCLE) {
                        this.mDrawCanvas.drawCircle(valuePoints[j], valuePoints[j + 1], shapeHalf, this.mRenderPaint);
                    } else if (shape == ScatterShape.CROSS) {
                        this.mDrawCanvas.drawLine(valuePoints[j] - shapeHalf, valuePoints[j + 1], valuePoints[j] + shapeHalf, valuePoints[j + 1], this.mRenderPaint);
                        this.mDrawCanvas.drawLine(valuePoints[j], valuePoints[j + 1] - shapeHalf, valuePoints[j], valuePoints[j + 1] + shapeHalf, this.mRenderPaint);
                    } else if (shape == ScatterShape.TRIANGLE) {
                        Path tri = new Path();
                        tri.moveTo(valuePoints[j], valuePoints[j + 1] - shapeHalf);
                        tri.lineTo(valuePoints[j] + shapeHalf, valuePoints[j + 1] + shapeHalf);
                        tri.lineTo(valuePoints[j] - shapeHalf, valuePoints[j + 1] + shapeHalf);
                        tri.close();
                        this.mDrawCanvas.drawPath(tri, this.mRenderPaint);
                    } else if (shape == ScatterShape.CUSTOM) {
                        Path customShape = dataSet.getCustomScatterShape();
                        if (customShape == null) {
                            return;
                        }
                        this.transformPath(customShape);
                        this.mDrawCanvas.drawPath(customShape, this.mRenderPaint);
                    }
                }
                j += 2;
            }
        }
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues && (float)((ScatterData)this.mCurrentData).getYValCount() < (float)this.mMaxVisibleCount * this.mScaleX) {
            ArrayList dataSets = ((ScatterData)this.mCurrentData).getDataSets();
            for (int i = 0; i < ((ScatterData)this.mCurrentData).getDataSetCount(); ++i) {
                ScatterDataSet dataSet = (ScatterDataSet)dataSets.get(i);
                ArrayList entries = dataSet.getYVals();
                float[] positions = this.generateTransformedValuesLineScatter(entries);
                float shapeSize = dataSet.getScatterShapeSize();
                int j = 0;
                while ((float)j < (float)positions.length * this.mPhaseX && !this.isOffContentRight(positions[j])) {
                    if (!(this.isOffContentLeft(positions[j]) || this.isOffContentTop(positions[j + 1]) || this.isOffContentBottom(positions[j + 1]))) {
                        float val = ((Entry)entries.get(j / 2)).getVal();
                        if (this.mDrawUnitInChart) {
                            this.mDrawCanvas.drawText(this.mValueFormat.format(val) + this.mUnit, positions[j], positions[j + 1] - shapeSize, this.mValuePaint);
                        } else {
                            this.mDrawCanvas.drawText(this.mValueFormat.format(val), positions[j], positions[j + 1] - shapeSize, this.mValuePaint);
                        }
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    protected void drawHighlights() {
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            ScatterDataSet set = (ScatterDataSet)((ScatterData)this.mCurrentData).getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            int xIndex = this.mIndicesToHightlight[i].getXIndex();
            if ((float)xIndex > this.mDeltaX * this.mPhaseX) continue;
            float y = set.getYValForXIndex(xIndex) * this.mPhaseY;
            float[] pts = new float[]{xIndex, this.mYChartMax, xIndex, this.mYChartMin, 0.0f, y, this.mDeltaX, y};
            this.transformPointArray(pts);
            this.mDrawCanvas.drawLines(pts, this.mHighlightPaint);
        }
    }

    @Override
    protected void drawAdditional() {
    }

    public static ScatterShape[] getAllPossibleShapes() {
        return new ScatterShape[]{ScatterShape.SQUARE, ScatterShape.CIRCLE, ScatterShape.TRIANGLE, ScatterShape.CROSS};
    }

    public static enum ScatterShape {
        CROSS,
        TRIANGLE,
        CIRCLE,
        SQUARE,
        CUSTOM;

    }
}

