/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.utils.Legend;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class PieChart
extends PieRadarChartBase<PieData> {
    private RectF mCircleBox = new RectF();
    private float[] mDrawAngles;
    private float[] mAbsoluteAngles;
    private boolean mDrawHole = true;
    private String mCenterText = null;
    private float mHoleRadiusPercent = 50.0f;
    private float mTransparentCircleRadius = 55.0f;
    private boolean mDrawCenterText = true;
    private boolean mDrawXVals = true;
    private boolean mUsePercentValues = false;
    private Paint mHolePaint;
    private Paint mCenterTextPaint;

    public PieChart(Context context) {
        super(context);
    }

    public PieChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mCenterTextPaint = new Paint(1);
        this.mCenterTextPaint.setColor(this.mColorDarkBlue);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mCenterTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mDrawYValues = true;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.drawHighlights();
        this.drawData();
        this.drawAdditional();
        this.drawValues();
        this.drawLegend();
        this.drawDescription();
        this.drawCenterText();
        canvas.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mDrawPaint);
        Log.i((String)"MPChart", (String)("PieChart DrawTime: " + (System.currentTimeMillis() - starttime) + " ms"));
    }

    @Override
    public void prepare() {
        super.prepare();
        if (this.mCenterText == null) {
            this.mCenterText = "Total Value\n" + (int)this.getYValueSum();
        }
    }

    @Override
    protected void prepareContentRect() {
        super.prepareContentRect();
        if (this.mDataNotSet) {
            return;
        }
        float diameter = this.getDiameter();
        float boxSize = diameter / 2.0f;
        PointF c = this.getCenterOffsets();
        this.mCircleBox.set(c.x - boxSize, c.y - boxSize, c.x + boxSize, c.y + boxSize);
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        this.calcAngles();
    }

    @Override
    protected void calculateOffsets() {
        if (this.mDrawLegend) {
            float legendRight = 0.0f;
            float legendBottom = 0.0f;
            if (this.mLegend == null) {
                return;
            }
            if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
                float spacing = Utils.convertDpToPixel(7.0f);
                legendRight = (float)this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint) + this.mLegend.getFormSize() + this.mLegend.getFormToTextSpace() + spacing;
                this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                legendBottom = this.mLegendLabelPaint.getTextSize() * 4.0f;
            }
            this.mLegend.setOffsetBottom(legendBottom);
            this.mLegend.setOffsetRight(legendRight);
            float min = Utils.convertDpToPixel(11.0f);
            this.mLegend.setOffsetTop(min);
            this.mLegend.setOffsetLeft(min);
            this.mOffsetTop = Math.max(this.mLegend.getFullHeight(this.mLegendLabelPaint), min);
            this.applyCalculatedOffsets();
        }
    }

    private void calcAngles() {
        this.mDrawAngles = new float[((PieData)this.mCurrentData).getYValCount()];
        this.mAbsoluteAngles = new float[((PieData)this.mCurrentData).getYValCount()];
        ArrayList dataSets = ((PieData)this.mCurrentData).getDataSets();
        int cnt = 0;
        for (int i = 0; i < ((PieData)this.mCurrentData).getDataSetCount(); ++i) {
            PieDataSet set = (PieDataSet)dataSets.get(i);
            ArrayList entries = set.getYVals();
            for (int j = 0; j < entries.size(); ++j) {
                this.mDrawAngles[cnt] = this.calcAngle(Math.abs(((Entry)entries.get(j)).getVal()));
                this.mAbsoluteAngles[cnt] = cnt == 0 ? this.mDrawAngles[cnt] : this.mAbsoluteAngles[cnt - 1] + this.mDrawAngles[cnt];
                ++cnt;
            }
        }
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.valuesToHighlight()) {
            float angle = 0.0f;
            for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
                int xIndex = this.mIndicesToHightlight[i].getXIndex();
                if (xIndex >= this.mDrawAngles.length || (float)xIndex > this.mDeltaX * this.mPhaseX) continue;
                angle = xIndex == 0 ? this.mRotationAngle : this.mRotationAngle + this.mAbsoluteAngles[xIndex - 1];
                float sliceDegrees = this.mDrawAngles[xIndex];
                float shiftangle = (float)Math.toRadians((angle *= this.mPhaseY) + sliceDegrees / 2.0f);
                PieDataSet set = (PieDataSet)((PieData)this.mCurrentData).getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
                float shift = set.getSelectionShift();
                float xShift = shift * (float)Math.cos(shiftangle);
                float yShift = shift * (float)Math.sin(shiftangle);
                RectF highlighted = new RectF(this.mCircleBox.left + xShift, this.mCircleBox.top + yShift, this.mCircleBox.right + xShift, this.mCircleBox.bottom + yShift);
                this.mRenderPaint.setColor(set.getColor(xIndex));
                this.mDrawCanvas.drawArc(highlighted, angle + set.getSliceSpace() / 2.0f, sliceDegrees - set.getSliceSpace() / 2.0f, true, this.mRenderPaint);
            }
        }
    }

    @Override
    protected void drawData() {
        float angle = this.mRotationAngle;
        ArrayList dataSets = ((PieData)this.mCurrentData).getDataSets();
        int cnt = 0;
        for (int i = 0; i < ((PieData)this.mCurrentData).getDataSetCount(); ++i) {
            PieDataSet dataSet = (PieDataSet)dataSets.get(i);
            ArrayList entries = dataSet.getYVals();
            for (int j = 0; j < entries.size(); ++j) {
                float newangle = this.mDrawAngles[cnt];
                float sliceSpace = dataSet.getSliceSpace();
                Entry e = (Entry)entries.get(j);
                if ((double)Math.abs(e.getVal()) > 1.0E-6 && !this.needsHighlight(e.getXIndex(), i)) {
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    this.mDrawCanvas.drawArc(this.mCircleBox, angle + sliceSpace / 2.0f, newangle * this.mPhaseY - sliceSpace / 2.0f, true, this.mRenderPaint);
                }
                angle += newangle * this.mPhaseX;
                ++cnt;
            }
        }
    }

    private void drawHole() {
        if (this.mDrawHole) {
            float radius = this.getRadius();
            PointF c = this.getCenterCircleBox();
            int color = this.mHolePaint.getColor();
            this.mDrawCanvas.drawCircle(c.x, c.y, radius / 100.0f * this.mHoleRadiusPercent, this.mHolePaint);
            this.mHolePaint.setColor(color & 0x60FFFFFF);
            this.mDrawCanvas.drawCircle(c.x, c.y, radius / 100.0f * this.mTransparentCircleRadius, this.mHolePaint);
            this.mHolePaint.setColor(color);
        }
    }

    private void drawCenterText() {
        if (this.mDrawCenterText) {
            PointF c = this.getCenterCircleBox();
            String[] lines = this.mCenterText.split("\n");
            float lineHeight = Utils.calcTextHeight(this.mCenterTextPaint, lines[0]);
            float linespacing = lineHeight * 0.2f;
            float totalheight = lineHeight * (float)lines.length - linespacing * (float)(lines.length - 1);
            int cnt = lines.length;
            float y = c.y;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[lines.length - i - 1];
                this.mDrawCanvas.drawText(line, c.x, y + lineHeight * (float)cnt - totalheight / 2.0f, this.mCenterTextPaint);
                --cnt;
                y -= linespacing;
            }
        }
    }

    @Override
    protected void drawValues() {
        if (!this.mDrawXVals && !this.mDrawYValues) {
            return;
        }
        PointF center = this.getCenterCircleBox();
        float r = this.getRadius();
        float off = r / 2.0f;
        if (this.mDrawHole) {
            off = (r - r / 100.0f * this.mHoleRadiusPercent) / 2.0f;
        }
        r -= off;
        ArrayList dataSets = ((PieData)this.mCurrentData).getDataSets();
        int cnt = 0;
        for (int i = 0; i < ((PieData)this.mCurrentData).getDataSetCount(); ++i) {
            PieDataSet dataSet = (PieDataSet)dataSets.get(i);
            ArrayList entries = dataSet.getYVals();
            int j = 0;
            while ((float)j < (float)entries.size() * this.mPhaseX) {
                float offset = this.mDrawAngles[cnt] / 2.0f;
                float x = (float)((double)r * Math.cos(Math.toRadians((this.mRotationAngle + this.mAbsoluteAngles[cnt] - offset) * this.mPhaseY)) + (double)center.x);
                float y = (float)((double)r * Math.sin(Math.toRadians((this.mRotationAngle + this.mAbsoluteAngles[cnt] - offset) * this.mPhaseY)) + (double)center.y);
                String val = "";
                float value = ((Entry)entries.get(j)).getVal();
                val = this.mUsePercentValues ? this.mValueFormat.format(Math.abs(this.getPercentOfTotal(value))) + " %" : this.mValueFormat.format(value);
                if (this.mDrawUnitInChart) {
                    val = val + this.mUnit;
                }
                if (this.mDrawXVals && this.mDrawYValues) {
                    float lineHeight = (this.mValuePaint.ascent() + this.mValuePaint.descent()) * 1.6f;
                    this.mDrawCanvas.drawText(val, x, y -= lineHeight / 2.0f, this.mValuePaint);
                    this.mDrawCanvas.drawText(((PieData)this.mCurrentData).getXVals().get(j), x, y + lineHeight, this.mValuePaint);
                } else if (this.mDrawXVals && !this.mDrawYValues) {
                    this.mDrawCanvas.drawText(((PieData)this.mCurrentData).getXVals().get(j), x, y, this.mValuePaint);
                } else if (!this.mDrawXVals && this.mDrawYValues) {
                    this.mDrawCanvas.drawText(val, x, y, this.mValuePaint);
                }
                ++cnt;
                ++j;
            }
        }
    }

    @Override
    protected void drawAdditional() {
        this.drawHole();
    }

    private float calcAngle(float value) {
        return value / ((PieData)this.mCurrentData).getYValueSum() * 360.0f;
    }

    @Override
    public int getIndexForAngle(float angle) {
        float a = (angle - this.mRotationAngle + 360.0f) % 360.0f;
        for (int i = 0; i < this.mAbsoluteAngles.length; ++i) {
            if (!(this.mAbsoluteAngles[i] > a)) continue;
            return i;
        }
        return -1;
    }

    public int getDataSetIndexForIndex(int xIndex) {
        ArrayList dataSets = ((PieData)this.mCurrentData).getDataSets();
        for (int i = 0; i < dataSets.size(); ++i) {
            if (((DataSet)dataSets.get(i)).getEntryForXIndex(xIndex) == null) continue;
            return i;
        }
        return -1;
    }

    public float[] getDrawAngles() {
        return this.mDrawAngles;
    }

    public float[] getAbsoluteAngles() {
        return this.mAbsoluteAngles;
    }

    public void setDrawHoleEnabled(boolean enabled) {
        this.mDrawHole = enabled;
    }

    public boolean isDrawHoleEnabled() {
        return this.mDrawHole;
    }

    public void setCenterText(String text) {
        this.mCenterText = text;
    }

    public String getCenterText() {
        return this.mCenterText;
    }

    public void setDrawCenterText(boolean enabled) {
        this.mDrawCenterText = enabled;
    }

    public boolean isDrawCenterTextEnabled() {
        return this.mDrawCenterText;
    }

    public void setUsePercentValues(boolean enabled) {
        this.mUsePercentValues = enabled;
    }

    public boolean isUsePercentValuesEnabled() {
        return this.mUsePercentValues;
    }

    public void setDrawXValues(boolean enabled) {
        this.mDrawXVals = enabled;
    }

    public boolean isDrawXValuesEnabled() {
        return this.mDrawXVals;
    }

    @Override
    public float getRadius() {
        if (this.mCircleBox == null) {
            return 0.0f;
        }
        return Math.min(this.mCircleBox.width() / 2.0f, this.mCircleBox.height() / 2.0f);
    }

    public RectF getCircleBox() {
        return this.mCircleBox;
    }

    public PointF getCenterCircleBox() {
        return new PointF(this.mCircleBox.centerX(), this.mCircleBox.centerY());
    }

    public void setCenterTextTypeface(Typeface t) {
        this.mCenterTextPaint.setTypeface(t);
    }

    public void setCenterTextSize(float size) {
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setHoleRadius(float percent) {
        this.mHoleRadiusPercent = percent;
    }

    public void setTransparentCircleRadius(float percent) {
        this.mTransparentCircleRadius = percent;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 13: {
                this.mHolePaint = p;
                break;
            }
            case 14: {
                this.mCenterTextPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 13: {
                return this.mHolePaint;
            }
            case 14: {
                return this.mCenterTextPaint;
            }
        }
        return null;
    }
}

