/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import java.util.ArrayList;

public class LineChart
extends BarLineChartBase<LineData> {
    protected float mHighlightWidth = 3.0f;
    protected Paint mCirclePaintInner;

    public LineChart(Context context) {
        super(context);
    }

    public LineChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LineChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        if (((LineData)this.mOriginalData).getYValCount() == 1) {
            this.mDeltaX = 1.0f;
        }
    }

    @Override
    protected void drawHighlights() {
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            LineDataSet set = (LineDataSet)((LineData)this.mOriginalData).getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            int xIndex = this.mIndicesToHightlight[i].getXIndex();
            if ((float)xIndex > this.mDeltaX * this.mPhaseX) continue;
            float y = set.getYValForXIndex(xIndex) * this.mPhaseY;
            float[] pts = new float[]{xIndex, this.mYChartMax, xIndex, this.mYChartMin, 0.0f, y, this.mDeltaX, y};
            this.transformPointArray(pts);
            this.mDrawCanvas.drawLines(pts, this.mHighlightPaint);
        }
    }

    @Override
    protected void drawData() {
        ArrayList dataSets = ((LineData)this.mCurrentData).getDataSets();
        for (int i = 0; i < ((LineData)this.mCurrentData).getDataSetCount(); ++i) {
            LineDataSet dataSet = (LineDataSet)dataSets.get(i);
            ArrayList entries = dataSet.getYVals();
            this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
            this.mRenderPaint.setPathEffect((PathEffect)dataSet.getDashPathEffect());
            if (dataSet.isDrawCubicEnabled()) {
                this.mRenderPaint.setColor(dataSet.getColor(i));
                float intensity = dataSet.getCubicIntensity();
                Path spline = new Path();
                ArrayList<CPoint> points = new ArrayList<CPoint>();
                for (Entry e : entries) {
                    points.add(new CPoint(e.getXIndex(), e.getVal()));
                }
                if (points.size() > 1) {
                    int j = 0;
                    while ((float)j < (float)points.size() * this.mPhaseX) {
                        CPoint prev;
                        CPoint next;
                        CPoint point = (CPoint)points.get(j);
                        if (j == 0) {
                            next = (CPoint)points.get(j + 1);
                            point.dx = (next.x - point.x) * intensity;
                            point.dy = (next.y - point.y) * intensity;
                        } else if (j == points.size() - 1) {
                            prev = (CPoint)points.get(j - 1);
                            point.dx = (point.x - prev.x) * intensity;
                            point.dy = (point.y - prev.y) * intensity;
                        } else {
                            next = (CPoint)points.get(j + 1);
                            CPoint prev2 = (CPoint)points.get(j - 1);
                            point.dx = (next.x - prev2.x) * intensity;
                            point.dy = (next.y - prev2.y) * intensity;
                        }
                        if (j == 0) {
                            spline.moveTo(point.x, point.y * this.mPhaseY);
                        } else {
                            prev = (CPoint)points.get(j - 1);
                            spline.cubicTo(prev.x + prev.dx, (prev.y + prev.dy) * this.mPhaseY, point.x - point.dx, (point.y - point.dy) * this.mPhaseY, point.x, point.y * this.mPhaseY);
                        }
                        ++j;
                    }
                }
                if (dataSet.isDrawFilledEnabled()) {
                    float fillMin = dataSet.getYMin() >= 0.0f ? this.mYChartMin : 0.0f;
                    spline.lineTo((float)(entries.size() - 1) * this.mPhaseX, fillMin);
                    spline.lineTo(0.0f, fillMin);
                    spline.close();
                    this.mRenderPaint.setStyle(Paint.Style.FILL);
                } else {
                    this.mRenderPaint.setStyle(Paint.Style.STROKE);
                }
                this.transformPath(spline);
                this.mDrawCanvas.drawPath(spline, this.mRenderPaint);
                continue;
            }
            this.mRenderPaint.setStyle(Paint.Style.STROKE);
            float[] valuePoints = this.generateTransformedValuesLineScatter(entries);
            int j = 0;
            while ((float)j < (float)(valuePoints.length - 2) * this.mPhaseX) {
                this.mRenderPaint.setColor(dataSet.getColor(j / 2));
                if (this.isOffContentRight(valuePoints[j])) break;
                if (!(j != 0 && this.isOffContentLeft(valuePoints[j - 1]) && this.isOffContentTop(valuePoints[j + 1]) && this.isOffContentBottom(valuePoints[j + 1]))) {
                    this.mDrawCanvas.drawLine(valuePoints[j], valuePoints[j + 1], valuePoints[j + 2], valuePoints[j + 3], this.mRenderPaint);
                }
                j += 2;
            }
            this.mRenderPaint.setPathEffect(null);
            if (!dataSet.isDrawFilledEnabled() || entries.size() <= 0) continue;
            this.mRenderPaint.setStyle(Paint.Style.FILL);
            this.mRenderPaint.setColor(dataSet.getFillColor());
            this.mRenderPaint.setAlpha(dataSet.getFillAlpha());
            float fillMin = dataSet.getYMin() >= 0.0f ? this.mYChartMin : 0.0f;
            Path filled = this.generateFilledPath(entries, fillMin);
            this.transformPath(filled);
            this.mDrawCanvas.drawPath(filled, this.mRenderPaint);
            this.mRenderPaint.setAlpha(255);
        }
    }

    private Path generateFilledPath(ArrayList<? extends Entry> entries, float fillMin) {
        Path filled = new Path();
        filled.moveTo((float)entries.get(0).getXIndex(), entries.get(0).getVal() * this.mPhaseY);
        int x = 1;
        while ((float)x < (float)entries.size() * this.mPhaseX) {
            Entry e = entries.get(x);
            filled.lineTo((float)e.getXIndex(), e.getVal() * this.mPhaseY);
            ++x;
        }
        filled.lineTo((float)entries.get((int)((float)(entries.size() - 1) * this.mPhaseX)).getXIndex(), fillMin);
        filled.lineTo((float)entries.get(0).getXIndex(), fillMin);
        filled.close();
        return filled;
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues && (float)((LineData)this.mCurrentData).getYValCount() < (float)this.mMaxVisibleCount * this.mScaleX) {
            ArrayList dataSets = ((LineData)this.mCurrentData).getDataSets();
            for (int i = 0; i < ((LineData)this.mCurrentData).getDataSetCount(); ++i) {
                LineDataSet dataSet = (LineDataSet)dataSets.get(i);
                int valOffset = (int)(dataSet.getCircleSize() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                ArrayList entries = dataSet.getYVals();
                float[] positions = this.generateTransformedValuesLineScatter(entries);
                int j = 0;
                while ((float)j < (float)positions.length * this.mPhaseX && !this.isOffContentRight(positions[j])) {
                    if (!(this.isOffContentLeft(positions[j]) || this.isOffContentTop(positions[j + 1]) || this.isOffContentBottom(positions[j + 1]))) {
                        float val = ((Entry)entries.get(j / 2)).getVal();
                        if (this.mDrawUnitInChart) {
                            this.mDrawCanvas.drawText(this.mValueFormat.format(val) + this.mUnit, positions[j], positions[j + 1] - (float)valOffset, this.mValuePaint);
                        } else {
                            this.mDrawCanvas.drawText(this.mValueFormat.format(val), positions[j], positions[j + 1] - (float)valOffset, this.mValuePaint);
                        }
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    protected void drawAdditional() {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        ArrayList dataSets = ((LineData)this.mCurrentData).getDataSets();
        block0: for (int i = 0; i < ((LineData)this.mCurrentData).getDataSetCount(); ++i) {
            LineDataSet dataSet = (LineDataSet)dataSets.get(i);
            if (!dataSet.isDrawCirclesEnabled()) continue;
            ArrayList entries = dataSet.getYVals();
            float[] positions = this.generateTransformedValuesLineScatter(entries);
            int j = 0;
            while ((float)j < (float)positions.length * this.mPhaseX) {
                this.mRenderPaint.setColor(dataSet.getCircleColor(j / 2));
                if (this.isOffContentRight(positions[j])) continue block0;
                if (!(this.isOffContentLeft(positions[j]) || this.isOffContentTop(positions[j + 1]) || this.isOffContentBottom(positions[j + 1]))) {
                    this.mDrawCanvas.drawCircle(positions[j], positions[j + 1], dataSet.getCircleSize(), this.mRenderPaint);
                    this.mDrawCanvas.drawCircle(positions[j], positions[j + 1], dataSet.getCircleSize() / 2.0f, this.mCirclePaintInner);
                }
                j += 2;
            }
        }
    }

    public void setHighlightLineWidth(float width) {
        this.mHighlightWidth = width;
    }

    public float getHighlightLineWidth() {
        return this.mHighlightWidth;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 10: {
                this.mCirclePaintInner = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 10: {
                return this.mCirclePaintInner;
            }
        }
        return null;
    }

    private class CPoint {
        public float x = 0.0f;
        public float y = 0.0f;
        public float dx = 0.0f;
        public float dy = 0.0f;

        public CPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

