/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.charts.CandleStickChart;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.interfaces.OnChartValueSelectedListener;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Legend;
import com.github.mikephil.charting.utils.MarkerView;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class Chart<T extends ChartData<? extends DataSet<? extends Entry>>>
extends View
implements ValueAnimator.AnimatorUpdateListener {
    public static final String LOG_TAG = "MPChart";
    protected int mColorDarkBlue = Color.rgb((int)41, (int)128, (int)186);
    protected int mColorDarkRed = Color.rgb((int)232, (int)76, (int)59);
    protected String mUnit = "";
    private int mBackgroundColor = -1;
    protected DecimalFormat mValueFormat = null;
    protected float mOffsetLeft = 12.0f;
    protected float mOffsetTop = 12.0f;
    protected float mOffsetRight = 12.0f;
    protected float mOffsetBottom = 12.0f;
    protected T mCurrentData = null;
    protected T mOriginalData = null;
    protected Bitmap mDrawBitmap;
    protected Canvas mDrawCanvas;
    protected float mYChartMin = 0.0f;
    protected float mYChartMax = 0.0f;
    protected Paint mXLabelPaint;
    protected Paint mYLabelPaint;
    protected Paint mDrawPaint;
    protected Paint mHighlightPaint;
    protected Paint mDescPaint;
    protected Paint mInfoPaint;
    protected Paint mValuePaint;
    protected Paint mRenderPaint;
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected Paint mLimitLinePaint;
    protected String mDescription = "Description.";
    protected boolean mDataNotSet = true;
    protected boolean mDrawUnitInChart = false;
    protected float mDeltaY = 1.0f;
    protected float mDeltaX = 1.0f;
    protected Matrix mMatrixValueToPx = new Matrix();
    protected Matrix mMatrixOffset = new Matrix();
    protected final Matrix mMatrixTouch = new Matrix();
    protected boolean mTouchEnabled = true;
    protected boolean mDrawYValues = true;
    protected boolean mHighlightEnabled = true;
    protected boolean mDrawLegend = true;
    protected RectF mContentRect = new RectF();
    protected Legend mLegend;
    protected OnChartValueSelectedListener mSelectionListener;
    private String mNoDataText = "No chart data available.";
    private String mNoDataTextDescription;
    protected boolean mOffsetsCalculated = false;
    protected Highlight[] mIndicesToHightlight = new Highlight[0];
    protected boolean mDrawMarkerViews = true;
    protected MarkerView mMarkerView;
    protected float mPhaseY = 1.0f;
    protected float mPhaseX = 1.0f;
    private ObjectAnimator mAnimatorY;
    private ObjectAnimator mAnimatorX;
    public static final int PAINT_GRID = 3;
    public static final int PAINT_GRID_BACKGROUND = 4;
    public static final int PAINT_YLABEL = 5;
    public static final int PAINT_XLABEL = 6;
    public static final int PAINT_INFO = 7;
    public static final int PAINT_VALUES = 8;
    public static final int PAINT_CIRCLES_INNER = 10;
    public static final int PAINT_DESCRIPTION = 11;
    public static final int PAINT_BORDER = 12;
    public static final int PAINT_HOLE = 13;
    public static final int PAINT_CENTER_TEXT = 14;
    public static final int PAINT_HIGHLIGHT = 15;
    public static final int PAINT_RADAR_WEB = 16;
    public static final int PAINT_RENDER = 17;
    public static final int PAINT_LEGEND_LABEL = 18;
    public static final int PAINT_LIMIT_LINE = 19;
    private boolean mUseCustomFormatter = false;
    private boolean mMatrixOnLayoutPrepared = false;

    public Chart(Context context) {
        super(context);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        Utils.init(this.getContext().getResources());
        this.mOffsetBottom = (int)Utils.convertDpToPixel(this.mOffsetBottom);
        this.mOffsetLeft = (int)Utils.convertDpToPixel(this.mOffsetLeft);
        this.mOffsetRight = (int)Utils.convertDpToPixel(this.mOffsetRight);
        this.mOffsetTop = (int)Utils.convertDpToPixel(this.mOffsetTop);
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mDrawPaint = new Paint();
        this.mDescPaint = new Paint(1);
        this.mDescPaint.setColor(-16777216);
        this.mDescPaint.setTextAlign(Paint.Align.RIGHT);
        this.mDescPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mInfoPaint = new Paint(1);
        this.mInfoPaint.setColor(Color.rgb((int)247, (int)189, (int)51));
        this.mInfoPaint.setTextAlign(Paint.Align.CENTER);
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mValuePaint = new Paint(1);
        this.mValuePaint.setColor(Color.rgb((int)63, (int)63, (int)63));
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        this.mXLabelPaint = new Paint(1);
        this.mXLabelPaint.setColor(-16777216);
        this.mXLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mXLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mYLabelPaint = new Paint(1);
        this.mYLabelPaint.setColor(-16777216);
        this.mYLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mLimitLinePaint = new Paint(1);
        this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
    }

    public void setData(T data) {
        if (data == null || !((ChartData)data).isValid()) {
            Log.e((String)LOG_TAG, (String)"Cannot set data for chart. Provided chart values are null or contain less than 1 entry.");
            this.mDataNotSet = true;
            return;
        }
        this.mDataNotSet = false;
        this.mOffsetsCalculated = false;
        this.mCurrentData = data;
        this.mOriginalData = data;
        this.prepare();
        this.calcFormats();
        Log.i((String)LOG_TAG, (String)"Data is set.");
    }

    public void clear() {
        this.mCurrentData = null;
        this.mOriginalData = null;
        this.mDataNotSet = true;
        this.invalidate();
    }

    public abstract void prepare();

    public abstract void notifyDataSetChanged();

    protected abstract void calculateOffsets();

    protected void calcMinMax(boolean fixedValues) {
        if (!fixedValues) {
            this.mYChartMin = ((ChartData)this.mCurrentData).getYMin();
            this.mYChartMax = ((ChartData)this.mCurrentData).getYMax();
        }
        this.mDeltaY = Math.abs(this.mYChartMax - this.mYChartMin);
        this.mDeltaX = ((ChartData)this.mCurrentData).getXVals().size() - 1;
    }

    protected void calcFormats() {
        if (!this.mUseCustomFormatter) {
            float reference = 0.0f;
            reference = this.mOriginalData == null || ((ChartData)this.mOriginalData).getXValCount() < 2 ? Math.max(Math.abs(this.mYChartMin), Math.abs(this.mYChartMax)) : this.mDeltaY;
            int digits = Utils.getDecimals(reference);
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < digits; ++i) {
                if (i == 0) {
                    b.append(".");
                }
                b.append("0");
            }
            this.mValueFormat = new DecimalFormat("###,###,###,##0" + b.toString());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            canvas.drawText(this.mNoDataText, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mInfoPaint);
            if (!TextUtils.isEmpty((CharSequence)this.mNoDataTextDescription)) {
                float textOffset = -this.mInfoPaint.ascent() + this.mInfoPaint.descent();
                canvas.drawText(this.mNoDataTextDescription, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2) + textOffset, this.mInfoPaint);
            }
            return;
        }
        if (!this.mOffsetsCalculated) {
            this.calculateOffsets();
            this.mOffsetsCalculated = true;
        }
        if (this.mDrawBitmap == null || this.mDrawCanvas == null) {
            this.mDrawBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            this.mDrawCanvas = new Canvas(this.mDrawBitmap);
        }
        this.mDrawCanvas.drawColor(this.mBackgroundColor);
    }

    protected void prepareMatrix() {
        this.prepareMatrixValuePx();
        this.prepareMatrixOffset();
        Log.i((String)LOG_TAG, (String)"Matrices prepared.");
    }

    protected void prepareMatrixValuePx() {
        float scaleX = ((float)this.getWidth() - this.mOffsetRight - this.mOffsetLeft) / this.mDeltaX;
        float scaleY = ((float)this.getHeight() - this.mOffsetTop - this.mOffsetBottom) / this.mDeltaY;
        this.mMatrixValueToPx.reset();
        this.mMatrixValueToPx.postTranslate(0.0f, -this.mYChartMin);
        this.mMatrixValueToPx.postScale(scaleX, -scaleY);
    }

    protected void prepareMatrixOffset() {
        this.mMatrixOffset.reset();
        this.mMatrixOffset.postTranslate(this.mOffsetLeft, (float)this.getHeight() - this.mOffsetBottom);
    }

    protected void prepareContentRect() {
        this.mContentRect.set(this.mOffsetLeft, this.mOffsetTop, (float)this.getWidth() - this.mOffsetRight, (float)this.getHeight() - this.mOffsetBottom);
    }

    public void prepareLegend() {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < ((ChartData)this.mOriginalData).getDataSetCount(); ++i) {
            int j;
            Object dataSet = ((ChartData)this.mOriginalData).getDataSetByIndex(i);
            ArrayList<Integer> clrs = ((DataSet)dataSet).getColors();
            int entryCount = ((DataSet)dataSet).getEntryCount();
            if (dataSet instanceof BarDataSet && ((BarDataSet)dataSet).getStackSize() > 1) {
                BarDataSet bds = (BarDataSet)dataSet;
                String[] sLabels = bds.getStackLabels();
                for (j = 0; j < clrs.size() && j < entryCount && j < bds.getStackSize(); ++j) {
                    labels.add(sLabels[j % sLabels.length]);
                    colors.add(clrs.get(j));
                }
                colors.add(-2);
                labels.add(bds.getLabel());
                continue;
            }
            if (dataSet instanceof PieDataSet) {
                ArrayList<String> xVals = ((ChartData)this.mOriginalData).getXVals();
                PieDataSet pds = (PieDataSet)dataSet;
                for (j = 0; j < clrs.size() && j < entryCount && j < xVals.size(); ++j) {
                    labels.add(xVals.get(j));
                    colors.add(clrs.get(j));
                }
                colors.add(-2);
                labels.add(pds.getLabel());
                continue;
            }
            for (int j2 = 0; j2 < clrs.size() && j2 < entryCount; ++j2) {
                if (j2 < clrs.size() - 1 && j2 < entryCount - 1) {
                    labels.add(null);
                } else {
                    String label = ((DataSet)((ChartData)this.mOriginalData).getDataSetByIndex(i)).getLabel();
                    labels.add(label);
                }
                colors.add(clrs.get(j2));
            }
        }
        Legend l = new Legend(colors, labels);
        if (this.mLegend != null) {
            l.apply(this.mLegend);
        }
        this.mLegend = l;
    }

    protected float[] generateTransformedValuesLineScatter(ArrayList<? extends Entry> entries) {
        float[] valuePoints = new float[entries.size() * 2];
        for (int j = 0; j < valuePoints.length; j += 2) {
            valuePoints[j] = entries.get(j / 2).getXIndex();
            valuePoints[j + 1] = entries.get(j / 2).getVal() * this.mPhaseY;
        }
        this.transformPointArray(valuePoints);
        return valuePoints;
    }

    protected float[] generateTransformedValuesBarChart(ArrayList<? extends Entry> entries, int dataSet) {
        float[] valuePoints = new float[entries.size() * 2];
        int setCount = ((ChartData)this.mOriginalData).getDataSetCount();
        BarData bd = (BarData)this.mOriginalData;
        float space = bd.getGroupSpace();
        for (int j = 0; j < valuePoints.length; j += 2) {
            Entry e = entries.get(j / 2);
            float x = (float)(e.getXIndex() + j / 2 * (setCount - 1) + dataSet) + 0.5f + space * (float)(j / 2) + space / 2.0f;
            float y = e.getVal();
            valuePoints[j] = x;
            valuePoints[j + 1] = y * this.mPhaseY;
        }
        this.transformPointArray(valuePoints);
        return valuePoints;
    }

    protected void transformPath(Path path) {
        path.transform(this.mMatrixValueToPx);
        path.transform(this.mMatrixTouch);
        path.transform(this.mMatrixOffset);
    }

    protected void transformPaths(ArrayList<Path> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            this.transformPath(paths.get(i));
        }
    }

    protected void transformPointArray(float[] pts) {
        this.mMatrixValueToPx.mapPoints(pts);
        this.mMatrixTouch.mapPoints(pts);
        this.mMatrixOffset.mapPoints(pts);
    }

    protected void transformRect(RectF r) {
        this.mMatrixValueToPx.mapRect(r);
        this.mMatrixTouch.mapRect(r);
        this.mMatrixOffset.mapRect(r);
    }

    protected void transformRectWithPhase(RectF r) {
        if (r.top > 0.0f) {
            r.top *= this.mPhaseY;
        } else {
            r.bottom *= this.mPhaseY;
        }
        this.mMatrixValueToPx.mapRect(r);
        this.mMatrixTouch.mapRect(r);
        this.mMatrixOffset.mapRect(r);
    }

    protected void transformRects(ArrayList<RectF> rects) {
        for (int i = 0; i < rects.size(); ++i) {
            this.transformRect(rects.get(i));
        }
    }

    protected void transformRectsTouch(ArrayList<RectF> rects) {
        for (int i = 0; i < rects.size(); ++i) {
            this.mMatrixTouch.mapRect(rects.get(i));
        }
    }

    protected void transformPathsTouch(ArrayList<Path> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            paths.get(i).transform(this.mMatrixTouch);
        }
    }

    protected void drawLegend() {
        if (!this.mDrawLegend || this.mLegend == null) {
            return;
        }
        String[] labels = this.mLegend.getLegendLabels();
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        float formSize = this.mLegend.getFormSize();
        float formTextSpaceAndForm = this.mLegend.getFormToTextSpace() + formSize;
        float stackSpace = this.mLegend.getStackSpace();
        float textSize = this.mLegend.getTextSize();
        float textDrop = ((float)Utils.calcTextHeight(this.mLegendLabelPaint, "AQJ") + formSize) / 2.0f;
        switch (this.mLegend.getPosition()) {
            case BELOW_CHART_LEFT: {
                float posX = this.mLegend.getOffsetLeft();
                float posY = (float)this.getHeight() - this.mLegend.getOffsetBottom() / 2.0f - formSize / 2.0f;
                for (int i = 0; i < labels.length; ++i) {
                    this.mLegend.drawForm(this.mDrawCanvas, posX, posY, this.mLegendFormPaint, i);
                    if (labels[i] != null) {
                        if (this.mLegend.getColors()[i] != -2) {
                            posX += formTextSpaceAndForm;
                        }
                        this.mLegend.drawLabel(this.mDrawCanvas, posX, posY + textDrop, this.mLegendLabelPaint, i);
                        posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + this.mLegend.getXEntrySpace();
                        continue;
                    }
                    posX += formSize + stackSpace;
                }
                break;
            }
            case BELOW_CHART_RIGHT: {
                float posX = (float)this.getWidth() - this.getOffsetRight();
                float posY = (float)this.getHeight() - this.mLegend.getOffsetBottom() / 2.0f - formSize / 2.0f;
                for (int i = labels.length - 1; i >= 0; --i) {
                    if (labels[i] != null) {
                        this.mLegend.drawLabel(this.mDrawCanvas, posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + this.mLegend.getXEntrySpace(), posY + textDrop, this.mLegendLabelPaint, i);
                        if (this.mLegend.getColors()[i] != -2) {
                            posX -= formTextSpaceAndForm;
                        }
                    } else {
                        posX -= stackSpace + formSize;
                    }
                    this.mLegend.drawForm(this.mDrawCanvas, posX, posY, this.mLegendFormPaint, i);
                }
                break;
            }
            case RIGHT_OF_CHART: {
                float posX = (float)(this.getWidth() - this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint)) - formTextSpaceAndForm;
                float posY = this.mLegend.getOffsetTop();
                float stack = 0.0f;
                boolean wasStacked = false;
                for (int i = 0; i < labels.length; ++i) {
                    this.mLegend.drawForm(this.mDrawCanvas, posX + stack, posY, this.mLegendFormPaint, i);
                    if (labels[i] != null) {
                        if (!wasStacked) {
                            float x = posX;
                            if (this.mLegend.getColors()[i] != -2) {
                                x += formTextSpaceAndForm;
                            }
                            this.mLegend.drawLabel(this.mDrawCanvas, x, posY += textDrop, this.mLegendLabelPaint, i);
                        } else {
                            this.mLegend.drawLabel(this.mDrawCanvas, posX, posY += textSize * 1.2f + formSize, this.mLegendLabelPaint, i);
                        }
                        posY += this.mLegend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
            case BELOW_CHART_CENTER: {
                float fullSize = this.mLegend.getFullWidth(this.mLegendLabelPaint);
                float posX = (float)this.getWidth() / 2.0f - fullSize / 2.0f;
                float posY = (float)this.getHeight() - this.mLegend.getOffsetBottom() / 2.0f - formSize / 2.0f;
                for (int i = 0; i < labels.length; ++i) {
                    this.mLegend.drawForm(this.mDrawCanvas, posX, posY, this.mLegendFormPaint, i);
                    if (labels[i] != null) {
                        if (this.mLegend.getColors()[i] != -2) {
                            posX += formTextSpaceAndForm;
                        }
                        this.mLegend.drawLabel(this.mDrawCanvas, posX, posY + textDrop, this.mLegendLabelPaint, i);
                        posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + this.mLegend.getXEntrySpace();
                        continue;
                    }
                    posX += formSize + stackSpace;
                }
                Log.i((String)LOG_TAG, (String)("content bottom: " + this.mContentRect.bottom + ", height: " + this.getHeight() + ", posY: " + posY + ", formSize: " + formSize));
            }
        }
    }

    protected void drawDescription() {
        this.mDrawCanvas.drawText(this.mDescription, (float)this.getWidth() - this.mOffsetRight - 10.0f, (float)this.getHeight() - this.mOffsetBottom - 10.0f, this.mDescPaint);
    }

    protected abstract void drawValues();

    protected abstract void drawData();

    protected abstract void drawAdditional();

    protected abstract void drawHighlights();

    public boolean needsHighlight(int xIndex, int dataSetIndex) {
        if (!this.valuesToHighlight()) {
            return false;
        }
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            if (this.mIndicesToHightlight[i].getXIndex() != xIndex || this.mIndicesToHightlight[i].getDataSetIndex() != dataSetIndex || !((float)xIndex <= this.mDeltaX)) continue;
            return true;
        }
        return false;
    }

    public boolean valuesToHighlight() {
        return this.mIndicesToHightlight != null && this.mIndicesToHightlight.length > 0 && this.mIndicesToHightlight[0] != null;
    }

    public void highlightValues(Highlight[] highs) {
        this.mIndicesToHightlight = highs;
        this.invalidate();
    }

    public void highlightTouch(Highlight high) {
        this.mIndicesToHightlight = high == null ? null : new Highlight[]{high};
        this.invalidate();
        if (this.mSelectionListener != null) {
            if (!this.valuesToHighlight()) {
                this.mSelectionListener.onNothingSelected();
            } else {
                Entry e = this.getEntryByDataSetIndex(high.getXIndex(), high.getDataSetIndex());
                this.mSelectionListener.onValueSelected(e, high.getDataSetIndex());
            }
        }
    }

    protected void drawMarkers() {
        if (this.mMarkerView == null || !this.mDrawMarkerViews || !this.valuesToHighlight()) {
            return;
        }
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            float[] pos;
            Entry e;
            int xIndex = this.mIndicesToHightlight[i].getXIndex();
            int dataSetIndex = this.mIndicesToHightlight[i].getDataSetIndex();
            if (!((float)xIndex <= this.mDeltaX) || !((float)xIndex <= this.mDeltaX * this.mPhaseX) || (e = this.getEntryByDataSetIndex(xIndex, dataSetIndex)) == null || (pos = this.getMarkerPosition(e, dataSetIndex))[0] < this.mOffsetLeft || pos[0] > (float)this.getWidth() - this.mOffsetRight || pos[1] < this.mOffsetTop || pos[1] > (float)this.getHeight() - this.mOffsetBottom) continue;
            this.mMarkerView.refreshContent(e, dataSetIndex);
            this.mMarkerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mMarkerView.layout(0, 0, this.mMarkerView.getMeasuredWidth(), this.mMarkerView.getMeasuredHeight());
            this.mMarkerView.draw(this.mDrawCanvas, pos[0], pos[1]);
        }
    }

    private float[] getMarkerPosition(Entry e, int dataSetIndex) {
        float xPos = e.getXIndex();
        if (this instanceof CandleStickChart) {
            xPos += 0.5f;
        } else if (this instanceof BarChart) {
            BarData bd = (BarData)this.mCurrentData;
            float space = bd.getGroupSpace();
            float j = ((DataSet)((ChartData)this.mCurrentData).getDataSetByIndex(dataSetIndex)).getEntryPosition(e);
            float x = j * (float)(((ChartData)this.mCurrentData).getDataSetCount() - 1) + (float)dataSetIndex + space * j + space / 2.0f + 0.5f;
            xPos += x;
        } else if (this instanceof RadarChart) {
            RadarChart rc = (RadarChart)this;
            float angle = rc.getSliceAngle() * (float)e.getXIndex() + rc.getRotationAngle();
            float val = e.getVal() * rc.getFactor();
            PointF c = this.getCenterOffsets();
            PointF p = new PointF((float)((double)c.x + (double)val * Math.cos(Math.toRadians(angle))), (float)((double)c.y + (double)val * Math.sin(Math.toRadians(angle))));
            return new float[]{p.x, p.y};
        }
        float[] pts = new float[]{xPos, e.getVal() * this.mPhaseY};
        this.transformPointArray(pts);
        return pts;
    }

    public void animateXY(int durationMillisX, int durationMillisY) {
        this.mAnimatorY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        this.mAnimatorY.setDuration((long)durationMillisY);
        this.mAnimatorX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        this.mAnimatorX.setDuration((long)durationMillisX);
        if (durationMillisX > durationMillisY) {
            this.mAnimatorX.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        } else {
            this.mAnimatorY.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        }
        this.mAnimatorX.start();
        this.mAnimatorY.start();
    }

    public void animateX(int durationMillis) {
        this.mAnimatorX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        this.mAnimatorX.setDuration((long)durationMillis);
        this.mAnimatorX.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mAnimatorX.start();
    }

    public void animateY(int durationMillis) {
        this.mAnimatorY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        this.mAnimatorY.setDuration((long)durationMillis);
        this.mAnimatorY.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mAnimatorY.start();
    }

    public void onAnimationUpdate(ValueAnimator va) {
        this.invalidate();
    }

    public float getPhaseY() {
        return this.mPhaseY;
    }

    public void setPhaseY(float phase) {
        this.mPhaseY = phase;
    }

    public float getPhaseX() {
        return this.mPhaseX;
    }

    public void setPhaseX(float phase) {
        this.mPhaseX = phase;
    }

    public Canvas getCanvas() {
        return this.mDrawCanvas;
    }

    public void setOnChartValueSelectedListener(OnChartValueSelectedListener l) {
        this.mSelectionListener = l;
    }

    public void setHighlightEnabled(boolean enabled) {
        this.mHighlightEnabled = enabled;
    }

    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    public float getYValueSum() {
        return ((ChartData)this.mCurrentData).getYValueSum();
    }

    public float getYMax() {
        return ((ChartData)this.mCurrentData).getYMax();
    }

    public float getYChartMin() {
        return this.mYChartMin;
    }

    public float getYChartMax() {
        return this.mYChartMax;
    }

    public float getYMin() {
        return ((ChartData)this.mCurrentData).getYMin();
    }

    public float getDeltaX() {
        return this.mDeltaX;
    }

    public float getAverage() {
        return this.getYValueSum() / (float)((ChartData)this.mCurrentData).getYValCount();
    }

    public float getAverage(String dataSetLabel) {
        Object ds = ((ChartData)this.mCurrentData).getDataSetByLabel(dataSetLabel, true);
        return ((DataSet)ds).getYValueSum() / (float)((DataSet)ds).getEntryCount();
    }

    public int getValueCount() {
        return ((ChartData)this.mCurrentData).getYValCount();
    }

    public PointF getCenter() {
        return new PointF((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public PointF getCenterOffsets() {
        return new PointF(this.mContentRect.centerX(), this.mContentRect.centerY());
    }

    public void setDescriptionTextSize(float size) {
        if (size > 14.0f) {
            size = 14.0f;
        }
        if (size < 7.0f) {
            size = 7.0f;
        }
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public void setNoDataText(String text) {
        this.mNoDataText = text;
    }

    public void setNoDataTextDescription(String text) {
        this.mNoDataTextDescription = text;
    }

    public void setOffsets(float left, float top, float right, float bottom) {
        this.mOffsetBottom = Utils.convertDpToPixel(bottom);
        this.mOffsetLeft = Utils.convertDpToPixel(left);
        this.mOffsetRight = Utils.convertDpToPixel(right);
        this.mOffsetTop = Utils.convertDpToPixel(top);
    }

    public float getOffsetLeft() {
        return this.mOffsetLeft;
    }

    public float getOffsetBottom() {
        return this.mOffsetBottom;
    }

    public float getOffsetRight() {
        return this.mOffsetRight;
    }

    public float getOffsetTop() {
        return this.mOffsetTop;
    }

    public void setTouchEnabled(boolean enabled) {
        this.mTouchEnabled = enabled;
    }

    public void setDrawYValues(boolean enabled) {
        this.mDrawYValues = enabled;
    }

    public void setMarkerView(MarkerView v) {
        this.mMarkerView = v;
    }

    public MarkerView getMarkerView() {
        return this.mMarkerView;
    }

    public void setDrawUnitsInChart(boolean enabled) {
        this.mDrawUnitInChart = enabled;
    }

    public void setUnit(String unit) {
        this.mUnit = unit;
    }

    public String getUnit() {
        return this.mUnit;
    }

    public void setDrawLegend(boolean enabled) {
        this.mDrawLegend = enabled;
    }

    public boolean isDrawLegendEnabled() {
        return this.mDrawLegend;
    }

    public Legend getLegend() {
        return this.mLegend;
    }

    public RectF getContentRect() {
        return this.mContentRect;
    }

    public void setPaint(Paint p, int which) {
        switch (which) {
            case 7: {
                this.mInfoPaint = p;
                break;
            }
            case 11: {
                this.mDescPaint = p;
                break;
            }
            case 8: {
                this.mValuePaint = p;
                break;
            }
            case 17: {
                this.mRenderPaint = p;
                break;
            }
            case 18: {
                this.mLegendLabelPaint = p;
                break;
            }
            case 6: {
                this.mXLabelPaint = p;
                break;
            }
            case 5: {
                this.mYLabelPaint = p;
                break;
            }
            case 15: {
                this.mHighlightPaint = p;
                break;
            }
            case 19: {
                this.mLimitLinePaint = p;
            }
        }
    }

    public Paint getPaint(int which) {
        switch (which) {
            case 7: {
                return this.mInfoPaint;
            }
            case 11: {
                return this.mDescPaint;
            }
            case 8: {
                return this.mValuePaint;
            }
            case 17: {
                return this.mRenderPaint;
            }
            case 18: {
                return this.mLegendLabelPaint;
            }
            case 6: {
                return this.mXLabelPaint;
            }
            case 5: {
                return this.mYLabelPaint;
            }
            case 15: {
                return this.mHighlightPaint;
            }
            case 19: {
                return this.mLimitLinePaint;
            }
        }
        return null;
    }

    public boolean isDrawMarkerViewEnabled() {
        return this.mDrawMarkerViews;
    }

    public void setDrawMarkerViews(boolean enabled) {
        this.mDrawMarkerViews = enabled;
    }

    public void setValueFormatter(DecimalFormat f) {
        this.mValueFormat = f;
        this.mUseCustomFormatter = f != null;
    }

    public DecimalFormat getValueFormatter() {
        return this.mValueFormat;
    }

    public void setValueTextColor(int color) {
        this.mValuePaint.setColor(color);
    }

    public void setValueTextSize(float size) {
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public boolean isDrawYValuesEnabled() {
        return this.mDrawYValues;
    }

    public String getXValue(int index) {
        if (this.mCurrentData == null || ((ChartData)this.mCurrentData).getXValCount() <= index) {
            return null;
        }
        return ((ChartData)this.mCurrentData).getXVals().get(index);
    }

    public float getYValue(int index, String dataSetLabel) {
        Object set = ((ChartData)this.mCurrentData).getDataSetByLabel(dataSetLabel, true);
        return ((Entry)((DataSet)set).getYVals().get(index)).getVal();
    }

    public float getYValue(int xIndex, int dataSetIndex) {
        Object set = ((ChartData)this.mCurrentData).getDataSetByIndex(dataSetIndex);
        return ((DataSet)set).getYValForXIndex(xIndex);
    }

    public DataSet<? extends Entry> getDataSetByIndex(int index) {
        return ((ChartData)this.mCurrentData).getDataSetByIndex(index);
    }

    public DataSet<? extends Entry> getDataSetByLabel(String dataSetLabel) {
        return ((ChartData)this.mCurrentData).getDataSetByLabel(dataSetLabel, true);
    }

    public Entry getEntry(int index) {
        return (Entry)((DataSet)((ChartData)this.mCurrentData).getDataSetByIndex(0)).getYVals().get(index);
    }

    public Entry getEntry(int index, String dataSetLabel) {
        return (Entry)((DataSet)((ChartData)this.mCurrentData).getDataSetByLabel(dataSetLabel, true)).getYVals().get(index);
    }

    public Entry getEntryByDataSetIndex(int xIndex, int dataSetIndex) {
        return ((DataSet)((ChartData)this.mCurrentData).getDataSetByIndex(dataSetIndex)).getEntryForXIndex(xIndex);
    }

    public ArrayList<SelInfo> getYValsAtIndex(int xIndex) {
        ArrayList<SelInfo> vals = new ArrayList<SelInfo>();
        for (int i = 0; i < ((ChartData)this.mCurrentData).getDataSetCount(); ++i) {
            float yVal = ((DataSet)((ChartData)this.mCurrentData).getDataSetByIndex(i)).getYValForXIndex(xIndex);
            if (Float.isNaN(yVal)) continue;
            vals.add(new SelInfo(yVal, i));
        }
        return vals;
    }

    public ArrayList<Entry> getEntriesAtIndex(int xIndex) {
        ArrayList<Entry> vals = new ArrayList<Entry>();
        for (int i = 0; i < ((ChartData)this.mCurrentData).getDataSetCount(); ++i) {
            Object set = ((ChartData)this.mCurrentData).getDataSetByIndex(i);
            Object e = ((DataSet)set).getEntryForXIndex(xIndex);
            if (e == null) continue;
            vals.add((Entry)e);
        }
        return vals;
    }

    public T getDataCurrent() {
        return this.mCurrentData;
    }

    public T getDataOriginal() {
        return this.mOriginalData;
    }

    public float getPercentOfTotal(float val) {
        return val / ((ChartData)this.mCurrentData).getYValueSum() * 100.0f;
    }

    public void setValueTypeface(Typeface t) {
        this.mValuePaint.setTypeface(t);
    }

    public void setDescriptionTypeface(Typeface t) {
        this.mDescPaint.setTypeface(t);
    }

    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
        this.mBackgroundColor = color;
    }

    public boolean saveToPath(String title, String pathOnSD) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(Environment.getExternalStorageDirectory().getPath() + pathOnSD + "/" + title + ".png");
            this.mDrawBitmap.compress(Bitmap.CompressFormat.PNG, 40, (OutputStream)stream);
            ((OutputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveToGallery(String fileName, int quality) {
        if (quality < 0 || quality > 100) {
            quality = 50;
        }
        long currentTime = System.currentTimeMillis();
        File extBaseDir = Environment.getExternalStorageDirectory();
        File file = new File(extBaseDir.getAbsolutePath() + "/DCIM");
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        String filePath = file.getAbsolutePath() + "/" + fileName;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            this.mDrawBitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        long size = new File(filePath).length();
        ContentValues values = new ContentValues(8);
        values.put("title", fileName);
        values.put("_display_name", fileName);
        values.put("date_added", Long.valueOf(currentTime));
        values.put("mime_type", "image/jpeg");
        values.put("description", "MPAndroidChart-Library Save");
        values.put("orientation", Integer.valueOf(0));
        values.put("_data", filePath);
        values.put("_size", Long.valueOf(size));
        return this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) != null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.prepareContentRect();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }
}

