/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleDataSet;
import com.github.mikephil.charting.data.CandleEntry;
import java.util.ArrayList;

public class CandleStickChart
extends BarLineChartBase<CandleData> {
    public CandleStickChart(Context context) {
        super(context);
    }

    public CandleStickChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CandleStickChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        this.mDeltaX += 1.0f;
    }

    @Override
    protected void drawData() {
        ArrayList dataSets = ((CandleData)this.mCurrentData).getDataSets();
        float[] shadowPoints = new float[4];
        float[] bodyPoints = new float[4];
        block0: for (int i = 0; i < ((CandleData)this.mCurrentData).getDataSetCount(); ++i) {
            CandleDataSet dataSet = (CandleDataSet)dataSets.get(i);
            ArrayList entries = dataSet.getYVals();
            this.mRenderPaint.setStrokeWidth(dataSet.getShadowWidth());
            int j = 0;
            while ((float)j < (float)entries.size() * this.mPhaseX) {
                this.mRenderPaint.setColor(dataSet.getColor(j));
                CandleEntry e = (CandleEntry)entries.get(j);
                this.transformShadow(shadowPoints, e);
                this.transformBody(bodyPoints, e, dataSet.getBodySpace());
                float xShadow = shadowPoints[0];
                float leftBody = bodyPoints[0];
                float rightBody = bodyPoints[2];
                float high = shadowPoints[1];
                float low = shadowPoints[3];
                float open = bodyPoints[1];
                float close = bodyPoints[3];
                if (this.isOffContentRight(leftBody)) continue block0;
                if (!(this.isOffContentLeft(rightBody) && this.isOffContentTop(low) && this.isOffContentBottom(high))) {
                    this.mDrawCanvas.drawLine(xShadow, low, xShadow, high, this.mRenderPaint);
                    if (open > close) {
                        this.mRenderPaint.setStyle(Paint.Style.FILL);
                        this.mDrawCanvas.drawRect(leftBody, close, rightBody, open, this.mRenderPaint);
                    } else {
                        this.mRenderPaint.setStyle(Paint.Style.STROKE);
                        this.mDrawCanvas.drawRect(leftBody, open, rightBody, close, this.mRenderPaint);
                    }
                }
                ++j;
            }
        }
    }

    private void transformBody(float[] bodyPoints, CandleEntry e, float bodySpace) {
        bodyPoints[0] = (float)e.getXIndex() + bodySpace;
        bodyPoints[1] = e.getClose() * this.mPhaseY;
        bodyPoints[2] = (float)e.getXIndex() + (1.0f - bodySpace);
        bodyPoints[3] = e.getOpen() * this.mPhaseY;
        this.transformPointArray(bodyPoints);
    }

    private void transformShadow(float[] shadowPoints, CandleEntry e) {
        shadowPoints[0] = (float)e.getXIndex() + 0.5f;
        shadowPoints[1] = e.getHigh() * this.mPhaseY;
        shadowPoints[2] = (float)e.getXIndex() + 0.5f;
        shadowPoints[3] = e.getLow() * this.mPhaseY;
        this.transformPointArray(shadowPoints);
    }

    @Override
    protected void drawValues() {
    }

    @Override
    protected void drawAdditional() {
    }

    @Override
    protected void drawHighlights() {
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            int xIndex = this.mIndicesToHightlight[i].getXIndex();
            CandleDataSet set = (CandleDataSet)((CandleData)this.mOriginalData).getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            CandleEntry e = (CandleEntry)set.getEntryForXIndex(xIndex);
            if (e == null) continue;
            float low = e.getLow() * this.mPhaseY;
            float high = e.getHigh() * this.mPhaseY;
            float[] vertPts = new float[]{xIndex, this.mYChartMax, xIndex, this.mYChartMin, (float)xIndex + 1.0f, this.mYChartMax, (float)xIndex + 1.0f, this.mYChartMin};
            float[] horPts = new float[]{0.0f, low, this.mDeltaX, low, 0.0f, high, this.mDeltaX, high};
            this.transformPointArray(vertPts);
            this.transformPointArray(horPts);
            this.mDrawCanvas.drawLines(vertPts, this.mHighlightPaint);
            this.mDrawCanvas.drawLines(horPts, this.mHighlightPaint);
        }
    }
}

