/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public abstract class MarkerView
extends RelativeLayout {
    private float mXOffset = 0.0f;
    private float mYOffset = 0.0f;

    public MarkerView(Context context, int layoutResource) {
        super(context);
        this.setupLayoutResource(layoutResource);
    }

    private void setupLayoutResource(int layoutResource) {
        View inflated = LayoutInflater.from((Context)this.getContext()).inflate(layoutResource, (ViewGroup)this);
        inflated.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        inflated.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        inflated.layout(0, 0, inflated.getMeasuredWidth(), inflated.getMeasuredHeight());
    }

    public void draw(Canvas canvas, float posx, float posy) {
        canvas.translate(posx += this.mXOffset, posy += this.mYOffset);
        this.draw(canvas);
        canvas.translate(-posx, -posy);
    }

    public abstract void refreshContent(int var1, float var2, int var3);

    public void setOffsets(float x, float y) {
        this.mXOffset = x;
        this.mYOffset = y;
    }

    public float getXOffset() {
        return this.mXOffset;
    }

    public float getYOffset() {
        return this.mYOffset;
    }
}

