/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.Context;
import com.github.mikephil.charting.R;
import java.util.ArrayList;

public class ColorTemplate {
    public static final int[] FRESH_COLORS = new int[]{R.color.fresh_1, R.color.fresh_2, R.color.fresh_3, R.color.fresh_4, R.color.fresh_5};
    public static final int[] MONO_COLORS = new int[]{R.color.mono_1, R.color.mono_2, R.color.mono_3, R.color.mono_4, R.color.mono_5};
    public static final int[] LIBERTY_COLORS = new int[]{R.color.liberty_1, R.color.liberty_2, R.color.liberty_3, R.color.liberty_4, R.color.liberty_5};
    public static final int[] COLORFUL_COLORS = new int[]{R.color.colorful_1, R.color.colorful_2, R.color.colorful_3, R.color.colorful_4, R.color.colorful_5};
    public static final int[] GREEN_COLORS = new int[]{R.color.greens_1, R.color.greens_2, R.color.greens_3, R.color.greens_4, R.color.greens_5};
    public static final int[] JOYFUL_COLORS = new int[]{R.color.joyful_1, R.color.joyful_2, R.color.joyful_3, R.color.joyful_4, R.color.joyful_5};
    public static final int[] PASTEL_COLORS = new int[]{R.color.pastel_1, R.color.pastel_2, R.color.pastel_3, R.color.pastel_4, R.color.pastel_5};
    public static final int[] VORDIPLOM_COLORS = new int[]{R.color.vordiplom_1, R.color.vordiplom_2, R.color.vordiplom_3, R.color.vordiplom_4, R.color.vordiplom_5};
    private ArrayList<ArrayList<Integer>> mDataSetColors = new ArrayList();
    private int mColorCount = 0;

    public int getColorCount() {
        return this.mColorCount;
    }

    public void addDataSetColors(ArrayList<Integer> colors) {
        this.mDataSetColors.add(colors);
        this.mColorCount += colors.size();
    }

    public void addDataSetColors(int[] colors, Context c) {
        this.mDataSetColors.add(ColorTemplate.createColors(c, colors));
        this.mColorCount += colors.length;
    }

    public void addColorsForDataSets(ArrayList<Integer> colors) {
        for (int i = 0; i < colors.size(); ++i) {
            ArrayList<Integer> clrs = new ArrayList<Integer>();
            clrs.add(colors.get(i));
            this.addDataSetColors(clrs);
        }
    }

    public void addColorsForDataSets(int[] colors, Context c) {
        for (int i = 0; i < colors.length; ++i) {
            this.addDataSetColors(new int[]{colors[i]}, c);
        }
    }

    public void addDataSetColor(int color2, Context c) {
        this.addDataSetColors(new int[]{color2}, c);
    }

    public ArrayList<ArrayList<Integer>> getColors() {
        return this.mDataSetColors;
    }

    public int[] getColorsAsArray() {
        int[] colors = new int[this.mColorCount];
        int cnt = 0;
        for (int i = 0; i < this.mDataSetColors.size(); ++i) {
            for (int j = 0; j < this.mDataSetColors.get(i).size(); ++j) {
                colors[cnt] = this.mDataSetColors.get(i).get(j);
                ++cnt;
            }
        }
        return colors;
    }

    public ArrayList<Integer> getColorsAsArrayList() {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < this.mDataSetColors.size(); ++i) {
            for (int j = 0; j < this.mDataSetColors.get(i).size(); ++j) {
                colors.add(this.mDataSetColors.get(i).get(j));
            }
        }
        return colors;
    }

    public ArrayList<Integer> getDataSetColors(int dataSetIndex) {
        return this.mDataSetColors.get(dataSetIndex);
    }

    public int getDataSetColor(int dataSetIndex, int colorIndex) {
        return this.mDataSetColors.get(dataSetIndex).get(colorIndex % this.mDataSetColors.get(dataSetIndex).size());
    }

    public static ArrayList<Integer> createColors(Context c, int[] colors) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i : colors) {
            result.add(c.getResources().getColor(i));
        }
        return result;
    }

    public static ArrayList<Integer> createColors(int[] colors) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i : colors) {
            result.add(i);
        }
        return result;
    }
}

