/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DrawingContext;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.PointD;

public class BarLineChartTouchListener
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private Matrix mMatrix = new Matrix();
    private Matrix mSavedMatrix = new Matrix();
    private PointF mTouchStartPoint = new PointF();
    private PointF mTouchPointCenter = new PointF();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int POSTZOOM = 3;
    private static final int LONGPRESS = 4;
    private static final int DRAWING = 5;
    private static final int MOVE_POINT = 6;
    private static final int X_ZOOM = 7;
    private static final int Y_ZOOM = 8;
    private static final int PINCH_ZOOM = 9;
    private boolean mDrawingEnabled = false;
    private int mTouchMode = 0;
    private float mSavedXDist = 1.0f;
    private float mSavedYDist = 1.0f;
    private float mSavedDist = 1.0f;
    private long mStartTimestamp = 0L;
    private Highlight mLastHighlighted;
    private BarLineChartBase mChart;
    private DrawingContext mDrawingContext;
    private GestureDetector mGestureDetector;

    public BarLineChartTouchListener(BarLineChartBase chart, Matrix start) {
        this.mChart = chart;
        this.mMatrix = start;
        this.mGestureDetector = new GestureDetector(chart.getContext(), (GestureDetector.OnGestureListener)this);
        this.mDrawingContext = new DrawingContext();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mTouchMode == 0) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (!this.mChart.isDragEnabled() && !this.mDrawingEnabled) {
            return true;
        }
        this.mDrawingContext.init(this.mChart.getDrawListener(), this.mChart.isAutoFinishEnabled());
        ChartData data = this.mChart.getDataCurrent();
        switch (event.getAction() & 0xFF) {
            case 0: {
                if (event.getPointerCount() == 1 && this.mDrawingEnabled) {
                    if (this.mLastHighlighted != null) {
                        Entry highlightedEntry = this.mChart.getDataCurrent().getEntryForHighlight(this.mLastHighlighted);
                        Entry currentHoveredEntry = this.mChart.getEntryByTouchPoint(event.getX(), event.getY());
                        if (highlightedEntry != null && highlightedEntry == currentHoveredEntry) {
                            this.mTouchMode = 6;
                            this.mDrawingContext.setMovingEntry(currentHoveredEntry);
                            break;
                        }
                    }
                    this.mTouchMode = 5;
                    this.mStartTimestamp = System.currentTimeMillis();
                    this.mDrawingContext.createNewDrawingDataSet(data);
                    Log.i((String)"Drawing", (String)"New drawing data set created");
                } else {
                    this.mSavedMatrix.set(this.mMatrix);
                }
                this.mTouchStartPoint.set(event.getX(), event.getY());
                break;
            }
            case 5: {
                if (event.getPointerCount() != 2) break;
                long deltaT = System.currentTimeMillis() - this.mStartTimestamp;
                if ((this.mTouchMode != 5 || deltaT >= 1000L) && this.mDrawingEnabled) break;
                this.mDrawingContext.deleteLastDrawingEntry(data);
                this.mSavedXDist = BarLineChartTouchListener.getXDist(event);
                this.mSavedYDist = BarLineChartTouchListener.getYDist(event);
                this.mSavedDist = BarLineChartTouchListener.spacing(event);
                if (!(this.mSavedDist > 10.0f)) break;
                this.mTouchMode = this.mChart.isPinchZoomEnabled() ? 9 : (this.mSavedXDist > this.mSavedYDist ? 7 : 8);
                this.mSavedMatrix.set(this.mMatrix);
                BarLineChartTouchListener.midPoint(this.mTouchPointCenter, event);
                this.mChart.disableScroll();
                break;
            }
            case 1: 
            case 3: {
                if (this.mTouchMode == 5) {
                    long deltaT = System.currentTimeMillis() - this.mStartTimestamp;
                    if (deltaT < 1000L && Math.abs(event.getX() - this.mTouchStartPoint.x) < 25.0f) {
                        this.mDrawingContext.deleteLastDrawingEntry(data);
                        this.onSingleTapConfirmed(event);
                        Log.i((String)"Drawing", (String)"Drawing aborted");
                    } else {
                        this.mDrawingContext.finishNewDrawingEntry(data);
                        this.mChart.notifyDataSetChanged();
                        Log.i((String)"Drawing", (String)"Drawing finished");
                    }
                } else {
                    this.mChart.enableScroll();
                }
                this.mDrawingContext.setMovingEntry(null);
                this.mTouchMode = 0;
                break;
            }
            case 6: {
                this.mTouchMode = 3;
                break;
            }
            case 2: {
                if (this.mTouchMode == 5 || this.mTouchMode == 6) {
                    PointD p = this.mChart.getValuesByTouchPoint(event.getX(), event.getY());
                    int xIndex = (int)p.x;
                    float yVal = (float)p.y;
                    if (xIndex < 0) {
                        xIndex = 0;
                    }
                    if (xIndex >= data.getXValCount()) {
                        xIndex = data.getXValCount() - 1;
                    }
                    boolean added = false;
                    if (this.mTouchMode == 6) {
                        this.mDrawingContext.getMovingEntry().setVal(yVal);
                        this.mDrawingContext.notifyEntryMoved(data);
                        added = true;
                    } else {
                        Entry entry = new Entry(yVal, xIndex);
                        added = this.mDrawingContext.addNewDrawingEntry(entry, data);
                    }
                    if (!added) break;
                    this.mChart.notifyDataSetChanged();
                    break;
                }
                if ((this.mTouchMode == 0 && !this.mDrawingEnabled || this.mTouchMode != 1 && event.getPointerCount() == 3) && Math.abs(BarLineChartTouchListener.distance(event.getX(), this.mTouchStartPoint.x, event.getY(), this.mTouchStartPoint.y)) > 25.0f) {
                    this.mSavedMatrix.set(this.mMatrix);
                    this.mTouchStartPoint.set(event.getX(), event.getY());
                    this.mTouchMode = 1;
                    this.mChart.disableScroll();
                    break;
                }
                if (this.mTouchMode == 1) {
                    this.mMatrix.set(this.mSavedMatrix);
                    PointF dragPoint = new PointF(event.getX(), event.getY());
                    this.mMatrix.postTranslate(dragPoint.x - this.mTouchStartPoint.x, dragPoint.y - this.mTouchStartPoint.y);
                    break;
                }
                if (this.mTouchMode == 7 || this.mTouchMode == 8 || this.mTouchMode == 9) {
                    float totalDist = BarLineChartTouchListener.spacing(event);
                    if (!(totalDist > 10.0f)) break;
                    float[] values = new float[9];
                    this.mMatrix.getValues(values);
                    PointF t = this.getTrans(this.mTouchPointCenter.x, this.mTouchPointCenter.y);
                    if (this.mTouchMode == 9) {
                        float scale = totalDist / this.mSavedDist;
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(scale, scale, t.x, t.y);
                        break;
                    }
                    if (this.mTouchMode == 7) {
                        float xDist = BarLineChartTouchListener.getXDist(event);
                        float scaleX = xDist / this.mSavedXDist;
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(scaleX, 1.0f, t.x, t.y);
                        break;
                    }
                    if (this.mTouchMode != 8) break;
                    float yDist = BarLineChartTouchListener.getYDist(event);
                    float scaleY = yDist / this.mSavedYDist;
                    this.mMatrix.set(this.mSavedMatrix);
                    this.mMatrix.postScale(1.0f, scaleY, t.x, t.y);
                    break;
                }
                if (this.mTouchMode != 4) break;
                this.mChart.disableScroll();
            }
        }
        this.mMatrix = this.mChart.refreshTouch(this.mMatrix);
        return true;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    public void setDrawingEnabled(boolean mDrawingEnabled) {
        this.mDrawingEnabled = mDrawingEnabled;
    }

    private static float distance(float eventX, float startX, float eventY, float startY) {
        float dx = eventX - startX;
        float dy = eventY - startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    private static void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    private static float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private static float getXDist(MotionEvent e) {
        float x = Math.abs(e.getX(0) - e.getX(1));
        return x;
    }

    private static float getYDist(MotionEvent e) {
        float y = Math.abs(e.getY(0) - e.getY(1));
        return y;
    }

    public PointF getTrans(float x, float y) {
        float xTrans = x - this.mChart.getOffsetLeft();
        float yTrans = -((float)this.mChart.getMeasuredHeight() - y - this.mChart.getOffsetBottom());
        return new PointF(xTrans, yTrans);
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        Highlight h = this.mChart.getHighlightByTouchPoint(e.getX(), e.getY());
        if (h == null || h.equalTo(this.mLastHighlighted)) {
            this.mChart.highlightValues(null);
            this.mLastHighlighted = null;
        } else {
            this.mLastHighlighted = h;
            this.mChart.highlightValues(new Highlight[]{h});
        }
        return super.onSingleTapConfirmed(e);
    }

    public boolean onDoubleTap(MotionEvent e) {
        PointF trans = this.getTrans(e.getX(), e.getY());
        this.mChart.zoomIn(trans.x, trans.y);
        Log.i((String)"BarlineChartTouch", (String)("Double-Tap, Zooming In, x: " + trans.x + ", y: " + trans.y));
        return super.onDoubleTap(e);
    }

    public void onLongPress(MotionEvent e) {
        PointF trans = this.getTrans(e.getX(), e.getY());
        this.mChart.zoomOut(trans.x, trans.y);
        Log.i((String)"BarlineChartTouch", (String)("Longpress, Zooming Out, x: " + trans.x + ", y: " + trans.y));
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return true;
    }
}

