/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.exception.DrawingDataSetNotCreatedException;
import com.github.mikephil.charting.interfaces.OnDrawListener;
import java.util.ArrayList;

public class DrawingContext {
    private DataSet mCurrentDrawingDataSet;
    private int mLastDrawnDataSetIndex = 0;
    private boolean mAutoFinishDrawing = false;
    private ArrayList<Entry> mCurrentDrawingEntries;
    private Entry mMovingEntry;
    private OnDrawListener mListener;

    public void createNewDrawingDataSet(ChartData chartData) {
        if (this.mCurrentDrawingDataSet != null && this.mCurrentDrawingEntries != null) {
            this.finishNewDrawingEntry(chartData);
        }
        this.mCurrentDrawingEntries = new ArrayList();
        this.mCurrentDrawingDataSet = new DataSet(this.mCurrentDrawingEntries, "DS " + this.mLastDrawnDataSetIndex);
        chartData.getDataSets().add(this.mCurrentDrawingDataSet);
    }

    public boolean addNewDrawingEntry(Entry entry, ChartData data) {
        if (this.mCurrentDrawingDataSet != null && this.mCurrentDrawingEntries != null) {
            if (this.mCurrentDrawingEntries.size() > 0 && this.mCurrentDrawingEntries.get(this.mCurrentDrawingEntries.size() - 1).getXIndex() == entry.getXIndex()) {
                return false;
            }
            if (this.mCurrentDrawingEntries.size() > 0) {
                Entry prevEntry = this.mCurrentDrawingEntries.get(this.mCurrentDrawingEntries.size() - 1);
                this.fillData(prevEntry, entry);
            }
            this.mCurrentDrawingEntries.add(entry);
            data.notifyDataForNewEntry(entry);
            if (this.mListener != null) {
                this.mListener.onEntryAdded(entry);
            }
            this.mCurrentDrawingDataSet.notifyDataSetChanged();
            return true;
        }
        throw new DrawingDataSetNotCreatedException();
    }

    public void notifyEntryMoved(ChartData data) {
        data.notifyDataForNewEntry(this.mMovingEntry);
        if (this.mListener != null) {
            this.mListener.onEntryMoved(this.mMovingEntry);
        }
    }

    private void fillData(Entry prevEntry, Entry newEntry) {
        int skippedIndexes = newEntry.getXIndex() - prevEntry.getXIndex();
        int startIndex = prevEntry.getXIndex();
        if (skippedIndexes == -1 || skippedIndexes == 1) {
            return;
        }
        if (--skippedIndexes < 0) {
            skippedIndexes *= -1;
            for (int i = 1; i < skippedIndexes; ++i) {
                Entry entry = new Entry(newEntry.getVal(), startIndex - i);
                this.mCurrentDrawingEntries.add(entry);
                if (this.mListener == null) continue;
                this.mListener.onEntryAdded(entry);
            }
        } else {
            for (int i = 1; i <= skippedIndexes; ++i) {
                Entry entry = new Entry(newEntry.getVal(), startIndex + i);
                this.mCurrentDrawingEntries.add(entry);
                if (this.mListener == null) continue;
                this.mListener.onEntryAdded(entry);
            }
        }
    }

    public void finishNewDrawingEntry(ChartData data) {
        if (this.mAutoFinishDrawing && this.mCurrentDrawingEntries.size() > 0) {
            int xIndex;
            Entry firstEntry = this.mCurrentDrawingEntries.get(0);
            for (xIndex = 0; xIndex < firstEntry.getXIndex(); ++xIndex) {
                Entry entry = new Entry(firstEntry.getVal(), xIndex);
                this.mCurrentDrawingEntries.add(xIndex, entry);
                data.notifyDataForNewEntry(entry);
            }
            Entry lastEntry = this.mCurrentDrawingEntries.get(this.mCurrentDrawingEntries.size() - 1);
            for (xIndex = lastEntry.getXIndex(); xIndex < data.getXValCount(); ++xIndex) {
                Entry entry = new Entry(lastEntry.getVal(), xIndex);
                this.mCurrentDrawingEntries.add(entry);
                data.notifyDataForNewEntry(entry);
            }
        } else if (this.mCurrentDrawingEntries.size() == 0) {
            this.deleteLastDrawingEntry(data);
            return;
        }
        ++this.mLastDrawnDataSetIndex;
        this.mCurrentDrawingDataSet.notifyDataSetChanged();
        if (this.mListener != null) {
            this.mListener.onDrawFinished(this.mCurrentDrawingDataSet);
        }
        this.mCurrentDrawingDataSet = null;
        this.mCurrentDrawingEntries = null;
    }

    public void deleteLastDrawingEntry(ChartData data) {
        data.getDataSets().remove(this.mCurrentDrawingDataSet);
        this.mCurrentDrawingDataSet = null;
        this.mCurrentDrawingEntries = null;
    }

    public void init(OnDrawListener mListener, boolean autoFinish) {
        this.mListener = mListener;
        this.mAutoFinishDrawing = autoFinish;
    }

    public void setMovingEntry(Entry entry) {
        this.mMovingEntry = entry;
    }

    public Entry getMovingEntry() {
        return this.mMovingEntry;
    }
}

