/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Highlight;
import java.util.ArrayList;

public class ChartData {
    private float mYMax = 0.0f;
    private float mYMin = 0.0f;
    private float mYValueSum = 0.0f;
    private ArrayList<String> mXVals;
    private ArrayList<DataSet> mDataSets;

    public ChartData(ArrayList<String> xVals, ArrayList<DataSet> dataSets) {
        this.init(xVals, dataSets);
    }

    public ChartData(String[] xVals, ArrayList<DataSet> dataSets) {
        ArrayList<String> newXVals = new ArrayList<String>();
        for (int i = 0; i < xVals.length; ++i) {
            newXVals.add(xVals[i]);
        }
        this.init(newXVals, dataSets);
    }

    public ChartData(ArrayList<String> xVals, DataSet data) {
        ArrayList<DataSet> sets = new ArrayList<DataSet>();
        sets.add(data);
        this.init(xVals, sets);
    }

    private void init(ArrayList<String> xVals, ArrayList<DataSet> dataSets) {
        this.mXVals = xVals;
        this.mDataSets = dataSets;
        this.calcMinMax();
        this.calcYValueSum();
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            if (this.mDataSets.get(i).getYVals().size() <= xVals.size()) continue;
            throw new IllegalArgumentException("One or more of the DataSet Entry arrays are longer than the x-values array.");
        }
    }

    public void notifyDataChanged() {
        this.doCalculations();
    }

    private void doCalculations() {
        this.calcMinMax();
        this.calcYValueSum();
    }

    private void calcMinMax() {
        ArrayList<DataSet> dataSets = this.mDataSets;
        this.mYMin = dataSets.get(0).getYMin();
        this.mYMax = dataSets.get(0).getYMax();
        for (int i = 0; i < dataSets.size(); ++i) {
            if (dataSets.get(i).getYMin() < this.mYMin) {
                this.mYMin = dataSets.get(i).getYMin();
            }
            if (!(dataSets.get(i).getYMax() > this.mYMax)) continue;
            this.mYMax = dataSets.get(i).getYMax();
        }
    }

    private void calcYValueSum() {
        this.mYValueSum = 0.0f;
        ArrayList<DataSet> dataSets = this.mDataSets;
        for (int i = 0; i < dataSets.size(); ++i) {
            this.mYValueSum += Math.abs(dataSets.get(i).getYValueSum());
        }
    }

    public void notifyDataForNewEntry(Entry entry) {
        this.mYValueSum += Math.abs(entry.getVal());
        if (this.mYMin > entry.getVal()) {
            this.mYMin = entry.getVal();
        }
        if (this.mYMax < entry.getVal()) {
            this.mYMax = entry.getVal();
        }
    }

    public int getDataSetCount() {
        return this.mDataSets.size();
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public boolean isValid() {
        if (this.mXVals == null || this.mXVals.size() <= 1) {
            return false;
        }
        return this.mDataSets != null && this.mDataSets.size() >= 1;
    }

    public ArrayList<String> getXVals() {
        return this.mXVals;
    }

    public ArrayList<Entry> getYVals(int index) {
        return this.mDataSets.get(index).getYVals();
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        return this.getDataSetByIndex(highlight.getDataSetIndex()).getEntryForXIndex(highlight.getXIndex());
    }

    public DataSet getDataSetByIndex(int index) {
        return this.mDataSets.get(index);
    }

    public DataSet getDataSetByLabel(String label, boolean ignorecase) {
        ArrayList<DataSet> dataSets = this.mDataSets;
        if (ignorecase) {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equalsIgnoreCase(dataSets.get(i).getLabel())) continue;
                return dataSets.get(i);
            }
        } else {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equals(dataSets.get(i).getLabel())) continue;
                return dataSets.get(i);
            }
        }
        return null;
    }

    public ArrayList<DataSet> getDataSets() {
        return this.mDataSets;
    }

    public ArrayList<DataSet> getOriginalDataSets() {
        return this.mDataSets;
    }

    public int getXValCount() {
        return this.mXVals.size();
    }

    public int getYValCount() {
        int count = 0;
        ArrayList<DataSet> dataSets = this.mDataSets;
        for (int i = 0; i < dataSets.size(); ++i) {
            count += dataSets.get(i).getEntryCount();
        }
        return count;
    }

    public String[] getDataSetLabels() {
        String[] types = new String[this.mDataSets.size()];
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            types[i] = this.mDataSets.get(i).getLabel();
        }
        return types;
    }

    public static ArrayList<String> generateXVals(int from, int to) {
        ArrayList<String> xvals = new ArrayList<String>();
        for (int i = from; i < to; ++i) {
            xvals.add("" + i);
        }
        return xvals;
    }
}

