/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.ColorTemplate;
import java.util.ArrayList;

public class BarChart
extends BarLineChartBase {
    private float mBarSpace = 0.15f;
    private float mSkew = 0.3f;
    private float mDepth = 0.3f;
    private boolean m3DEnabled = false;
    private boolean mDrawHighlightArrow = false;
    private ArrayList<ArrayList<Integer>> mTopColors;
    private ArrayList<ArrayList<Integer>> mSideColors;
    private RectF mBarRect = new RectF();

    public BarChart(Context context) {
        super(context);
    }

    public BarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
        this.mHighlightPaint.setAlpha(120);
        this.calculate3DColors();
    }

    @Override
    public void setColorTemplate(ColorTemplate ct) {
        super.setColorTemplate(ct);
        this.calculate3DColors();
    }

    protected void calculate3DColors() {
        this.mTopColors = new ArrayList();
        this.mSideColors = new ArrayList();
        float[] hsv = new float[3];
        for (int i = 0; i < this.mCt.getColors().size(); ++i) {
            ArrayList<Integer> colors = this.mCt.getDataSetColors(i);
            ArrayList<Integer> topColors = new ArrayList<Integer>();
            ArrayList<Integer> sideColors = new ArrayList<Integer>();
            for (int j = 0; j < colors.size(); ++j) {
                int c = colors.get(j);
                Color.colorToHSV((int)c, (float[])hsv);
                hsv[1] = hsv[1] - 0.1f;
                hsv[2] = hsv[2] + 0.1f;
                c = Color.HSVToColor((float[])hsv);
                topColors.add(c);
                c = colors.get(j);
                Color.colorToHSV((int)c, (float[])hsv);
                hsv[1] = hsv[1] + 0.1f;
                hsv[2] = hsv[2] - 0.1f;
                c = Color.HSVToColor((float[])hsv);
                sideColors.add(c);
            }
            this.mTopColors.add(topColors);
            this.mSideColors.add(sideColors);
        }
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        if (!this.mStartAtZero && this.getYMin() >= 0.0f) {
            this.mYChartMin = this.getYMin();
            this.mDeltaY = Math.abs(this.mYChartMax - this.mYChartMin);
        }
        this.mDeltaX += 1.0f;
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.mHighLightIndicatorEnabled && this.valuesToHighlight()) {
            float offsetY = this.mDeltaY * 0.04f;
            for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
                int index = this.mIndicesToHightlight[i].getXIndex();
                if (index >= this.mCurrentData.getYValCount() || index < 0) continue;
                this.mHighlightPaint.setAlpha(120);
                float y = this.getYValueByDataSetIndex(index, this.mIndicesToHightlight[i].getDataSetIndex());
                float left = (float)index + this.mBarSpace / 2.0f;
                float right = (float)index + 1.0f - this.mBarSpace / 2.0f;
                float top = y >= 0.0f ? y : 0.0f;
                float bottom = y <= 0.0f ? y : 0.0f;
                RectF highlight = new RectF(left, top, right, bottom);
                this.transformRect(highlight);
                this.mDrawCanvas.drawRect(highlight, this.mHighlightPaint);
                if (!this.mDrawHighlightArrow) continue;
                this.mHighlightPaint.setAlpha(200);
                Path arrow = new Path();
                arrow.moveTo((float)index + 0.5f, y + offsetY * 0.3f);
                arrow.lineTo((float)index + 0.2f, y + offsetY);
                arrow.lineTo((float)index + 0.8f, y + offsetY);
                this.transformPath(arrow);
                this.mDrawCanvas.drawPath(arrow, this.mHighlightPaint);
            }
        }
    }

    @Override
    protected void drawData() {
        ArrayList<Path> topPaths = new ArrayList<Path>();
        ArrayList<Path> sidePaths = new ArrayList<Path>();
        ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
        if (this.m3DEnabled) {
            float[] pts = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
            this.transformPointArray(pts);
            pts[3] = pts[2] - pts[0];
            pts[2] = 0.0f;
            pts[1] = 0.0f;
            pts[0] = 0.0f;
            Matrix invert = new Matrix();
            this.mMatrixOffset.invert(invert);
            invert.mapPoints(pts);
            this.mMatrixTouch.invert(invert);
            invert.mapPoints(pts);
            this.mMatrixValueToPx.invert(invert);
            invert.mapPoints(pts);
            float depth = Math.abs(pts[3] - pts[1]) * this.mDepth;
            for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
                DataSet dataSet = dataSets.get(i);
                ArrayList<Entry> series = dataSet.getYVals();
                for (int j = 0; j < series.size(); ++j) {
                    float x = series.get(j).getXIndex();
                    float y = series.get(j).getVal();
                    float left = x + this.mBarSpace / 2.0f;
                    float right = x + 1.0f - this.mBarSpace / 2.0f;
                    float top = y >= 0.0f ? y : 0.0f;
                    Path topPath = new Path();
                    topPath.moveTo(left, top);
                    topPath.lineTo(left + this.mSkew, top + depth);
                    topPath.lineTo(right + this.mSkew, top + depth);
                    topPath.lineTo(right, top);
                    topPaths.add(topPath);
                    Path sidePath = new Path();
                    sidePath.moveTo(right, top);
                    sidePath.lineTo(right + this.mSkew, top + depth);
                    sidePath.lineTo(right + this.mSkew, depth);
                    sidePath.lineTo(right, 0.0f);
                    sidePaths.add(sidePath);
                }
            }
            this.transformPaths(topPaths);
            this.transformPaths(sidePaths);
        }
        int cnt = 0;
        block2: for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet dataSet = dataSets.get(i);
            ArrayList<Entry> series = dataSet.getYVals();
            ArrayList<Integer> colors = this.mCt.getDataSetColors(i % this.mCt.getColors().size());
            ArrayList<Integer> colors3DTop = this.mTopColors.get(i % this.mCt.getColors().size());
            ArrayList<Integer> colors3DSide = this.mSideColors.get(i % this.mCt.getColors().size());
            for (int j = 0; j < dataSet.getEntryCount(); ++j) {
                this.mRenderPaint.setColor(colors.get(j % colors.size()).intValue());
                int x = series.get(j).getXIndex();
                float y = series.get(j).getVal();
                float left = (float)x + this.mBarSpace / 2.0f;
                float right = (float)x + 1.0f - this.mBarSpace / 2.0f;
                float top = y >= 0.0f ? y : 0.0f;
                float bottom = y <= 0.0f ? y : 0.0f;
                this.mBarRect.set(left, top, right, bottom);
                this.transformRect(this.mBarRect);
                if (this.isOffContentRight(this.mBarRect.left)) continue block2;
                if (this.isOffContentLeft(this.mBarRect.right)) {
                    ++cnt;
                    continue;
                }
                this.mDrawCanvas.drawRect(this.mBarRect, this.mRenderPaint);
                if (this.m3DEnabled) {
                    this.mRenderPaint.setColor(colors3DTop.get(j % colors3DTop.size()).intValue());
                    this.mDrawCanvas.drawPath(topPaths.get(cnt), this.mRenderPaint);
                    this.mRenderPaint.setColor(colors3DSide.get(j % colors3DSide.size()).intValue());
                    this.mDrawCanvas.drawPath(sidePaths.get(cnt), this.mRenderPaint);
                }
                ++cnt;
            }
        }
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues && (float)this.mCurrentData.getYValCount() < (float)this.mMaxVisibleCount * this.mScaleX) {
            ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
            for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
                DataSet dataSet = dataSets.get(i);
                ArrayList<Entry> series = dataSet.getYVals();
                float[] valuePoints = this.generateTransformedValues(series, 0.5f);
                for (int j = 0; j < valuePoints.length && !this.isOffContentRight(valuePoints[j]); j += 2) {
                    if (this.isOffContentLeft(valuePoints[j])) continue;
                    float val = series.get(j / 2).getVal();
                    if (this.mDrawUnitInChart) {
                        this.mDrawCanvas.drawText(this.mFormatValue.format(val) + this.mUnit, valuePoints[j], valuePoints[j + 1] - 12.0f, this.mValuePaint);
                        continue;
                    }
                    this.mDrawCanvas.drawText(this.mFormatValue.format(val), valuePoints[j], valuePoints[j + 1] - 12.0f, this.mValuePaint);
                }
            }
        }
    }

    public void setSkew(float skew) {
        this.mSkew = skew;
    }

    public float getSkew() {
        return this.mSkew;
    }

    public void setDepth(float depth) {
        this.mDepth = depth;
    }

    public float getDepth() {
        return this.mDepth;
    }

    public float getBarSpace() {
        return this.mBarSpace * 100.0f;
    }

    public void setBarSpace(float percent) {
        this.mBarSpace = percent / 100.0f;
    }

    public void set3DEnabled(boolean enabled) {
        this.m3DEnabled = enabled;
    }

    public boolean is3DEnabled() {
        return this.m3DEnabled;
    }

    public void setDrawHighlightArrow(boolean enabled) {
        this.mDrawHighlightArrow = enabled;
    }

    public boolean isDrawHighlightArrowEnabled() {
        return this.mDrawHighlightArrow;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 16: {
                this.mHighlightPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        super.getPaint(which);
        switch (which) {
            case 16: {
                return this.mHighlightPaint;
            }
        }
        return null;
    }

    @Override
    protected void drawAdditional() {
    }
}

