/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.res.AssetManager;
import android.os.Environment;
import android.util.Log;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class FileUtils {
    private static final String LOG = "MPChart-FileUtils";

    public static DataSet dataSetFromFile(String path) {
        File sdcard = Environment.getExternalStorageDirectory();
        File file = new File(sdcard, path);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String label = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            label = line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] split = line.split("#");
                entries.add(new Entry(Float.parseFloat(split[0]), Integer.parseInt(split[1])));
            }
        }
        catch (IOException e) {
            Log.e((String)LOG, (String)e.toString());
        }
        DataSet ds = new DataSet(entries, label);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet dataSetFromAssets(AssetManager am, String path) {
        String label = null;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(am.open(path), "UTF-8"));
            label = reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                String[] split = line.split("#");
                entries.add(new Entry(Float.parseFloat(split[0]), Integer.parseInt(split[1])));
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Log.e((String)LOG, (String)e.toString());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)LOG, (String)e.toString());
                }
            }
        }
        DataSet ds = new DataSet(entries, label);
        return ds;
    }

    public static void saveToSdCard(DataSet ds, String path) {
        File sdcard = Environment.getExternalStorageDirectory();
        File saved = new File(sdcard, path);
        if (!saved.exists()) {
            try {
                saved.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)LOG, (String)e.toString());
            }
        }
        try {
            BufferedWriter buf = new BufferedWriter(new FileWriter(saved, true));
            buf.append(ds.getLabel());
            buf.newLine();
            ArrayList<Entry> entries = ds.getYVals();
            for (Entry e : entries) {
                buf.append(e.getVal() + "#" + e.getXIndex());
                buf.newLine();
            }
            buf.close();
        }
        catch (IOException e) {
            Log.e((String)LOG, (String)e.toString());
        }
    }
}

