/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.utils.Utils;

public class Legend {
    private int[] mColors;
    private String[] mLegendLabels;
    private LegendPosition mPosition = LegendPosition.BELOW_CHART;
    private LegendForm mShape = LegendForm.SQUARE;
    private Typeface mTypeface = null;
    private float mFormSize = Utils.convertDpToPixel(this.mFormSize);
    private float mEntrySpace = this.mFormSize * 2.0f;
    private float mFormToTextSpace = this.mFormSize * 2.0f;

    public Legend() {
    }

    public Legend(int[] colors, String[] labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = colors;
        this.mLegendLabels = labels;
    }

    public int getMaximumEntryLength(Paint p) {
        int max = 0;
        for (int i = 0; i < this.mLegendLabels.length; ++i) {
            int length;
            if (this.mLegendLabels[i] == null || (length = Utils.calcTextWidth(p, this.mLegendLabels[i])) <= max) continue;
            max = length;
        }
        return max + (int)this.mFormSize * 4;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public String[] getLegendLabels() {
        return this.mLegendLabels;
    }

    public void setLegendLabels(String[] labels) {
        if (this.mColors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mLegendLabels = labels;
    }

    public LegendPosition getPosition() {
        return this.mPosition;
    }

    public void setPosition(LegendPosition pos) {
        this.mPosition = pos;
    }

    public LegendForm getForm() {
        return this.mShape;
    }

    public void setForm(LegendForm shape) {
        this.mShape = shape;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(Typeface tf) {
        this.mTypeface = tf;
    }

    public void setFormSize(float size) {
        this.mFormSize = Utils.convertDpToPixel(size);
    }

    public float getFormSize() {
        return this.mFormSize;
    }

    public float getEntrySpace() {
        return this.mEntrySpace;
    }

    public void setEntrySpace(float space) {
        this.mEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getFormToTextSpace() {
        return this.mFormToTextSpace;
    }

    public void setFormToTextSpace(float space) {
        this.mFormToTextSpace = Utils.convertDpToPixel(space);
    }

    public void drawForm(Canvas c, float x, float y, Paint p, int index) {
        p.setColor(this.mColors[index]);
        float half = this.mFormSize / 2.0f;
        switch (this.getForm()) {
            case CIRCLE: {
                c.drawCircle(x + half, y + half, half, p);
                break;
            }
            case SQUARE: {
                c.drawRect(x, y, x + this.mFormSize, y + this.mFormSize, p);
                break;
            }
            case LINE: {
                c.drawLine(x - half, y + half, x + half, y + half, p);
            }
        }
    }

    public void drawLabel(Canvas c, float x, float y, Paint p, int index) {
        c.drawText(this.mLegendLabels[index], x, y, p);
    }

    public void apply(Legend l) {
        this.mPosition = l.mPosition;
        this.mShape = l.mShape;
        this.mTypeface = l.mTypeface;
        this.mFormSize = l.mFormSize;
        this.mEntrySpace = l.mEntrySpace;
        this.mFormToTextSpace = l.mFormToTextSpace;
    }

    public static enum LegendForm {
        SQUARE,
        CIRCLE,
        LINE;

    }

    public static enum LegendPosition {
        LEFT_OF_CHART,
        BELOW_CHART;

    }
}

